<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//Naver Style
function point_paging($write_pages, $cur_page, $total_page, $url, $add="") {

	if(!$cur_page) $cur_page = 1;
	if(!$total_page) $total_page = 1;

	$str = '';

	if ($cur_page < 2) {
		//$str .= '<a class="direction" title="맨앞페이지"><span>‹‹</span><em>맨앞</em></a>';
	} else {
		$str .= '<a href="'.$url.'1'.$add.'" class="direction" title="맨앞페이지"><span>처음</span></a>';
	}

	$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
	$end_page = $start_page + $write_pages - 1;

	if ($end_page >= $total_page) { 
		$end_page = $total_page;
	}

	if ($start_page > 1) { 
		$str .= '<a href="'.$url.($start_page-1).$add.'" class="direction" title="이전페이지"><span>이전</span></a>'; 
	} else {
		//$str .= '<a class="direction" title="이전페이지"><span>‹</span><em>이전</em></a>'; 
	}

	if ($total_page > 0){
		for ($k=$start_page;$k<=$end_page;$k++){
			if ($cur_page != $k) {
				$str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>';
			} else {
				$str .= '<strong>'.$k.'</strong> ';
			}
		}
	}

	if ($total_page > $end_page) {
		$str .= '<a href="'.$url.($end_page+1).$add.'" class="direction" title="다음페이지"><span>다음</span></a>';
	} else {
		//$str .= '<a class="direction" title="다음페이지"><em>다음</em><span>›</span></a>';
	}

	if ($cur_page < $total_page) {
		$str .= '<a href="'.$url.($total_page).$add.'" class="direction" title="맨뒤페이지"><span>맨뒤</span></a>';
	} else {
		//$str .= '<a class="direction" title="맨뒤페이지"><em>맨뒤</em><span>››</span></a>';
	}

	return $str;
}

?>

<link rel="stylesheet" href="<?php echo $point_skin_url; ?>/point.css">

<section id="at-point">
	<div class="point-tab">
		<ul>
			<li<?php echo ($action == '' || $action == 'ap') ? ' class="on"' : ''; ?>><a href="./point.php?action=ap"><i class="fa fa-leaf"></i> AP 내역</a></li>
			<li<?php echo ($action == 'mp') ? ' class="on"' : ''; ?>><a href="./point.php?action=mp"><i class="fa fa-plus-circle"></i> MP 내역</a></li>
			<li<?php echo ($action == 'form') ? ' class="on"' : ''; ?>><a href="./point.php?action=form"><i class="fa fa-chevron-circle-right"></i> AP를 MP로 전환</a></li>
		</ul>
		<div class="clear"></div>
	</div>
	<div class="clear"></div>

<?php if($action == "form") { ?>
	<form name="fexchange" action="./point.php" onsubmit="return fexchange_submit(this);" method="post" autocomplete="off" data-ajax="false">
	<input type="hidden" name="action" value="exchange">

	<div class="msg-box box-black">
		<i class="fa fa-chevron-circle-right"></i> AP를 MP로 전환하기
	</div>

	<div class="box-exchange">
	    이미 MP로 전환된 AP를 취소하거나, 다시 AP로 전환하실 수는 없습니다.<br>
		MP로 전환하실 AP를 <b>양수(+)</b>로 입력해 주세요.
	
		<p>	
			<span class="btn-ok">
			<a class="over">
				<i class="fa fa-leaf"></i> 보유 AP : <b><?php echo number_format((int)$member['mb_7']);?></b> 
				&nbsp; <i class="fa fa-arrow-right"></i> &nbsp;
				<i class="fa fa-plus-circle"></i> 보유 MP : <b><?php echo number_format((int)$member['mb_point']);?></b>
			</a>
			</span>
		</p>
		<p>
			<input type="text" id="point" name="point" required placeholder="양수 AP 입력">
			<button type="submit"><i class="fa fa-refresh"></i> 전환하기</button>
		</p>
	</div>
	</form>

	<script>
		function fexchange_submit(f) {
			if (confirm('AP를 MP로 전환합니까?')) {
				if(f.point.value > 0) {
					;
				} else {
					alert('MP로 전환하실 AP를 양수로 입력해 주세요.');
					f.point.focus();
					return false;
				}
			} else {
				f.point.focus();
				return false;
			}

			return true;
		}
	</script>

<?php } else { ?>

	<div class="msg-box box-black">
		<i class="fa fa-user"></i> <?php echo $g5['title']; ?>
	</div>

	<table class="point-list">
	<tr>
        <th scope="col"><i class="fa fa-clock-o"></i> 일시</th>
	    <th scope="col"><i class="fa fa-check-circle"></i> 내용</th>
        <th scope="col"><i class="fa fa-times-circle"></i> 만료일</th>
	    <th scope="col"><i class="fa fa-plus-circle"></i> 적립</th>
		<th scope="col"><i class="fa fa-minus-circle"></i> 사용</th>
    </tr>
	<?php for ($i=0; $i < count($list); $i++) { ?>
	    <tr>
        <td><?php echo $list[$i]['po_datetime']; ?></td>
	    <td class="point-subject"><?php echo $list[$i]['po_content']; ?></td>
		<?php if($list[$i]['po_expired'] == 1) { ?>
			<td>만료<?php echo $list[$i]['expire_date']; ?></td>
		<?php } else {?>
			<td><?php echo $list[$i]['expire_date']; ?></td>
		<?php } ?>
	    <td class="cnt"><?php echo $list[$i]['point1']; ?></td>
        <td class="cnt"><?php echo $list[$i]['point2']; ?></td>
		</tr>
	<?php } ?>
	<?php if ($i == 0) echo '<tr><td colspan="5" class="no-data">자료가 없습니다.</td></tr>'; ?>
    <tr class="active">
	    <th scope="row" colspan="3">소계</th>
        <th class="cnt"><?php echo $sum_point1; ?></th>
		<th class="cnt"><?php echo $sum_point2; ?></th>
	</tr>
    <tr>
		<td scope="row" colspan="3"><b><?php echo $my_title?></b></td>
	    <td colspan="2" class="cnt"><b><?php echo $my_point?></b></td>
    </tr>
	</table>

	<div class="paginate">
		<?php echo point_paging($page_rows, $page, $total_page, $_SERVER['PHP_SELF'].'?action='.$action.$qstr.'&page='); ?>
	</div>
<?php } ?>

	<p align="center">
		 <span class="btn-ok"><a href="javascript:window.close();"><i class="fa fa-times-circle fa-lg"></i> 창닫기</a></span>
	</p>

</section>
