<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가 

//Naver Style
function response_paging($write_pages, $cur_page, $total_page, $url, $add="") {

		if(!$cur_page) $cur_page = 1;
		if(!$total_page) $total_page = 1;

		$str = '';

		if ($cur_page < 2) {
			//$str .= '<a class="direction" title="맨앞페이지"><span>‹‹</span><em>맨앞</em></a>';
		} else {
			$str .= '<a href="'.$url.'1'.$add.'" class="direction" title="맨앞페이지"><span>처음</span></a>';
		}

		$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
        $end_page = $start_page + $write_pages - 1;

        if ($end_page >= $total_page) { 
			$end_page = $total_page;
		}

        if ($start_page > 1) { 
			$str .= '<a href="'.$url.($start_page-1).$add.'" class="direction" title="이전페이지"><span>이전</span></a>'; 
		} else {
			//$str .= '<a class="direction" title="이전페이지"><span>‹</span><em>이전</em></a>'; 
		}

        if ($total_page > 0){
                for ($k=$start_page;$k<=$end_page;$k++){
                        if ($cur_page != $k) {
		                    $str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>';
                        } else {
	                        $str .= '<strong>'.$k.'</strong> ';
						}
                }
        }

        if ($total_page > $end_page) {
			$str .= '<a href="'.$url.($end_page+1).$add.'" class="direction" title="다음페이지"><span>다음</span></a>';
		} else {
			//$str .= '<a class="direction" title="다음페이지"><em>다음</em><span>›</span></a>';
		}

		if ($cur_page < $total_page) {
			$str .= '<a href="'.$url.($total_page).$add.'" class="direction" title="맨뒤페이지"><span>맨뒤</span></a>';
		} else {
			//$str .= '<a class="direction" title="맨뒤페이지"><em>맨뒤</em><span>››</span></a>';
		}

		return $str;
}

if(G5_IS_MOBILE) {
	$photo_size = 60;
	$colspan = 3;
} else {
	$photo_size = 40;
	$colspan = 8;
}
?>

<link rel="stylesheet" href="<?php echo $response_skin_url; ?>/response.css">

<section id="at-response">

	<div id="at-response-form">
		<form id="rcategory" name="rcategory" method="get">
			<select id="read" name="read">
				<option value=''>전체보기</option>
				<option value='y'>읽음</option>
				<option value='n'>읽지않음</option>
			</select>
			<select id="type" name="type">
				<option value=''>글분류</option>
				<option value='w'>내글</option>
				<option value='c'>내댓글</option>
			</select>
			<select id="flag" name="flag">
				<option value=''>반응분류</option>
				<option value='reply'>답글</option>
				<option value='cmt'>댓글</option>
				<option value='good'>추천</option>
				<option value='nogood'>비추</option>
				<option value='star'>별점</option>
				<option value='poll'>설문</option>
				<option value='linked'>연동글</option>
				<option value='shingo'>글잠금</option>
				<option value='cmt_reply'>대댓글</option>
				<option value='cmt_good'>댓글공감</option>
				<option value='cmt_choice'>댓글채택</option>
				<option value='cmt_shingo'>댓글잠금</option>
			</select>
			<button type="submit"><i class="fa fa-search fa-lg"></i></button>
		</form>
		<script>
			document.getElementById("read").value = "<?php echo $read; ?>";
		    document.getElementById("type").value = "<?php echo $type; ?>";
		    document.getElementById("flag").value = "<?php echo $flag; ?>";
		</script>
	<!-- } 전체게시물 검색 끝 -->
	</div>

	<form id="fresponse" name="fresponse" action="./response.act.php" method="post">
	<input type="hidden" id="re_act" name="act" value="">
	<input type="hidden" id="re_id" name="rid" value="">
	<input type="hidden" name="page" value="<?php echo $page; ?>">
	<input type="hidden" name="read" value="<?php echo $read; ?>">
	<input type="hidden" name="type" value="<?php echo $type; ?>">
	<input type="hidden" name="flag" value="<?php echo $flag; ?>">
	<input type="hidden" name="frame" value="<?php echo $frame; ?>">
	<table>
	<colgroup>
		<col width=30>
		<?php if(!G5_IS_MOBILE) { ?>
			<col width=70>
			<col width=70>
		<?php } ?>
		<col width=50>
		<col />
		<?php if(!G5_IS_MOBILE) { ?>
			<col width=70>
		<?php } ?>
		<col width=30>
	</colgroup>
	<thead>
	<tr>
		<th scope="col"><a href="javascript:;" class="re_select_all"><i class="fa fa-check-square fa-lg"></i></a></th>
		<?php if(!G5_IS_MOBILE) { ?>
			<th scope="col"><i class="fa fa-clock-o fa-lg"></i></th>
			<th scope="col"><i class="fa fa-eye fa-lg"></i></th>
		<?php } ?>
		<th scope="col"><i class="fa fa-user fa-lg"></i></th>
		<th scope="col" class="th-left"><i class="fa fa-comments fa-lg"></i> 총 <?php echo $total_count; ?>건이 있습니다.</th>
		<?php if(!G5_IS_MOBILE) { ?>
			<th scope="col"><i class="fa fa-tag fa-lg"></i></th>
		<?php } ?>
		<th scope="col"><i class="fa fa-times-circle fa-lg"></i></th>
	</tr>
	</thead>
	<tbody>
	<?php
		for($i=0; $i < count($list); $i++) {

			$chk_read = $list[$i]['re_chk'] ? '<span class="re-read">읽음</span>' : '<span class="re-unread">읽지않음</span>';

			$wr_subject = $list[$i]['wr_subject'] ? amina_text($list[$i]['wr_subject']) : '';

			$cate = '-';
			switch($list[$i]['re_flag']) {
				case 'linked' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>개의 연동글이 내 글에 달렸습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글에 연동글을 남기셨습니다.'; $cate = '연동글'; break;
				case 'reply' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>개의 답글이 내 글에 달렸습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글에 답글을 남기셨습니다.'; $cate = '답글'; break;
				case 'cmt' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>개의 댓글이 내 글에 달렸습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글에 댓글을 남기셨습니다.'; $cate = '댓글'; break;
				case 'good' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>명이 내 글을 추천하셨습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글을 추천하셨습니다.'; $cate = '추천'; break;						  
				case 'nogood' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>명이 내 글을 비추천하셨습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글을 비추천하셨습니다.'; $cate = '비추천'; break;	
				case 'star' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>명이 내 글에 별점을 주셨습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 글에 별점을 주셨습니다.'; $cate = '별점'; break;						
				case 'poll' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>명이 내 설문에 참여하셨습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 설문에 참여하셨습니다.'; break;	
				case 'shingo' : $subject = '내 글이 블라인드 처리되었습니다.'; $cate = '글잠금'; break;	
				case 'cmt_reply' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>개의 대댓글이 내 댓글에 달렸습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 댓글에 대댓글을 남기셨습니다.'; $cate = '대댓글'; break;
				case 'cmt_good' : $subject = ($list[$i]['re_cnt'] > 0 ) ? '<b>'.$list[$i]['re_name'].'</b>님외 <b>'.$list[$i]['re_cnt'].'</b>명이 내 댓글에 공감하셨습니다.' : '<b>'.$list[$i]['re_name'].'</b>님이 내 댓글에 공감하셨습니다.'; $cate = '댓글공감'; break;			
				case 'cmt_choice' : $subject = '<b>'.$list[$i]['re_name'].'</b>님이 내 댓글을 채택하셨습니다.'; $cate = '댓글채택'; break;		
				case 'cmt_shingo' : $subject = '내 댓글이 블라인드 처리되었습니다.'; $cate = '댓글잠금'; break;	
		     }

    ?>
	    <tr>
		<td><input type="checkbox" value="<?php echo $list[$i]['id']; ?>" name="re_id[]" id="re_id_<?php echo $list[$i]['id'];?>"></td>
		<?php if(!G5_IS_MOBILE) { ?>
			<td><?php echo date("m월 d일", strtotime($list[$i]['re_datetime']));?></td>
			<td><span id="read_<?php echo $list[$i]['id'];?>"><?php echo $chk_read; ?></span></td>
		<?php } ?>
		<td><?php echo mb_photo($member['mb_id'], $list[$i]['re_id'], $photo_size, $photo_size); ?></td>
		<td class="td-left">
			<a href="./response.act.php?rid=<?php echo urlencode($list[$i]['id']); ?><?php echo $frame_opt; ?>">
				<?php if(G5_IS_MOBILE) { ?>
					<i class="fa fa-clock-o"></i> <?php echo date("m월 d일", strtotime($list[$i]['re_datetime']));?>
					&nbsp; &nbsp;
					<i class="fa fa-eye"></i> <?php echo $chk_read; ?>
					&nbsp; &nbsp;
					<i class="fa fa-tag"></i> <?php echo $cate; ?>
					<br />
				<?php } ?>
				<i class="fa fa-microphone fa-lg"></i> <?php echo $subject; ?>
				<br />
				<span class="re-wr"><i class="fa fa-chevron-circle-right"></i> <?php echo $wr_subject; ?></span>
			</a>
		</td>
		<?php if(!G5_IS_MOBILE) { ?>
			<td><?php echo $cate; ?></td>
		<?php } ?>
		<td><a href="javascript:reForm.delete_one('<?php echo $list[$i]['id'];?>');"><i class="fa fa-times-circle fa-lg"></i></a></td>
		</tr>
	<?php } ?>
	<?php if ($i == 0) { ?>
		<tr><td colspan="<?php echo $colspan; ?>" class="no-response">내글 반응이 없습니다.</td></tr>
	<?php } ?>
	</table>
	</form>

	<div style="padding:12px;">
	     <a href="javascript:;" class="re_delete_all"><i class="fa fa-times-circle"></i> 선택삭제</a>
		 &nbsp;
		 <a href="javascript:;" class="re_read_all"><i class="fa fa-eye"></i> 읽은상태 표시</a>
	 </div>

	<div class="paginate">
		<?php echo response_paging($page_rows, $page, $total_page, "?read={$read}&flag={$flag}&type={$type}&page="); ?>
	</div>

<!--
	본 스킨에 사용된 스크립트는 동하아빠님의 [GPF] 알리미 for G5 에 사용된 스크립트를 수정한 것입니다.
	http://sir.co.kr/bbs/board.php?bo_table=g5_plugin&wr_id=70
-->
<script type="text/javascript">
	var reForm = {};

	reForm.form = $('form[name=fresponse]');
	reForm.act = $('#re_act');
	reForm.rid = $('#re_id');
	reForm.checked = false;

	reForm.ajax_error = function(jqXHR, textStatus, errorThrown) {
	  alert(errorThrown);
	};

	reForm.select_all = function(evt) {
		reForm.checked = !reForm.checked;
		$('[name="re_id[]"]').attr('checked', reForm.checked);
	};

	reForm.delete_all = function(evt) {
		if($('[name="re_id[]"]:checked').length == 0) {
		    alert('삭제할 알림을 하나 이상 선택하세요');
		    return;
		}
		if(!confirm('선택한 항목들을 삭제하시겠습니까?')) return;
		reForm.act.val('delete_all');
		reForm.form.submit();
	};

	reForm.read_all = function(evt) {
		if($('[name="re_id[]"]:checked').length == 0) {
			alert('읽음 표시할 알림을 하나 이상 선택하세요');
			return;
		}
		reForm.act.val('read_all');
		reForm.form.submit();
	};

	reForm.delete_one = function(rid) {
		if(!confirm('삭제하시겠습니까?')) return;
		reForm.act.val('delete');
		reForm.rid.val(rid);
		reForm.form.submit();
	};

	$('.re_select_all').click(reForm.select_all);
	$('.re_delete_all').click(reForm.delete_all);
	$('.re_read_all').click(reForm.read_all);
</script>

</section>