<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//Naver Style
function scrap_paging($write_pages, $cur_page, $total_page, $url, $add="") {

	if(!$cur_page) $cur_page = 1;
	if(!$total_page) $total_page = 1;

	$str = '';

	if ($cur_page < 2) {
		//$str .= '<a class="direction" title="맨앞페이지"><span>‹‹</span><em>맨앞</em></a>';
	} else {
		$str .= '<a href="'.$url.'1'.$add.'" class="direction" title="맨앞페이지"><span>처음</span></a>';
	}

	$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
	$end_page = $start_page + $write_pages - 1;

	if ($end_page >= $total_page) { 
		$end_page = $total_page;
	}

	if ($start_page > 1) { 
		$str .= '<a href="'.$url.($start_page-1).$add.'" class="direction" title="이전페이지"><span>이전</span></a>'; 
	} else {
		//$str .= '<a class="direction" title="이전페이지"><span>‹</span><em>이전</em></a>'; 
	}

	if ($total_page > 0){
		for ($k=$start_page;$k<=$end_page;$k++){
			if ($cur_page != $k) {
				$str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>';
			} else {
				$str .= '<strong>'.$k.'</strong> ';
			}
		}
	}

	if ($total_page > $end_page) {
		$str .= '<a href="'.$url.($end_page+1).$add.'" class="direction" title="다음페이지"><span>다음</span></a>';
	} else {
		//$str .= '<a class="direction" title="다음페이지"><em>다음</em><span>›</span></a>';
	}

	if ($cur_page < $total_page) {
		$str .= '<a href="'.$url.($total_page).$add.'" class="direction" title="맨뒤페이지"><span>맨뒤</span></a>';
	} else {
		//$str .= '<a class="direction" title="맨뒤페이지"><em>맨뒤</em><span>››</span></a>';
	}

	return $str;
}

?>

<link rel="stylesheet" href="<?php echo $member_skin_url; ?>/scrap.css">

<section id="at-scrap">

<?php if($action == "list") { ?>
	<div class="msg-box box-black">
		<i class="fa fa-chevron-circle-right"></i> 스크랩 목록
	</div>

	<table class="scrap-list">
	<tr>
	    <th scope="col"><i class="fa fa-bell"></i> 게시판</th>
        <th scope="col"><i class="fa fa-check-circle"></i> 스크랩 제목</th>
	    <th scope="col"><i class="fa fa-times-circle"></i> 삭제</th>
    </tr>
	<?php for ($i=0; $i<count($list); $i++) { ?>
	    <tr>
	    <td class="td-center"><a href="<?php echo $list[$i]['opener_href'] ?>" target="_blank" onclick="opener.document.location.href='<?php echo $list[$i]['opener_href'] ?>'; return false;"><?php echo $list[$i]['bo_subject'] ?></a></td>
	    <td class="scrap-subject"><a href="<?php echo $list[$i]['opener_href_wr_id'] ?>" target="_blank" onclick="opener.document.location.href='<?php echo $list[$i]['opener_href_wr_id'] ?>'; return false;"><?php echo $list[$i]['subject'] ?></a></td>
		<td class="td-center"><a href="<?php echo $list[$i]['del_href']; ?>" onclick="del(this.href); return false;"><i class="fa fa-times-circle"></i> 삭제</a></td>
		</tr>
    <?php } ?>
	<?php if ($i==0) { echo '<tr><td colspan="3" class="no-data">자료가 없습니다.</td></tr>'."\n"; } ?>
	</table>

	<div class="paginate">
	    <?php echo scrap_paging($config['cf_write_pages'], $page, $total_page, "?$qstr&page="); ?>
	</div>

<?php } else if($action == "scrap") { ?>

	<div class="msg-box box-black">
		<i class="fa fa-comment"></i> 스크랩을 하시면서 감사 혹은 격려의 댓글을 남기실 수 있습니다.
	</div>

    <form name="f_scrap_popin" action="./scrap_popin_update.php" method="post" data-ajax="false">
	<input type="hidden" name="bo_table" value="<?php echo $bo_table; ?>">
    <input type="hidden" name="wr_id" value="<?php echo $wr_id; ?>">

	<table class="scrap-form">
	<tr>
	<th scope="row">제목</th>
	<td><?php echo get_text(cut_str($write['wr_subject'], 255)) ?></td>
	</tr>
	<tr>
	<th scope="row">댓글</th>
	<td><textarea name="wr_content" id="wr_content" rows=10 style="width:98%;"></textarea></td>
	</tr>
    </table>

	<p align="center">
		<button type="submit"><i class="fa fa-check-circle fa-lg"></i> 스크랩하기</button>
	</p>

	</form>
<?php } ?>
</section>