<?php
$sub_menu = '000000';
include_once('./_common.php');

check_demo();
auth_check_menu($auth, $sub_menu, "w");

if ($is_admin != 'super') {
    alert('최고관리자만 접근 가능합니다.');
}

$tables = [
    'rb_builder' => [
        'bu_logo_pc' => 'VARCHAR(255) NOT NULL', // 1.1.4
        'bu_logo_pc_w' => 'VARCHAR(255) NOT NULL', // 1.1.4
        'bu_logo_mo' => 'VARCHAR(255) NOT NULL', // 1.1.4
        'bu_logo_mo_w' => 'VARCHAR(255) NOT NULL', // 1.1.4
        'bu_load' => 'INT(4) NOT NULL', // 1.1.4
        'bu_viewport' => 'VARCHAR(10) NOT NULL' // 1.1.5
    ],
    'rb_module' => [
        'md_sca' => 'VARCHAR(255) NOT NULL', // 1.1.4
        'md_order_id' => 'INT(4) NOT NULL' // 1.2.6
    ],
    'rb_config' => [
        'co_layout_hd' => 'VARCHAR(20) NOT NULL', // 1.3.9
        'co_layout_ft' => 'VARCHAR(20) NOT NULL' // 1.3.9
    ]
];

try {
    $messages = []; // 메시지를 저장할 배열

    foreach ($tables as $table => $columns) {
        $addColumns = [];
        foreach ($columns as $column => $definition) {
            // 컬럼 존재 여부 확인
            $query = "SHOW COLUMNS FROM `$table` LIKE '$column'";
            $result = sql_query($query);

            if (!$result) {
                throw new Exception("[$table] 에 [$column] 컬럼 확인 오류: " . mysqli_error($GLOBALS['g5']['connect_db']));
            }

            if (mysqli_num_rows($result) == 0) {
                // 추가할 컬럼 목록에 추가
                $addColumns[] = "ADD `$column` $definition";
            } else {
                $messages[] = "[$table] 에 [$column] 컬럼이 정상 입니다.";
            }
        }

        // 추가할 컬럼이 있으면 ALTER TABLE 실행
        if (!empty($addColumns)) {
            $alterTableQuery = "ALTER TABLE `$table` " . implode(', ', $addColumns);
            $alterResult = sql_query($alterTableQuery);
            if ($alterResult) {
                $messages[] = "[$table] 에 컬럼이 추가되었습니다.";
            } else {
                throw new Exception("[$table] 에 컬럼 추가를 실패했습니다: " . mysqli_error($GLOBALS['g5']['connect_db']));
            }
        }
    }

    // 모든 메시지를 한 번에 출력
    if (!empty($messages)) {
        alert(implode("\\n", $messages));
    }
} catch (Exception $e) {
    alert("오류: " . addslashes($e->getMessage()));
}



update_rewrite_rules();
goto_url('./rb_form.php', false);

?>