$(document).ready(function() {
    
    // flex_box 클래스를 가진 모든 요소를 선택
    var flexBoxes = $('.flex_box');

    // flex_box 클래스를 가진 요소의 개수를 확인
    var numFlexBoxes = flexBoxes.length;

    // 각 flex_box 요소에 data-layoutNum 속성을 추가
    flexBoxes.each(function(index) {
        $(this).attr('data-layout', index + 1);
    });
    
    
    
    // 확인된 flex_box 요소의 개수를 콘솔에 출력
    console.log('flex_box 개수:', numFlexBoxes);
    
    // 요소의 개수만큼 ajax를 실행하고 레이아웃에 속하는 데이터를 로드
    for (var layoutIndex = 1; layoutIndex <= numFlexBoxes; layoutIndex++) {
    
        (function(layoutIndex) {
            
            $.ajax({
                url: './rb/rb.config/ajax.layout_set.php', // ajax를 처리하는 PHP 파일 경로
                method: 'POST',
                dataType: 'html',
                data: {
                    "layout":layoutIndex,
                },

                success: function (data) {
                    // ajax 요청이 성공했을 때 실행되는 콜백 함수
                    // 받아온 데이터를 특정 div의 data-id 속성에 추가함.
                    // alert(data);
                    $('.flex_box[data-layout=' + layoutIndex + ']').html(data);
                },
                error: function (xhr, status, error) {
                    // 요청 실패
                    console.error('모듈 로드에 오류가 발생 했습니다.');
                }
            });
            
        })(layoutIndex);
        
    }


});