<?php
global $lo_location;
global $lo_url;

include_once('./_common.php');


if($error) {
    $g5['title'] = "오류안내 페이지";
} else {
    $g5['title'] = "결과안내 페이지";
}
include_once(G5_PATH.'/head.sub.php');
add_javascript('<script src="'.G5_URL.'/js/rb.common.js"></script>', 0);

// 필수 입력입니다.
// 양쪽 공백 없애기
// 필수 (선택 혹은 입력)입니다.
// 전화번호 형식이 올바르지 않습니다. 하이픈(-)을 포함하여 입력하세요.
// 이메일주소 형식이 아닙니다.
// 한글이 아닙니다. (자음, 모음만 있는 한글은 처리하지 않습니다.)
// 한글이 아닙니다.
// 한글, 영문, 숫자가 아닙니다.
// 한글, 영문이 아닙니다.
// 숫자가 아닙니다.
// 영문이 아닙니다.
// 영문 또는 숫자가 아닙니다.
// 영문, 숫자, _ 가 아닙니다.
// 최소 글자 이상 입력하세요.
// 이미지 파일이 아닙니다..gif .jpg .png 파일만 가능합니다.
// 파일만 가능합니다.
// 공백이 없어야 합니다.

$msg = isset($msg) ? strip_tags($msg) : '';
$msg2 = str_replace("\\n", "<br>", $msg);

$url = isset($url) ? clean_xss_tags($url, 1) : '';
if (!$url) $url = isset($_SERVER['HTTP_REFERER']) ? clean_xss_tags($_SERVER['HTTP_REFERER'], 1) : '';

$url = preg_replace("/[\<\>\'\"\\\'\\\"\(\)]/", "", $url);
$url = preg_replace('/\r\n|\r|\n|[^\x20-\x7e]/','', $url);

// url 체크
check_url_host($url, $msg);

if($error) {
    $header2 = "다음 항목에 오류가 있습니다.";
} else {
    $header2 = "다음 내용을 확인해 주세요.";
}
?>

<style>
.rb-custom-alert-popup {
    position: fixed;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -50%);
    width: 400px;
    background: #fff;
    color: #000;
    padding: 25px 25px;
    border-radius: 15px;
    box-shadow: 0 4px 24px rgba(0,0,0,0.05);
    font-size: 15px;
    text-align: center;
    word-break: keep-all;
    line-height: 140%;
    animation: customAlertShow 0.22s cubic-bezier(.68,-0.55,.27,1.55);
    z-index: 12345678905;
}

.rb-custom-alert-popup svg {opacity: 0.2; margin-bottom: 10px;}

.rb-custom-alert-popup-bg {
    position: fixed;
    left: 0;
    top: 0;
    z-index: 12345678904;
    width: 100%;
    height:100%;
    background: rgba(0,0,0,0.2);
}

.rb-custom-alert-popup .rb-alert-btn {
    display:inline-block; padding:12px 25px; font-size:15px;
    color:#25282B; border:none; border-radius:10px; cursor:pointer; background-color: #ced3db !important;
}

.rb-custom-alert-popup .rb-alert-btn.rb-btn-ok {
    background-color: #25282B !important;
    color:#fff !important;
}


@keyframes customAlertShow {
    from { opacity:0; transform: translate(-50%, -46%) scale(0.97);}
    to   { opacity:1; transform: translate(-50%, -50%) scale(1);}
}

@media all and (max-width:512px) {
    .rb-custom-alert-popup {width: 90%;}
}
</style>

<script>
alert("<?php echo $msg; ?>", function(){
<?php if ($url) { ?>
    document.location.replace("<?php echo str_replace('&amp;', '&', $url); ?>");
<?php } else { ?>
    history.back();
<?php } ?>
});
</script>

<noscript>
<div id="validation_check">
    <h1><?php echo $header2 ?></h1>
    <p class="cbg">
        <?php echo $msg2 ?>
    </p>
    <?php if($post) { ?>
    <form method="post" action="<?php echo $url ?>">
    <?php
    foreach($_POST as $key => $value) {

        $key = clean_xss_tags($key);
        $value = clean_xss_tags($value);

        if(strlen($value) < 1)
            continue;

        if(preg_match("/pass|pwd|capt|url/", $key))
            continue;
    ?>
    <input type="hidden" name="<?php echo htmlspecialchars($key); ?>" value="<?php echo htmlspecialchars($value); ?>">
    <?php
    }
    ?>
    <input type="submit" value="돌아가기">
    </form>
    <?php } else { ?>
    <div class="btn_confirm">
        <a href="<?php echo $url ?>">돌아가기</a>
    </div>
    <?php } ?>

<?php /*
<article id="validation_check">
<header>
    <hgroup>
        <!-- <h1>회원가입 정보 입력 확인</h1> --> <!-- 수행 중이던 작업 내용 -->
        <h1><?php echo $header ?></h1> <!-- 수행 중이던 작업 내용 -->
        <h2><?php echo $header2 ?></h2>
    </hgroup>
</header>
<p>
    <!-- <strong>항목</strong> 오류내역 -->
    <!--
    <strong>이름</strong> 필수 입력입니다. 한글만 입력할 수 있습니다.<br>
    <strong>이메일</strong> 올바르게 입력하지 않았습니다.<br>
    -->
    <?php echo $msg2 ?>
</p>

<a href="<?php echo $url ?>">돌아가기</a>
</article>
*/ ?>
</div>
</noscript>

<?php
include_once(G5_PATH.'/tail.sub.php');
