<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

//Naver Style
function new_paging($write_pages, $cur_page, $total_page, $url, $add="") {

		if(!$cur_page) $cur_page = 1;
		if(!$total_page) $total_page = 1;

		$str = '';

		if ($cur_page < 2) {
			//$str .= '<a class="direction" title="맨앞페이지"><span>‹‹</span><em>맨앞</em></a>';
		} else {
			$str .= '<a href="'.$url.'1'.$add.'" class="direction" title="맨앞페이지"><span>처음</span></a>';
		}

		$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
        $end_page = $start_page + $write_pages - 1;

        if ($end_page >= $total_page) { 
			$end_page = $total_page;
		}

        if ($start_page > 1) { 
			$str .= '<a href="'.$url.($start_page-1).$add.'" class="direction" title="이전페이지"><span>이전</span></a>'; 
		} else {
			//$str .= '<a class="direction" title="이전페이지"><span>‹</span><em>이전</em></a>'; 
		}

        if ($total_page > 0){
                for ($k=$start_page;$k<=$end_page;$k++){
                        if ($cur_page != $k) {
		                    $str .= '<a href="'.$url.$k.$add.'">'.$k.'</a>';
                        } else {
	                        $str .= '<strong>'.$k.'</strong> ';
						}
                }
        }

        if ($total_page > $end_page) {
			$str .= '<a href="'.$url.($end_page+1).$add.'" class="direction" title="다음페이지"><span>다음</span></a>';
		} else {
			//$str .= '<a class="direction" title="다음페이지"><em>다음</em><span>›</span></a>';
		}

		if ($cur_page < $total_page) {
			$str .= '<a href="'.$url.($total_page).$add.'" class="direction" title="맨뒤페이지"><span>맨뒤</span></a>';
		} else {
			//$str .= '<a class="direction" title="맨뒤페이지"><em>맨뒤</em><span>››</span></a>';
		}

		return $str;
}

?>

<link rel="stylesheet" href="<?php echo $new_skin_url; ?>/new.css">

<section id="at-new">
	<!-- 전체게시물 검색 시작 -->
	<div id="at-new-form">
		<form name="fnew" method="get">
		<?php echo $group_select ?>
		<select name="view" id="view">
		    <option value="">전체게시물
		    <option value="w">원글만
			<option value="c">댓글만
		</select>
		<input type="text" name="mb_id" value="<?php echo $mb_id ?>" id="mb_id" required>
	    <button type="submit"><i class="fa fa-search fa-lg"></i></button>
		</form>
		<script>
			document.getElementById("gr_id").value = "<?php echo $gr_id ?>";
		    document.getElementById("view").value = "<?php echo $view ?>";
		</script>
		<!-- } 전체게시물 검색 끝 -->
	</div>

	<!-- 전체게시물 목록 시작 { -->
	<?php if(G5_IS_MOBILE) { ?>
		<div class="at-new-head"></div>
		<ul>
		<?php
		for ($i=0; $i<count($list); $i++) {
		    $gr_subject = amina_text($list[$i]['gr_subject']);
			$bo_subject = amina_text($list[$i]['bo_subject']);
		    $wr_subject = amina_text($list[$i]['wr_subject']);
			$list[$i]['name'] = $is_sideview ? amina_sideview($list[$i]['mb_id'], $list[$i]['wr_name'], $list[$i]['wr_email'], $list[$i]['wr_homepage']) : $list[$i]['name'];
		?>
		<li>
			<strong><a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['comment'] ? '<i class="fa fa-comments"></i> ' : ''; ?><?php echo $wr_subject ?></a></strong>
			<p>
			    <i class="fa fa-user"></i> <?php echo $list[$i]['name'] ?>
				&nbsp;&nbsp;
			    <i class="fa fa-tag"></i> <a href="./board.php?bo_table=<?php echo $list[$i]['bo_table'] ?>"><?php echo $bo_subject ?></a>
				&nbsp;&nbsp;
				<i class="fa fa-th-large"></i> <a href="./new.php?gr_id=<?php echo $list[$i]['gr_id'] ?>"><?php echo $gr_subject ?></a>
				&nbsp;&nbsp;
				<i class="fa fa-clock-o"></i> <?php echo $list[$i]['datetime2'] ?>
			</p>
		</li>
		<?php }  ?>

		<?php if ($i == 0)
			echo '<li class="no-list">게시물이 없습니다.</li>';
		?>
		</ul>
	<?php } else { ?>
		<table>
		<thead>
		<tr>
			<th scope="col">그룹</th>
		    <th scope="col">게시판</th>
			<th scope="col">제목</th>
			<th scope="col">이름</th>
			<th scope="col">일시</th>
		</tr>
		</thead>
		<tbody>
		<?php
		for ($i=0; $i<count($list); $i++) {
		    $gr_subject = amina_cut($list[$i]['gr_subject'], 10);
			$bo_subject = amina_cut($list[$i]['bo_subject'], 10);
		    $wr_subject = amina_cut($list[$i]['wr_subject'], 40);
			$list[$i]['name'] = $is_sideview ? amina_sideview($list[$i]['mb_id'], $list[$i]['wr_name'], $list[$i]['wr_email'], $list[$i]['wr_homepage']) : $list[$i]['name'];
		?>
		<tr>
			<td class="td-center"><a href="./new.php?gr_id=<?php echo $list[$i]['gr_id'] ?>"><?php echo $gr_subject ?></a></td>
		    <td class="td-center"><a href="./board.php?bo_table=<?php echo $list[$i]['bo_table'] ?>"><?php echo $bo_subject ?></a></td>
			<td class="td-txt"><a href="<?php echo $list[$i]['href'] ?>"><?php echo $list[$i]['comment'] ? '<i class="fa fa-comments"></i> ' : ''; ?><?php echo $wr_subject ?></a></td>
		    <td class="td-center"><b><?php echo $list[$i]['name'] ?></b></td>
			<td class="td-num td-center"><?php echo $list[$i]['datetime2'] ?></td>
		</tr>
		<?php }  ?>

		<?php if ($i == 0)
			echo '<tr><td colspan="5" class="no-list">게시물이 없습니다.</td></tr>';
		?>
		</tbody>
		</table>
	<?php } ?>
	<!-- } 전체게시물 목록 끝 -->

	<div class="paginate">
		<?php echo new_paging($page_rows, $page, $total_page, "?gr_id=$gr_id&view=$view&mb_id=$mb_id&page="); ?>
	</div>

</section>
