<?php
include_once('./_common.php');
?>
<!doctype html>
<html lang="ko">
<head>
<meta charset="utf-8">
<title>이미지 보기</title>
<style>
	body { 
		width:100%; height:100%; padding:0; margin:0; background:#000;
	}
</style>
<body>

<img src="<?=$img?>" class="draggable" style="position:relative;top:0;left:0;cursor:move;" alt="" />

<script>
<? if($width && $height) { ?>
	var win_w = <?=$width?>;
	var win_h = <?=$height?> + 70;
<? } else { ?>
	var win_w = parseInt($('img').width());
	var win_h = parseInt($('img').height()) + 70;
<? } ?>
var win_l = (screen.width - win_w) / 2;
var win_t = (screen.height - win_h) / 2;

if(win_w > screen.width) {
    win_l = 0;
    win_w = screen.width - 20;

    if(win_h > screen.height) {
        win_t = 0;
        win_h = screen.height - 40;
    }
}

if(win_h > screen.height) {
    win_t = 0;
    win_h = screen.height - 40;

    if(win_w > screen.width) {
	    win_w = screen.width - 20;
		win_l = 0;
    }
}

window.moveTo(win_l, win_t);
window.resizeTo(win_w, win_h);

$(function() {
    var is_draggable = false;
    var x = y = 0;
    var pos_x = pos_y = 0;

    $(".draggable").mousemove(function(e) {
        if(is_draggable) {
            x = parseInt($(this).css("left")) - (pos_x - e.pageX);
            y = parseInt($(this).css("top")) - (pos_y - e.pageY);

            pos_x = e.pageX;
            pos_y = e.pageY;

            $(this).css({ "left" : x, "top" : y });
        }

        return false;
    });

    $(".draggable").mousedown(function(e) {
        pos_x = e.pageX;
        pos_y = e.pageY;
        is_draggable = true;
        return false;
    });

    $(".draggable").mouseup(function() {
        is_draggable = false;
        return false;
    });

    $(".draggable").dblclick(function() {
        window.close();
    });
});
</script>

</body>
</html>