<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 선택옵션으로 인해 셀합치기가 가변적으로 변함
$colspan = 5;

if ($is_checkbox) $colspan++;
if ($is_good) $colspan++;
if ($is_nogood) $colspan++;

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$board_skin_url.'/css/style.css">', 0);
?>
<div class="panel panel-default">
<div class="panel-heading">
		<h5><i class="fa fa-bar-chart-o"></i> <?php echo $board['bo_subject'] ?><span class="sound_only"> 목록</span></h5>
</div>
<!-- 게시판 목록 시작 { -->
<div id="bo_list" style="width:<?php echo $width; ?>" class="panel-body table-content">

    <!-- 게시판 카테고리 시작 { -->
    <?php if ($is_category) { ?>
    <nav id="bo_cate">
        <ol class="breadcrumb" id="bo_cate_ul">
            <?php echo $category_option ?>
        </ol>
    </nav>
    <?php } ?>
    <!-- } 게시판 카테고리 끝 -->

    <!-- 게시판 페이지 정보 및 버튼 시작 { -->
	    <div class="pull-left">
		    <span class="btn btn-default tooltip-top" title="전체 글수" data-original-title=" 전체 글수 ">
		    <i class="fa fa-tags fa-lg"></i> <?php echo number_format($total_count) ?> 개</span>
			<span class="btn btn-default tooltip-top" title="현재 페이지" data-original-title=" 현재 페이지 ">
			<?php echo $page ?> 페이지</span>
	    </div>

		<div class="pull-right">
			<div class="btn-group">
		    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
			<i class="fa fa-cog"></i> &nbsp;&nbsp;<span class="caret"></span>
			</button>
        <?php if ($rss_href || $write_href) { ?>
			<ul class="dropdown-menu pull-right" role="menu">
                <?php if ($admin_href) { ?><li><a href="<?php echo $admin_href ?>"><i class="fa fa-wrench"></i> 관리자</a></li><?php } ?>
                <?php if ($write_href) { ?><li><a href="<?php echo $write_href ?>"><i class="fa fa-edit"></i> 글쓰기</a></li><?php } ?>
				<?php if ($rss_href) { ?><li><a href="<?php echo $rss_href ?>"><i class="fa fa-rss"></i> RSS</a></li><?php } ?>
			</ul>
        <?php } ?>
			</div>
		</div>
<div class="clearfix"></div>
<hr>

    <!-- } 게시판 페이지 정보 및 버튼 끝 -->

    <form name="fboardlist" id="fboardlist" action="./board_list_update.php" onsubmit="return fboardlist_submit(this);" method="post" class="form-inline">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sfl" value="<?php echo $sfl ?>">
    <input type="hidden" name="stx" value="<?php echo $stx ?>">
    <input type="hidden" name="spt" value="<?php echo $spt ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
	<input type="hidden" name="sst" value="<?php echo $sst ?>">
    <input type="hidden" name="sod" value="<?php echo $sod ?>">
    <input type="hidden" name="page" value="<?php echo $page ?>">
    <input type="hidden" name="sw" value="">

        <table class="panel-body table table-bordered media-table">
        <!--<caption><?php echo $board['bo_subject'] ?> 목록</caption>-->
        <thead>
        <tr>
            <th scope="col" class="text-center">번호</th>
            <?php if ($is_checkbox) { ?>
            <th scope="col">
                <label for="chkall" class="sound_only">현재 페이지 게시물 전체</label>
                <input type="checkbox" id="chkall" onclick="if (this.checked) all_checked(true); else all_checked(false);">
            </th>
            <?php } ?>
            <th scope="col" class="hidden-xs text-center">제목</th>
            <th scope="col" class="visible-xs text-center">컨텐츠</th>
            <th scope="col" class="hidden-xs text-center">글쓴이</th>
            <th scope="col" class="hidden-xs text-center"><?php echo subject_sort_link('wr_datetime', $qstr2, 1) ?>날짜</a></th>
            <th scope="col" class="hidden-xs text-center"><?php echo subject_sort_link('wr_hit', $qstr2, 1) ?>조회</a></th>
            <?php if ($is_good) { ?><th scope="col" class="hidden-xs text-center"><?php echo subject_sort_link('wr_good', $qstr2, 1) ?>추천</a></th><?php } ?>
            <?php if ($is_nogood) { ?><th scope="col" class="hidden-xs text-center"><?php echo subject_sort_link('wr_nogood', $qstr2, 1) ?>비추천</a></th><?php } ?>
        </tr>
        </thead>
        <tbody>
        <?php
        for ($i=0; $i<count($list); $i++) {
         ?>
        <tr class="<?php if ($list[$i]['is_notice']) echo "bo_notice"; ?> text-center">
            <td class="td_num text-center">
            <?php
            if ($list[$i]['is_notice']) // 공지사항
                echo '<strong><i class="fa fa-microphone tooltip-top" title="공지사항"></i></strong>';
            else if ($wr_id == $list[$i]['wr_id'])
                echo "<span class=\"bo_current\"><i class='fa fa-eye tooltip-top' title='보고 있는 페이지'></i></span>";
            else
                echo $list[$i]['num'];
             ?>
            </td>
            <?php if ($is_checkbox) { ?>
            <td class="td_chk text-left">
                <label for="chk_wr_id_<?php echo $i ?>" class="sound_only"><?php echo $list[$i]['subject'] ?></label>
                <input type="checkbox" name="chk_wr_id[]" value="<?php echo $list[$i]['wr_id'] ?>" id="chk_wr_id_<?php echo $i ?>">
            </td>
            <?php } ?>
            <td class="td_subject text-left">
                <?php
                echo $list[$i]['icon_reply'];
                if ($is_category && $list[$i]['ca_name']) {
                 ?>
                <span class="label label-info"><a href="<?php echo $list[$i]['ca_name_href'] ?>" class="bo_cate_link"><?php echo $list[$i]['ca_name'] ?></a></span>
                <?php } ?>

                <a href="<?php echo $list[$i]['href'] ?>">
                    <?php echo $list[$i]['subject'] ?>
                    <?php if ($list[$i]['comment_cnt']) { ?><span class="sound_only">댓글</span><?php echo $list[$i]['comment_cnt']; ?><span class="sound_only">개</span><?php } ?>
                </a>

                <?php
                if (isset($list[$i]['icon_new'])) echo $list[$i]['icon_new'];
                if (isset($list[$i]['icon_hot'])) echo $list[$i]['icon_hot'];
                if (isset($list[$i]['icon_file'])) echo $list[$i]['icon_file'];
                if (isset($list[$i]['icon_link'])) echo $list[$i]['icon_link'];
                if (isset($list[$i]['icon_secret'])) echo $list[$i]['icon_secret'];
                 ?>

				 <span class="visible-xs well well-sm clearfix" style="margin:15px 0 0 0; line-height: 35px;">
				 <i class="fa fa-calendar-o fa-fw"></i><?php echo $list[$i]['datetime2'] ?>&nbsp;&nbsp; 
				 <i class="fa fa-eye fa-fw"></i><?php echo $list[$i]['wr_hit'] ?>
				 <span class="pull-right" style="line-height: 35px;">
				 <?php echo $list[$i]['name'] ?>
				 </span>
				 </span>
			</td>
            </td>
            <td class="td_name sv_use hidden-xs text-left"><?php echo $list[$i]['name'] ?></td>
            <td class="td_date hidden-xs text-left"><?php echo $list[$i]['datetime2'] ?></td>
            <td class="td_num hidden-xs text-left"><?php echo $list[$i]['wr_hit'] ?></td>
            <?php if ($is_good) { ?><td class="td_numbig hidden-xs text-left"><?php echo $list[$i]['wr_good'] ?></td><?php } ?>
            <?php if ($is_nogood) { ?><td class="td_numbig hidden-xs text-left"><?php echo $list[$i]['wr_nogood'] ?></td><?php } ?>
        </tr>
        <?php } ?>
        <?php if (count($list) == 0) { echo '<tr><td colspan="'.$colspan.'" class="text-center">게시물이 없습니다.</td></tr>'; } ?>
        </tbody>
        </table>
    <?php if ($list_href || $is_checkbox || $write_href) { ?>

        <?php if ($list_href || $write_href) { ?>
        <div class="btn-group pull-right">
        <?php if ($list_href) { ?><a href="<?php echo $list_href ?>" class="btn btn-default"><i class="fa fa-list"></i> 목록</a><?php } ?>
        <?php if ($write_href) { ?><a href="<?php echo $write_href ?>" class="btn btn-default"><i class="fa fa-edit"></i> 글쓰기</a><?php } ?>
        </div>
        <?php } ?>

        <?php if ($is_checkbox) { ?>
        <div class="btn-group pull-left">
            <input type="submit" name="btn_submit" value="선택삭제" onclick="document.pressed=this.value" class="btn btn-default">
            <input type="submit" name="btn_submit" value="선택복사" onclick="document.pressed=this.value" class="btn btn-default">
            <input type="submit" name="btn_submit" value="선택이동" onclick="document.pressed=this.value" class="btn btn-default">
        </div>
        <?php } ?>
    <?php } ?>
    </form>
</div>
<?php if($is_checkbox) { ?>
<noscript>
<p>자바스크립트를 사용하지 않는 경우<br>별도의 확인 절차 없이 바로 선택삭제 처리하므로 주의하시기 바랍니다.</p>
</noscript>
<?php } ?>
<!-- 페이지 -->
<?php echo $write_pages;  ?>
</div>

<!-- 게시판 검색 시작 { -->
<fieldset id="bo_sch" class="well well-sm text-center">
    <form name="fsearch" method="get" class="form-inline">
    <input type="hidden" name="bo_table" value="<?php echo $bo_table ?>">
    <input type="hidden" name="sca" value="<?php echo $sca ?>">
    <input type="hidden" name="sop" value="and">
    <div class="form-group"> 
    <label for="sfl" class="sound_only">검색대상</label>
    <select name="sfl" id="sfl" class="form-control">
        <option value="wr_subject"<?php echo get_selected($sfl, 'wr_subject', true); ?>>제목</option>
        <option value="wr_content"<?php echo get_selected($sfl, 'wr_content'); ?>>내용</option>
        <option value="wr_subject||wr_content"<?php echo get_selected($sfl, 'wr_subject||wr_content'); ?>>제목+내용</option>
        <option value="mb_id,1"<?php echo get_selected($sfl, 'mb_id,1'); ?>>회원아이디</option>
        <option value="mb_id,0"<?php echo get_selected($sfl, 'mb_id,0'); ?>>회원아이디(코)</option>
        <option value="wr_name,1"<?php echo get_selected($sfl, 'wr_name,1'); ?>>글쓴이</option>
        <option value="wr_name,0"<?php echo get_selected($sfl, 'wr_name,0'); ?>>글쓴이(코)</option>
    </select>
	</div>
	
	<div class="form-group"> 
            <input type="text" name="stx" value="<?php echo stripslashes($stx) ?>" required id="stx" class="form-control required" size="15" maxlength="20" placeholder="검색어를 입력하세요">
	</div>
	<button type="submit" class="btn btn-info">검색</button>
    </form>
</fieldset>
<!-- } 게시판 검색 끝 -->

<?php if ($is_checkbox) { ?>
<script>
function all_checked(sw) {
    var f = document.fboardlist;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]")
            f.elements[i].checked = sw;
    }
}

function fboardlist_submit(f) {
    var chk_count = 0;

    for (var i=0; i<f.length; i++) {
        if (f.elements[i].name == "chk_wr_id[]" && f.elements[i].checked)
            chk_count++;
    }

    if (!chk_count) {
        alert(document.pressed + "할 게시물을 하나 이상 선택하세요.");
        return false;
    }

    if(document.pressed == "선택복사") {
        select_copy("copy");
        return;
    }

    if(document.pressed == "선택이동") {
        select_copy("move");
        return;
    }

    if(document.pressed == "선택삭제") {
        if (!confirm("선택한 게시물을 정말 삭제하시겠습니까?\n\n한번 삭제한 자료는 복구할 수 없습니다\n\n답변글이 있는 게시글을 선택하신 경우\n답변글도 선택하셔야 게시글이 삭제됩니다."))
            return false;

        f.removeAttribute("target");
        f.action = "./board_list_update.php";
    }

    return true;
}

// 선택한 게시물 복사 및 이동
function select_copy(sw) {
    var f = document.fboardlist;

    if (sw == "copy")
        str = "복사";
    else
        str = "이동";

    var sub_win = window.open("", "move", "left=50, top=50, width=500, height=550, scrollbars=1");

    f.sw.value = sw;
    f.target = "move";
    f.action = "./move.php";
    f.submit();
}
</script>
<?php } ?>
<!-- } 게시판 목록 끝 -->
