
CREATE TABLE `nice_broom` (
  `nb_no` int(11) NOT NULL auto_increment,
  `nb_route` varchar(255) NOT NULL,
  `posx` double NOT NULL,
  `posy` double NOT NULL,
  `nb_use` tinyint(3) NOT NULL,
  `nh_no` int(11) NOT NULL,
  `nr_no` int(11) NOT NULL,
  `nb_type1` varchar(50) NOT NULL,
  `nb_type2` tinyint(5) NOT NULL,
  `nb_type3` tinyint(5) NOT NULL,
  `nb_pay01` int(11) NOT NULL,
  `nb_pay02` int(11) NOT NULL,
  `nb_pay02_dc` int(11) NOT NULL,
  `nb_edit_pay_save` tinyint(1) NOT NULL,
  `nb_jungge_dc` int(11) NOT NULL,
  `nb_edit_pay` int(11) NOT NULL,
  `nb_sale_pay` int(11) NOT NULL,
  `nb_dae_pay` int(11) NOT NULL,
  `nb_subject` varchar(255) NOT NULL,
  `nb_addr` varchar(255) NOT NULL,
  `nb_img` varchar(255) NOT NULL,
  `nb_pano` int(11) NOT NULL,
  `nb_floor` tinyint(3) NOT NULL,
  `nb_option1` tinyint(3) NOT NULL,
  `nb_option2` tinyint(3) NOT NULL,
  `nb_visit` int(11) NOT NULL,
  `nb_good` varchar(255) NOT NULL,
  `nb_datetime` datetime NOT NULL,
  `nb_reg_datetime` datetime NOT NULL,
  UNIQUE KEY `nb_no` (`nb_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_call_list`
-- 

CREATE TABLE `nice_call_list` (
  `ncl_no` int(11) NOT NULL auto_increment,
  `ncl_type` varchar(50) NOT NULL,
  `ncl_content` text NOT NULL,
  `ncl_call_name` varchar(50) NOT NULL,
  `ncl_call` varchar(50) NOT NULL,
  `ncl_pay` varchar(100) NOT NULL,
  `ncl_edit_datetime` datetime NOT NULL,
  `ncl_reg_datetime` datetime NOT NULL,
  `ncl_step` varchar(50) NOT NULL,
  PRIMARY KEY  (`ncl_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_house`
-- 

CREATE TABLE `nice_house` (
  `nh_no` int(15) NOT NULL auto_increment,
  `nh_name` varchar(50) NOT NULL,
  `nh_url` varchar(50) NOT NULL,
  `mb_no` int(11) NOT NULL,
  `nh_route` varchar(255) NOT NULL,
  `nh_posx` double NOT NULL,
  `nh_posy` double NOT NULL,
  `nh_level` tinyint(3) NOT NULL,
  `nh_tag` varchar(255) NOT NULL,
  `nh_use` int(3) NOT NULL,
  `nh_jibeon_addr` varchar(255) NOT NULL,
  `nh_road_addr` varchar(255) NOT NULL,
  `nh_own_type` int(2) NOT NULL,
  `nh_floor` tinyint(2) default NULL,
  `nh_corner` tinyint(1) NOT NULL,
  `nh_img` varchar(255) NOT NULL,
  `nh_content` text NOT NULL,
  `nh_call` varchar(50) NOT NULL,
  `nh_master_name` varchar(50) NOT NULL,
  `nh_master_type` varchar(50) NOT NULL,
  `nh_master_call` varchar(50) NOT NULL,
  `nh_edit_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `nh_reg_datetime` datetime NOT NULL,
  `nh_visit` int(11) NOT NULL,
  UNIQUE KEY `nh_no` (`nh_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_house_img`
-- 

CREATE TABLE `nice_house_img` (
  `nhi_no` int(11) NOT NULL auto_increment,
  `nhi_num` int(2) NOT NULL,
  `nh_no` int(11) NOT NULL,
  `img_source` varchar(255) NOT NULL,
  `img_name` varchar(255) NOT NULL,
  `img_filesize` int(11) NOT NULL,
  `img_width` int(11) NOT NULL,
  `img_height` int(11) NOT NULL,
  `img_type` varchar(50) NOT NULL,
  `nhi_cnt` int(11) NOT NULL,
  `nhi_regdatetime` datetime NOT NULL default '0000-00-00 00:00:00',
  UNIQUE KEY `nhi_no` (`nhi_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_house_info`
-- 

CREATE TABLE `nice_house_info` (
  `nh_no` int(11) NOT NULL,
  `nh_st_type` varchar(50) NOT NULL,
  `nh_build_date` date NOT NULL default '0000-00-00',
  `nh_land_area` float default NULL,
  `nh_build_area` float default NULL,
  `nh_build_add_area` float NOT NULL,
  `nh_land_rate` float NOT NULL,
  `nh_build_rate` float NOT NULL,
  `nh_local_type` varchar(50) NOT NULL,
  `nh_build_type` varchar(50) NOT NULL,
  `nh_build_r_type` varchar(50) NOT NULL,
  `nh_car_cnt` tinyint(5) default NULL,
  `nh_el_cnt` tinyint(10) NOT NULL,
  `nh_cctv_use` set('y','n') NOT NULL default 'n',
  `nh_autodoor_use` set('y','n') NOT NULL default 'n',
  `nh_subway` varchar(255) NOT NULL,
  `nh_post_case` tinyint(3) NOT NULL,
  UNIQUE KEY `nh_no` (`nh_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- ̺  `nice_house_sale`
-- 

CREATE TABLE `nice_house_sale` (
  `nh_no` int(11) NOT NULL,
  `nh_sale` tinyint(3) NOT NULL,
  `nh_subject` varchar(255) NOT NULL,
  `nh_sale_pay` varchar(50) NOT NULL,
  `nh_bo_pay` varchar(50) NOT NULL,
  `nh_dae_pay` varchar(50) NOT NULL,
  `nh_sil_pay` varchar(50) NOT NULL,
  `nh_dan_pay` varchar(50) NOT NULL,
  `nh_rent_m_pay` varchar(50) NOT NULL,
  `nh_rent_y_pay` varchar(50) NOT NULL,
  `nh_dae_rate` float NOT NULL,
  `nh_dae_m_pay` varchar(50) NOT NULL,
  `nh_dae_y_pay` varchar(50) NOT NULL,
  `nh_save_m_pay` varchar(50) NOT NULL,
  `nh_save_y_pay` varchar(50) NOT NULL,
  `nh_save_rate` float NOT NULL,
  `nh_option` text NOT NULL,
  `nh_etc` text NOT NULL,
  `nh_environment` text NOT NULL,
  `nh_edit` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- ̺  `nice_land_company`
-- 

CREATE TABLE `nice_land_company` (
  `nl_name` varchar(50) NOT NULL,
  `nl_posx` double NOT NULL,
  `nl_posy` double NOT NULL,
  `nl_level` tinyint(10) NOT NULL,
  `nl_addr` varchar(255) NOT NULL,
  `nl_tel` varchar(50) NOT NULL,
  `nl_fax` varchar(50) NOT NULL,
  `nl_cellphone` varchar(50) NOT NULL,
  `nl_company_name` varchar(50) NOT NULL,
  `nl_master_name` varchar(50) NOT NULL,
  `nl_company_no` varchar(50) NOT NULL,
  `nl_land_no` varchar(50) NOT NULL,
  `nl_web_no` varchar(50) NOT NULL,
  `nl_daumapi_key` varchar(255) NOT NULL,
  `nl_kakao_api_key` varchar(255) NOT NULL,
  `nl_dataapi_key` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- ̺  `nice_land_sale`
-- 

CREATE TABLE `nice_land_sale` (
  `nl_no` int(11) NOT NULL auto_increment,
  `nl_use` varchar(50) NOT NULL,
  `nl_route` varchar(255) NOT NULL,
  `nl_parent` int(11) NOT NULL,
  `nl_type` varchar(50) NOT NULL,
  `nl_land_type` varchar(50) NOT NULL,
  `nl_posx` double NOT NULL,
  `nl_posy` double NOT NULL,
  `nl_addr` varchar(255) NOT NULL,
  `nl_plus_addr` varchar(255) NOT NULL,
  `nl_master_type` varchar(50) NOT NULL,
  `nl_master_name` varchar(50) NOT NULL,
  `nl_master_call` varchar(50) NOT NULL,
  `nl_master_bank` varchar(255) NOT NULL,
  `nl_total_size` int(11) NOT NULL,
  `nl_size` float NOT NULL,
  `nl_g_pay` int(11) NOT NULL,
  `nl_direction` varchar(10) NOT NULL,
  `nl_yongdo` varchar(50) NOT NULL,
  `nl_pay` varchar(100) NOT NULL,
  `nl_dan_pay1` int(11) NOT NULL,
  `nl_dan_pay2` int(11) NOT NULL,
  `nl_doro` varchar(50) NOT NULL,
  `nl_jigu` varchar(50) NOT NULL,
  `nl_build_rate` int(11) NOT NULL,
  `nl_use_rate` int(11) NOT NULL,
  `nl_sale_point` text NOT NULL,
  `nl_memo` text NOT NULL,
  `nl_reg_datetime` datetime NOT NULL,
  `nl_visit` int(11) NOT NULL,
  PRIMARY KEY  (`nl_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_mappoint`
-- 

CREATE TABLE `nice_mappoint` (
  `mp_id` int(11) NOT NULL auto_increment,
  `mp_posx` double default NULL,
  `mp_posy` double default NULL,
  `mp_level` int(11) NOT NULL,
  `mp_route` varchar(255) NOT NULL,
  PRIMARY KEY  (`mp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_room`
-- 

CREATE TABLE `nice_room` (
  `nr_no` int(11) NOT NULL auto_increment,
  `nh_no` int(11) NOT NULL,
  `nr_name` varchar(20) NOT NULL,
  `no_mb_no` int(11) NOT NULL,
  `nr_use` int(1) NOT NULL default '0',
  `nr_type` varchar(50) NOT NULL,
  `nr_room_cnt` tinyint(1) default NULL,
  `nr_bath_cnt` tinyint(1) default NULL,
  `nr_use_area` varchar(10) default NULL,
  `nr_right_area` varchar(10) default NULL,
  `nr_structure` varchar(10) NOT NULL,
  `nr_same_structure` varchar(50) NOT NULL,
  `nr_unit_pr` tinyint(1) NOT NULL,
  `nr_sale_pay` int(11) NOT NULL,
  `nr_dae_pay` int(11) NOT NULL,
  `nr_pay01` int(11) default NULL,
  `nr_pay02` int(11) default NULL,
  `nr_edit_pay` int(11) default NULL,
  `nr_img` varchar(255) NOT NULL,
  `nr_same_type` varchar(50) NOT NULL,
  `nr_edit_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `nr_visit` int(11) NOT NULL,
  `nr_good` int(11) NOT NULL,
  `nr_house_visit` int(11) NOT NULL,
  `nr_pr_naver` varchar(255) NOT NULL,
  `nr_pr_zibbang` varchar(255) NOT NULL,
  `nr_pr_dabang` varchar(255) NOT NULL,
  `nr_double_f` tinyint(1) NOT NULL,
  `nr_indate` varchar(50) NOT NULL,
  PRIMARY KEY  (`nr_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 PACK_KEYS=1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_room_cache`
-- 

CREATE TABLE `nice_room_cache` (
  `nr_no` int(11) NOT NULL,
  `nr_use` int(1) NOT NULL default '0',
  `nh_no` int(11) NOT NULL,
  `nr_name` varchar(50) NOT NULL,
  `nh_name` varchar(50) NOT NULL,
  `no_no` int(11) default NULL,
  `oc_name` varchar(50) NOT NULL,
  `oc_phone` varchar(50) NOT NULL,
  `oc_start` date NOT NULL,
  `oc_end` date NOT NULL,
  `no_wish_end` date NOT NULL,
  `pay01` int(5) NOT NULL,
  `pay02` int(5) NOT NULL,
  `fee` int(10) NOT NULL,
  `total_pay` int(11) NOT NULL,
  `total_fee` int(11) NOT NULL,
  `etility_pay` int(11) NOT NULL,
  `etc_pay` int(11) NOT NULL,
  `voc` varchar(100) NOT NULL,
  `memo` datetime NOT NULL,
  `nr_img` varchar(255) NOT NULL,
  `nr_img_type` int(2) NOT NULL,
  `nr_pr_naver` varchar(255) NOT NULL,
  `nr_pr_zibbang` varchar(255) NOT NULL,
  `nr_pr_dabang` varchar(255) NOT NULL,
  UNIQUE KEY `nr_no` (`nr_no`),
  KEY `nh_no` (`nh_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- ̺  `nice_room_img`
-- 

CREATE TABLE `nice_room_img` (
  `nri_no` int(11) NOT NULL auto_increment,
  `nri_num` int(3) NOT NULL,
  `nr_no` int(11) NOT NULL,
  `img_source` varchar(255) NOT NULL,
  `img_name` varchar(100) NOT NULL,
  `img_filesize` int(11) NOT NULL,
  `img_width` int(11) NOT NULL,
  `img_height` int(11) NOT NULL,
  `img_type` varchar(10) NOT NULL,
  `nri_cnt` int(11) NOT NULL,
  `nri_first` tinyint(1) NOT NULL default '0',
  `nri_regdatetime` datetime NOT NULL,
  UNIQUE KEY `nri_no` (`nri_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_room_info`
-- 

CREATE TABLE `nice_room_info` (
  `nr_no` int(11) NOT NULL,
  `nr_edit` text NOT NULL,
  `nr_floor` tinyint(3) NOT NULL,
  `nr_dog_use` tinyint(1) NOT NULL default '0',
  `nr_park_use` tinyint(1) NOT NULL default '0',
  `nr_subject` varchar(50) NOT NULL,
  `nr_content` text NOT NULL,
  `nr_option1` varchar(255) NOT NULL,
  `nr_safe` varchar(255) NOT NULL,
  `nr_iot_option` varchar(255) NOT NULL,
  `nr_edit_pay_option` varchar(255) NOT NULL,
  `nr_memo` text NOT NULL,
  `nr_memo_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `nr_master_type` varchar(50) NOT NULL,
  `nr_master_name` varchar(50) NOT NULL,
  `nr_master_call` varchar(50) NOT NULL,
  `nr_master_bank_no` varchar(50) NOT NULL,
  `nr_manager_name` varchar(50) NOT NULL,
  `nr_manager_call` varchar(50) NOT NULL,
  `nr_manager_bank_no` varchar(50) NOT NULL,
  `nr_fee_option` varchar(20) NOT NULL,
  `nr_with_fee` tinyint(1) NOT NULL,
  `nr_size` tinyint(3) NOT NULL,
  `nr_direction` varchar(50) NOT NULL,
  UNIQUE KEY `nr_no` (`nr_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- ̺  `nice_temp_img`
-- 

CREATE TABLE `nice_temp_img` (
  `nti_no` int(11) NOT NULL auto_increment,
  `nti_table` varchar(50) NOT NULL,
  `nti_table_no` int(11) NOT NULL,
  `bf_no` int(11) NOT NULL,
  `bf_source` varchar(255) NOT NULL,
  `bf_file` varchar(255) NOT NULL,
  `bf_filesize` int(11) NOT NULL,
  `bf_width` int(11) NOT NULL,
  `bf_height` int(11) NOT NULL,
  `bf_type` int(11) NOT NULL,
  `bf_datetime` datetime NOT NULL,
  `mb_no` int(11) NOT NULL,
  `bf_ip` varchar(50) NOT NULL,
  PRIMARY KEY  (`nti_no`),
  KEY `nti_no` (`nti_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- ̺  `nice_wish_broom`
-- 

CREATE TABLE `nice_wish_broom` (
  `nw_no` int(11) NOT NULL auto_increment,
  `nb_no` int(11) NOT NULL,
  `mb_id` varchar(50) NOT NULL,
  `nw_datetime` datetime NOT NULL,
  `nw_memo` varchar(255) NOT NULL,
  UNIQUE KEY `nw_no` (`nw_no`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;