<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

//------------------------------------------------------------------------
// AMINA SKIN Basic Setup - http://amina.co.kr
//------------------------------------------------------------------------

//G4에서 모바일 사용하면 1, 사용하지 않으면 0 이라고 설정(G5는 상관없음)
$amina['g4_mobile'] = 1; 

//태그(tag)용 게시판 아이디 - 등록한 게시판은 아미나설정에서 보드타입을 '태그 전용 게시판'으로 해주셔야 정상 출력됩니다.
$amina['tag_board'] = '';

//짧은글 주소 : 일반타입 1, 트위터(bit.ly) 2, 구글(goo.gl) 3, 미사용 0
//일반타입 : http://amina.co.kr/skin/1 형태로 http://sir.co.kr/bbs/board.php?bo_table=g4_tiptech&wr_id=20648 글 참고
$amina['use_surl'] = 0;

//Get bit.ly API Key from : bitly.com 가입하면 Username(bitly_id)과 API Key(bitly_key)가 자동발급됨(https://bitly.com/a/your_api_key 에서 확인가능)
$amina['bitly_id']  = '';
$amina['bitly_key'] = '';

//Get goo.gl API key from : http://code.google.com/apis/console/
//URL Shortener API ON
//G5 사용자는 그누관리자에서 키값설정시 따로 설정할 필요없음
$amina['googl_key'] = '';

//------------------------------------------------------------------------
//G4용 SNS 동시등록 API Key - G5 사용자는 그누보드 관리자에서 등록해 주세요.
//G4 사용자는 G5의 /plugin/sns 를 그대로 G4의 /plugin/sns 올려 주셔야 SNS 동시 등록이 작동합니다.
//------------------------------------------------------------------------

//Facebook
$amina['facebook_appid'] = '';
$amina['facebook_secret'] = '';

//Twitter
$amina['twitter_key'] = '';
$amina['twitter_secret'] = '';

//------------------------------------------------------------------------
// JWPlayer6 Licence Key
//------------------------------------------------------------------------
$amina['jwplayer6_key'] = '';

//------------------------------------------------------------------------
// AMINA SKIN XP Setup - http://amina.co.kr
//------------------------------------------------------------------------

//회원레벨 : XP 사용 1, 미사용 0 입력
$xp['xp_use'] = 1;

//경험치(Exp) 적용룰 설정 - 적용시 1, 미적용시 0 입력, 참고로 적용값이 많을수록 느려짐
$xp['exp']['point'] = 0; //현재 총 포인트 - 현재포인트 기준을 적용(1)하면 이후 적용기준은 무시됨 
$xp['exp']['login'] = 1; //로그인 포인트(MP)
$xp['exp']['write'] = 1; //글쓰기 포인트(MP)
$xp['exp']['cmt'] = 1; //댓글쓰기 포인트(MP)
$xp['exp']['read'] = 1; //읽기 포인트(MP) - 읽기 포인트(MP)가 음수(-)일 경우 차감됨
$xp['exp']['good'] = 0; //추천,공감 포인트(MP)
$xp['exp']['good_re'] = 0; //추천,공감 포인트(MP) 받음
$xp['exp']['nogood'] = 0; //비추천 포인트(MP)
$xp['exp']['nogood_re'] = 0; //비추천 포인트(MP) 받음
$xp['exp']['star'] = 0; //별점 포인트(MP)
$xp['exp']['star_re'] = 0; //별점 포인트(MP) 받음
$xp['exp']['poll'] = 0; //투표 포인트(MP)
$xp['exp']['choice'] = 0; //채택 포인트(MP) 받음
$xp['exp']['po_view'] = 0; //열람 포인트(MP) 받음
$xp['exp']['po_down'] = 0; //다운 포인트(MP) 받음
$xp['exp']['chulsuk'] = 0; //출석 포인트(MP)
$xp['exp']['support'] = 0; //후원 포인트(MP)
$xp['exp']['lucky'] = 0; //럭키 포인트(MP)

//다운로드, 열람 & 다운 기능 포인트는 활동보다는 적립한 포인트(경험치)를 사용하는 개념이라 제외

//기본 요구 XP(포인트)
$xp['xp_point'] = 1000; 

//각 레벨별 추가 XP 증가율 → 실제 요구 XP = 기본 요구 XP + (기본 요구 XP * (현재레벨 -1) * $xp[xp_rate)로 산정됨. 
$xp['xp_rate'] = 0;

//최대 레벨
$xp['xp_max'] = 99; 

//레벨 표시 스타일 → 레벨 아이콘 사용시 img 라고 입력
$xp['xp_icon'] = 'txt'; 

//레벨 아이콘 스킨명(/skin/misc/xp/폴더명)
$xp['xp_icon_skin'] = 'zb4'; 

//특별회원(special.gif) 회원아이디 리스트 → 콤마(,)로 회원아이디 구분
$xp['xp_mb_list'] = ''; 

//북수관리자 중 관리자아이콘 미표시 회원아이디 리스트 → 콤마(,)로 회원아이디 구분
$xp['xp_no_admin'] = ''; 

//회원사진 리사이즈 크기 - 너비(width)값
$xp['photo_size'] = 80;

//회원사진으로 움직이는 GIF 파일 사용은 1, 미사용은 0 - 리사이즈 안됨
$xp['animated_gif_photo'] = 0; 

//회원등급 표시 → 그누보드의 회원레벨을 기준으로 표시
$xp['grade'][1] = '비회원';
$xp['grade'][2] = '실버회원';
$xp['grade'][3] = '골드회원';
$xp['grade'][4] = '로얄회원';
$xp['grade'][5] = '프렌드회원';
$xp['grade'][6] = '패밀리회원';
$xp['grade'][7] = '운영자';
$xp['grade'][8] = '운영자';
$xp['grade'][9] = '관리자';
$xp['grade'][10] = '최고관리자';

//------------------------------------------------------------------------
//내글 반응 항목 : 1이면 사용, 0이면 제외
//------------------------------------------------------------------------
$aminaRe['reply'] = 1; //답글 달림 알림
$aminaRe['cmt'] = 1; //댓글 달림 알림
$aminaRe['good'] = 1; //추천 받음 알림
$aminaRe['nogood'] = 1; //비추천 받음 알림
$aminaRe['star'] = 1; //별점 받음 알림
$aminaRe['poll'] = 1; //설문 참여 알림
$aminaRe['shingo'] = 1; //글 블라인드 알림

$aminaRe['cmt_reply'] = 1; //대댓글 달림 알림
$aminaRe['cmt_good'] = 1; //댓글 공감 받음 알림
$aminaRe['cmt_choice'] = 1; //댓글 채택 알림
$aminaRe['cmt_shingo'] = 1; //댓글 블라인드 처리 알림

//------------------------------------------------------------------------
// AMINA THEMA Setup - http://amina.co.kr
//------------------------------------------------------------------------

//PC 테마 설정
if(!$thema) $thema = 'basic';

//모바일 테마 설정
if(!$m_thema) $m_thema = 'basic';

//body 내의 CSS를 head에 모아주는 기능으로 g4만 적용설정 가능(1이면 적용), G5는 그누보드에서 자동 적용 - 적용시 G4에서 배추보드와 충돌 있슴.
$aminaThema['css_buffer'] = 1; 

//아래 스킨들은 사용스킨이 amina일 때만 적용됨. 또한 테마에 각 스킨이 따로 있다면 테마내 스킨이 우선 적용됨.
$aminaThema['outlogin_skin'] = 'basic'; //외부로그인 스킨
$aminaThema['search_skin'] = 'basic'; //전체검색 스킨
$aminaThema['new_skin'] = 'basic'; //전체새글 스킨
$aminaThema['connect_skin'] = 'basic'; //접속자 스킨
$aminaThema['current_connect_skin'] = 'basic'; //현재접속자 스킨
$aminaThema['poll_skin'] = 'basic'; //설문조사 스킨
$aminaThema['popular_skin'] = 'basic'; //인기검색어 스킨
$aminaThema['visit_skin'] = 'basic'; //방문객 스킨
$aminaThema['login_skin'] = 'basic'; //로그인, 비번입력 스킨
$aminaThema['register_skin'] = 'basic'; //회원가입 스킨
$aminaThema['memo_skin'] = 'basic'; //쪽지 스킨
$aminaThema['scrap_skin'] = 'basic'; //스크랩 스킨
$aminaThema['profile_skin'] = 'basic'; //프로필 스킨
$aminaThema['point_skin'] = 'basic'; //포인트(MP), AP 스킨
$aminaThema['formmail_skin'] = 'basic'; //폼메일 스킨
$aminaThema['zip_skin'] = 'basic'; //우편번호 스킨
$aminaThema['response_skin'] = 'basic'; //내글반응 스킨

//타이틀 설정
if($bo_table) { //게시판일 때...

	$aminaThema['title'] = $board['bo_1_subj'];
	$aminaThema['desc'] = $board['bo_1'];

} else if($gr_id && !$bo_table) { //그룹일 때...

	$aminaThema['title'] = $group['gr_1_subj'];
	$aminaThema['desc'] = $group['gr_1'];

} else if($page_name) { //일반 html 문서

	switch($page_name) {
		case 'company'				: $aminaThema['title'] = '{아이콘:leaf} Introduction'; $aminaThema['desc'] = '사이트 소개'; break;
		case 'provision'			: $aminaThema['title'] = '{아이콘:check-circle} Provision'; $aminaThema['desc'] = '이용약관'; break;
		case 'privacy'				: $aminaThema['title'] = '{아이콘:plus-circle} Privacy'; $aminaThema['desc'] = '개인정보보호방침'; break;
		case 'noemail'				: $aminaThema['title'] = '{아이콘:ban} Rejection of E-mail Collection'; $aminaThema['desc'] = '이메일 무단수집 거부'; break;
		case 'disclaimer'			: $aminaThema['title'] = '{아이콘:minus-circle} Lines of Responsibility'; $aminaThema['desc'] = '책임의 한계와 법적고지'; break;
		case 'guide'				: $aminaThema['title'] = '{아이콘:info-circle} User Guide'; $aminaThema['desc'] = '사이트 이용안내'; break;
		case 'license'				: $aminaThema['title'] = '{아이콘:bell} License'; $aminaThema['desc'] = '아미나스킨 라이센스 안내'; break;
		case 'patch'				: $aminaThema['title'] = '{아이콘:wrench} Patch Note'; $aminaThema['desc'] = '아미나스킨 패치노트'; break;
	}

} else { //php파일

	switch(basename($_SERVER['PHP_SELF'])) {
		case 'register.php'			: $aminaThema['title'] = '{아이콘:sign-in} Join'; $aminaThema['desc'] = '회원가입하기'; break;
		case 'register_form.php'	: $aminaThema['title'] = '{아이콘:file-text} Join Form'; $aminaThema['desc'] = '회원가입폼 작성하기'; break;
		case 'register_result.php'	: $aminaThema['title'] = '{아이콘:leaf} Welcome!'; $aminaThema['desc'] = '회원가입을 축하드립니다.'; break;
		case 'login.php'			: $aminaThema['title'] = '{아이콘:user} Login'; $aminaThema['desc'] = '로그인'; break;
		case 'member_confirm.php'	: $aminaThema['title'] = '{아이콘:check-circle} Confirm'; $aminaThema['desc'] = '비밀번호 확인'; break;
		case 'password.php'			: $aminaThema['title'] = '{아이콘:unlock-o} Password'; $aminaThema['desc'] = '비밀번호 입력'; break;
		case 'current_connect.php'	: $aminaThema['title'] = '{아이콘:link} Connect'; $aminaThema['desc'] = '현재접속자'; break;
		case 'new.php'				: $aminaThema['title'] = '{아이콘:refresh} New'; $aminaThema['desc'] = '새글모음'; break;
		case 'search.php'			: $aminaThema['title'] = '{아이콘:search} Search'; $aminaThema['desc'] = '검색하기'; break;
		case 'response.php'			: $aminaThema['title'] = '{아이콘:users} Response'; $aminaThema['desc'] = '내글 반응'; break;
	}
}

//제일 하단에 빈공백이 있으면 캡챠오류가 발생할 수 있으니 주의해 주세요!

?>