<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

if (!defined('LAL_BASIC')) {
	define('LAL_BASIC', true);
	echo '<link rel="stylesheet" href="'.$latest_list_url.'/latest.list.css">'."\n";
}

$od = array();
$is = array();
$css = array();
$icon = array();
$order = array();
$details = array();

//Details
$is['details'] = false;
if($opt['details']) {
	$od = explode(";", $opt['details']);
	for($i=0; $i < count($od); $i++) {
		$o = $i + 1;
		switch($od[$i]) {
			case 'cate'		: $opt['o_cate'] = $o; break;
			case 'name'		: $opt['o_name'] = $o; break;
			case 'date'		: $opt['o_date'] = $o; break;
			case 'cmt'		: $opt['o_cmt'] = $o; break;
			case 'hit'		: $opt['o_hit'] = $o; break;
			case 'good'		: $opt['o_good'] = $o; break;
			case 'nogood'	: $opt['o_nogood'] = $o; break;
			case 'star'		: $opt['o_star'] = $o; break;
			case 'view'		: $opt['o_view'] = $o; break;
			case 'down'		: $opt['o_down'] = $o; break;
		}
	}

	unset($od);

	//Make Array
	$od[0] = $opt['o_cate'];
	$od[1] = $opt['o_name'];
	$od[2] = $opt['o_date'];
	$od[3] = $opt['o_cmt'];
	$od[4] = $opt['o_hit'];
	$od[5] = $opt['o_good'];
	$od[6] = $opt['o_nogood'];
	$od[7] = $opt['o_star'];
	$od[8] = $opt['o_view'];
	$od[9] = $opt['o_down'];

	//Is-value Selected
	for($i=0; $i < 10; $i++) {
		if((int)$od[$i] > 0) $order[] = $od[$i];
	}

	unset($od);

	if($order) {
		$is['details'] = true;
		sort($order); //Sort

		if($opt['o_cate']) {
			$is['cate'] = true;
			list($od['cate']) = array_keys($order, $opt['o_cate']);
			$css[$od['cate']] = 'la-data-cate';
			$opt['icon_cate'] = $opt['icon_cate'] ? $opt['icon_cate'] : 'tag';
			$icon[$od['cate']] = amina_icon($opt['icon_cate']);
		}

		if($opt['o_name']) {
			$is['name'] = true;
			list($od['name']) = array_keys($order, $opt['o_name']);
			$css[$od['name']] = 'la-data-name';
			$opt['icon_name'] = $opt['icon_name'] ? $opt['icon_name'] : 'user';
			$icon[$od['name']] = amina_icon($opt['icon_name']);
		}

		if($opt['o_date']) {
			$is['date'] = true;
			list($od['date']) = array_keys($order, $opt['o_date']);
			$opt['date'] = $opt['date'] ? $opt['date'] : 1;
			$css[$od['date']] = 'la-data-date';
			$opt['icon_date'] = $opt['icon_date'] ? $opt['icon_date'] : 'clock-o';
			$icon[$od['date']] = amina_icon($opt['icon_date']);
		}

		if($opt['o_cmt']) {
			$is['cmt'] = true;
			list($od['cmt']) = array_keys($order, $opt['o_cmt']);
			$css[$od['cmt']] = 'la-data-cmt';
			$opt['icon_cmt'] = $opt['icon_cmt'] ? $opt['icon_cmt'] : '+;t';
			$icon[$od['cmt']] = amina_icon($opt['icon_cmt']);
		}

		if($opt['o_hit']) {
			$is['hit'] = true;
			list($od['hit']) = array_keys($order, $opt['o_hit']);
			$css[$od['hit']] = 'la-data-hit';
			$opt['icon_hit'] = $opt['icon_hit'] ? $opt['icon_hit'] : 'eye';
			$icon[$od['hit']] = amina_icon($opt['icon_hit']);
		}

		if($opt['o_good']) {
			$is['good'] = true;
			list($od['good']) = array_keys($order, $opt['o_good']);
			$css[$od['good']] = 'la-data-good';
			$opt['icon_good'] = $opt['icon_good'] ? $opt['icon_good'] : 'thumbs-up';
			$icon[$od['good']] = amina_icon($opt['icon_good']);
		}

		if($opt['o_nogood']) {
			$is['nogood'] = true;
			list($od['nogood']) = array_keys($order, $opt['o_nogood']);
			$css[$od['nogood']] = 'la-data-nogood';
			$opt['icon_nogood'] = $opt['icon_nogood'] ? $opt['icon_nogood'] : 'thumbs-down';
			$icon[$od['nogood']] = amina_icon($opt['icon_nogood']);
		}

		if ($opt['o_star']) {
			$is['star'] = true;
			list($od['star']) = array_keys($order, $opt['o_star']);
			$css[$od['star']] = 'la-data-star';
			$opt['icon_star'] = $opt['icon_star'] ? $opt['icon_star'] : '';
			$icon[$od['star']] = amina_icon($opt['icon_star']);
		}

		if ($opt['o_view']) {
			$is['view'] = true;
			list($od['view']) = array_keys($order, $opt['o_view']);
			$css[$od['view']] = 'la-data-view';
			$opt['icon_view'] = $opt['icon_view'] ? $opt['icon_view'] : 'leaf';
			$icon[$od['view']] = amina_icon($opt['icon_view']);
		}

		if ($opt['o_down']) {
			$is['down'] = true;
			list($od['down']) = array_keys($order, $opt['o_down']);
			$css[$od['down']] = 'la-data-down';
			$opt['icon_down'] = $opt['icon_down'] ? $opt['icon_down'] : 'download';
			$icon[$od['down']] = amina_icon($opt['icon_down']);
		}

		$od['cnt'] = count($order);
	}
}	

//Details
$od['cnt'] = $is['details'] ? $od['cnt'] : 0;

//Icon
$opt['icon_subj'] = $opt['icon_subj'] ? $opt['icon_subj'] : '';
$opt['icon_subj'] = amina_icon($opt['icon_subj']);

$opt['icon_secret'] = $opt['icon_secret'] ? $opt['icon_secret'] : 'lock';
$opt['icon_secret'] = amina_icon($opt['icon_secret']);

$opt['icon_new'] = $opt['icon_new'] ? $opt['icon_new'] : 'chevron-circle-right';
$opt['icon_new'] = amina_icon($opt['icon_new']);

$opt['icon_hot'] = $opt['icon_hot'] ? $opt['icon_hot'] : 'thumbs-up';
$opt['icon_hot'] = amina_icon($opt['icon_hot']);

if($opt['icon_type']) {
	$opt['icon_img'] = $opt['icon_img'] ? $opt['icon_img'] : 'picture-o';
	$opt['icon_img'] = amina_icon($opt['icon_img']);

	$opt['icon_file'] = $opt['icon_file'] ? $opt['icon_file'] : 'download';
	$opt['icon_file'] = amina_icon($opt['icon_file']);

	$opt['icon_video'] = $opt['icon_video'] ? $opt['icon_video'] : 'video-camera';
	$opt['icon_video'] = amina_icon($opt['icon_video']);

	$opt['icon_audio'] = $opt['icon_audio'] ? $opt['icon_audio'] : 'volume-up';
	$opt['icon_audio'] = amina_icon($opt['icon_audio']);
}

//fancyBox
$fbox_w = $fbox_q = '';
if($opt['fbox']) {
	$fbox_w = 'class="fbox-win" ';
	$fbox_q = '&frame=2';
	if($opt['fbox'] > 1) {
		$fbox_w .= 'data-fbox-width="'.$opt['fbox'].'" ';
		$fbox_q .= '&fwidth='.$opt['fbox'];
	}
}

$opt['subj'] = ($opt['subj'] > 0) ? $opt['subj'] : $subject_len; //제목길이

//추출글 갯수
$list_num = count($list);

?>

<div class="lal-basic<?php echo G5_IS_MOBILE ? ' lal-basic-m' : ''; ?><?php echo $opt['list'] ? ' '.$opt['list'] : ''; ?>">
	<ul>
	<?php for ($i=0; $i < $list_num; $i++) { 
		$wr_post = amina_array_write($list[$i]['wr_10']);
		$details_item = '';
		if($is['details']) { //Item Output
			if($is['cate']) $details[$od['cate']] = $list[$i]['ca_name']; //Category
			if($is['name']) $details[$od['name']] = amina_text($list[$i]['wr_name']); //Name
			if($is['date']) { //Date
				switch($opt['date']) {
					case '1'	: break;
					case '2'	: $list[$i]['datetime2'] = amina_date($list[$i]['wr_datetime']); break;
					default		: $list[$i]['datetime2'] = date($opt['date'], strtotime($list[$i]['wr_datetime'])); break;
				}
				$details[$od['date']] = $list[$i]['datetime2'];
			}
			if($is['cmt']) $details[$od['cmt']] = number_format($list[$i]['wr_comment']); //Comment
			if($is['hit']) $details[$od['hit']] = number_format($list[$i]['wr_hit']); //Hit
			if($is['good']) $details[$od['good']] = number_format($list[$i]['wr_good']); //Good
			if($is['nogood']) $details[$od['nogood']] = number_format($list[$i]['wr_nogood']); //Nogood
			if($is['star']) $details[$od['star']] = amina_star_mark($opt['star'], $list[$i]['wr_7'], 's'); //Star
			if($is['view'] || $is['down']) {
				$wr_icon = amina_array_icon($list[$i]['wr_5']);
				if($is['view']) $details[$od['view']] = number_format($wr_icon['po_view_point']); //Po View
				if($is['down']) $details[$od['down']] = number_format($wr_icon['po_down_point']); //Po Down
			} 
			
			$z = 0;
			for($o=0; $o < $od['cnt']; $o++) { 
				if (!$details[$o]) continue;
				$css_data = ($z == 0) ? 'la-data-first ' : 'la-data ';
				$details_item .= '<b class=\''.$css_data.$css[$o].'\'>'.$icon[$o].$details[$o].'</b>';
				$z++;
			}
			if($details_item) $details_item = '<span class="la-details">'.$details_item.'</span>';
			unset($datails);
		}

		$rank_icon = ($opt['order'] && $list[$i]['wr_rank'] && $opt['icon_rank']) ? '<span class="la-rank la-rank-'.$list[$i]['wr_rank'].'">'.$list[$i]['wr_rank'].'</span>' : '';
		if($wr_post['subj_icon']) {
			$post_icon = '<i class=\'fa fa-'.$wr_post['subj_icon'].'\'></i>';
		} else {
			$post_icon = $opt['icon_subj'];
			if($list[$i]['icon_secret']) {
				$post_icon = $opt['icon_secret'];
			} else if($list[$i]['icon_new']) {
				$post_icon = $opt['icon_new'];
			} else if($list[$i]['icon_hot']) {
				$post_icon = $opt['icon_hot'];
			} else if($opt['icon_type']) {
				if($wr_post['video'] == "video") {
					$post_icon = $opt['icon_video'];
				} else if($wr_post['video'] == "audio") {
					$post_icon = $opt['icon_audio'];
				} else if($wr_post['photo'] == "photo") {
					$post_icon = $opt['icon_img'];
				} else if($wr_post['file'] == "file") {
					$post_icon = $opt['icon_file'];
				}
			}
		}				
		$post_icon = ($list[$i]['icon_new'] && $post_icon) ? '<span class="la-new">'.$post_icon.'</span>' : $post_icon;
		$subject = amina_cut($list[$i]['wr_subject'], $opt['subj']);
		if($opt['cate'] && $list[$i]['ca_name']) $subject = '['.$list[$i]['ca_name'].'] '.$subject;
		if($list[$i]['is_notice']) $subject = '<b>'.$subject.'</b>';
	?>
	<li class="la-list">
		<a <?php echo $fbox_w;?>href="<?php echo $list[$i]['href'].$fbox_q;?>"<?php echo $opt['href_target'];?>>
			<?php echo $details_item; ?>
			<span class="la-subj"><?php echo $rank_icon.$post_icon.$subject; ?></span>
		</a>
	</li>
	<?php } ?>
	<?php if($list_num == 0) { ?>
		<li class="la-none">게시물이 없습니다.</li>
	<?php } ?>
	</ul>
	<div class="clear"></div>
</div>
