<?php
$sub_menu = "400110";
include_once("./_common.php");

auth_check($auth[$sub_menu], 'w');

$g5['title'] = '사이트메뉴관리';
$administrator = 1;

$bm_idx = $bdb->esc($_GET['bm_idx']);
$bm_pidx = $bdb->esc($_GET['bm_pidx']);

//메뉴타입
$type_s = new SelectBox();
$type_s->add('group', '메뉴그룹');
$type_s->add('board', '게시판');
$type_s->add('page', '페이지');
$type_s->add('link', '외부링크');

//게시판목록
$board_s = new SelectBox();
$sql = "SELECT bo_table, bo_subject FROM ".$g5['board_table'];
$result = $bdb->query($sql);
while($row = $bdb->fetch($result)){
	$board_s->add($row['bo_table'], '['.$row['bo_table'].'] '.$row['bo_subject']);
}

//===========================================================================
// PC용 스킨 옵션
//===========================================================================
// pc용 레이아웃 스킨 옵션
$dir = BT_SKIN_PATH.'/layout';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$layout_s = new SelectBox();
foreach($dirs as $key=>$val) $layout_s->add($val, $val);

//group 스킨목록
$dir = BT_SKIN_PATH.'/group';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$group_s = new SelectBox();
foreach($dirs as $key=>$val) $group_s->add($val, $val);

//===========================================================================
// 모바일용 스킨 옵션
//===========================================================================
// 모바일용 레이아웃 스킨목록
$dir = BT_MSKIN_PATH.'/layout';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$mlayout_s = new SelectBox();
foreach($dirs as $key=>$val) $mlayout_s->add($val, $val);

//group 스킨목록
$dir = BT_MSKIN_PATH.'/group';
$dirs = FileDir::getDirEntry($dir, 'd', 'php');
$mgroup_s = new SelectBox();
foreach($dirs as $key=>$val) $mgroup_s->add($val, $val);

//===========================================================================
// 기타
//===========================================================================
//페이지 목록
$sql = "SELECT * FROM ".$bt['page_table']." ORDER BY bp_id";
$result = $bdb->query($sql);
$page_s = new SelectBox();
while($row = $bdb->fetch($result)){
	$page_s->add($row['bp_id'], '['.$row['bp_id'].'] '.$row['bp_title']);
}

//링크타겟옵션 만들기
$target_s = new SelectBox();
$target_s->add('_self', '현재창');
$target_s->add('_blank', '새창');

//접근권한옵션 만들기
$perm_s = new SelectBox();
for($i=1;$i<=10;$i++) $perm_s->add($i, $i);

//접속기기 옵션 만들기
$device_s = new SelectBox();
$device_s->add('both', '모두');
$device_s->add('pc', 'PC');
$device_s->add('mobile', '모바일');

//수정이면
if($bm_idx){
	$sql = "SELECT a.*, b.bm_name as p_name 
		FROM ".$bt['menu_table']." a 
		LEFT OUTER JOIN ".$bt['menu_table']." b 
		ON a.bm_pidx=b.bm_idx 
		WHERE a.bm_idx=".$bm_idx;
		
	$view = $bdb->fetch($sql);
	$p_name = Str::binValue($view['p_name'], "최상위");
	if($view['bm_type']=='board') $board_s->selectedFromValue = $view['bm_mid'];
	
	$layout_s->selectedFromValue = $view['bm_skin_layout'];
	$group_s->selectedFromValue = $view['bm_skin_group'];
	
	$mlayout_s->selectedFromValue = $view['bm_skin_mlayout'];
	$mgroup_s->selectedFromValue = $view['bm_skin_mgroup'];
	
	if($view['bm_type']=='page') $page_s->selectedFromValue = $view['bm_mid'];
	$target_s->selectedFromValue = $view['bm_target'];
	$perm_s->selectedFromValue = $view['bm_perm'];
	$device_s->selectedFromValue = $view['bm_device'];
	
//추가이면
}else{
	$bm_pidx = $bdb->esc($_GET['bm_pidx']);
	
	//부모정보
	if((int)$bm_pidx > 0){
		$sql = "SELECT bm_name FROM ".$bt['menu_table']." WHERE bm_idx=".$bm_pidx;
		$p_name = $bdb->result($sql);
	}else{
		$p_name = "최상위";
	}
}

include_once(G5_PATH.'/head.sub.php');
?>

<style type='text/css'>
.menu_attr{display:none}
</style>

<script type="text/javascript">
<!--
function showAttr(){
	
	var mode = $('.bm_type:checked').val();
	//alert(mode)

	$('.menu_attr').hide();
	
	if(mode == 'group'){
		$('#attr_group').show();
		
	}else if(mode == 'board'){
		$('#attr_board').show();
		
	}else if(mode == 'page'){
		$('#attr_page').show();
		
	}else if(mode == 'link'){
		$('#attr_link').show();
	}
}

function fmenuform_submit(f){
	var bm_type = $('.bm_type:checked').val();

	if(bm_type == 'group'){
		if(f.bm_skin_group.value == ''){
			alert('본문스킨을 선택해 주세요');
			f.bm_skin_group.focus();
			return false;
		}
		if(f.bm_skin_mgroup.value == ''){
			alert('모바일 본문스킨을 선택해 주세요');
			f.bm_skin_mgroup.focus();
			return false;
		}
		
	}else if(bm_type == 'board'){
		if(f.bo_table.value == ''){
			alert('게시판을 선택해 주세요');
			f.bo_table.focus();
			return false;
		}
	}else if(bm_type == 'page'){
		if(f.bm_page.value == ''){
			alert('페이지를 선택해 주세요');
			f.bm_page.focus();
			return false;
		}
	}else if(bm_type == 'link'){
		if(f.bm_url.value.trim() == ''){
			alert('URL을 입력해 주세요');
			f.bm_url.focus();
			return false;
		}
	}
	return true;
}

$(function(){
	showAttr();
	$('.bm_type').click(showAttr);
});
//-->
</script>


<form name="fmenuform" id="fmenuform" action="./menu_update.php" onsubmit="return fmenuform_submit(this)" method="post">
<input type="hidden" name="w" value="<?php echo $w ?>">
<input type="hidden" name="bm_idx" value="<?php echo $bm_idx?>">
<input type="hidden" name="bm_pidx" value="<?php echo $bm_pidx?>">
<section>
    <h2 class="h2_frm">메뉴 설정</h2>

    <div class="tbl_frm01 tbl_wrap">
        <table>
        <caption>게시판 기본 설정</caption>
        <colgroup>
            <col class="grid_2">
            <col class="grid_7">
        </colgroup>
        <tbody>
        <tr>
            <th scope="row"><label for="bm_code">상위메뉴</label></th>
            <td><?php echo $p_name?></td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_name">메뉴이름</label></th>
        	<td><input type="text" name="bm_name" value="<?php echo $view['bm_name']?>" class="required frm_input" required size="20" maxlength="20" /></td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_type">메뉴타입</label></th>
        	<td>
        		
        		<input type="radio" name="bm_type" class="bm_type" id="bm_type_1" value="group" <?=$view['bm_type']=='group' || $view['bm_type'] == ''?"checked='checked'":'';?> >
        		<label for="bm_type_1">게시판그룹</label>
        		
        		<input type="radio" name="bm_type" class="bm_type" id="bm_type_2" value="board" <?=$view['bm_type']=='board'?"checked='checked'":'';?> >
        		<label for="bm_type_2">게시판</label>
        		
        		<input type="radio" name="bm_type" class="bm_type" id="bm_type_3" value="page" <?=$view['bm_type']=='page'?"checked='checked'":'';?> >
        		<label for="bm_type_3">페이지</label>
        		
        		<input type="radio" name="bm_type" class="bm_type" id="bm_type_4" value="link" <?=$view['bm_type']=='link'?"checked='checked'":'';?> >
        		<label for="bm_type_4">외부링크</label>
        		
        		<span class="frm_info" style="margin-top:5px">해당메뉴를 클릭했을때 화면에 표시할 모듈타입을 정의합니다.</span>
        		<span class="frm_info">하위메뉴는 메뉴타입과 상관없이 추가할 수 있습니다</span>
        		
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_target">링크타겟</label></th>
        	<td><select name="bm_target"><?php echo $target_s->getOption()?></select></td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_perm">접근레벨</label></th>
        	<td><select name="bm_perm"><?php echo $perm_s->getOption()?></select></td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_device">접속기기</label></th>
        	<td><select name="bm_device"><?php echo $device_s->getOption()?></select></td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_skin_layout">PC 스킨</label></th>
        	<td><select name="bm_skin_layout" id="bm_skin_layout"><?=$layout_s->getOption()?></select>
        		<span class="frm_info" style="margin-top:5px">메뉴타입이 외부링크일때는 적용되지 않습니다</span>
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_skin_mlayout">모바일 스킨</label></th>
        	<td><select name="bm_skin_mlayout" id="bm_skin_mlayout"><?=$mlayout_s->getOption()?></select>
        		<span class="frm_info" style="margin-top:5px">메뉴타입이 외부링크일때는 적용되지 않습니다</span>
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label for="bm_hide">숨김</label></th>
        	<td><input type="checkbox" name="bm_hide" value="1" <?=$view['bm_hide'] ? 'checked="checked"' : '';?>></td>
        </tr>
        </table>
        
        <table id="attr_group" class="menu_attr">
        <caption>그룹속성</caption>
        <colgroup>
            <col class="grid_2">
            <col class="grid_7">
        </colgroup>
        <tbody>
        <tr>
        	<th scope="row"><label>본문스킨</label></th>
        	<td><label for="bm_skin_group">PC</label>
        		<select name="bm_skin_group" id="bm_skin_group"><?=$group_s->getOption()?></select>
        		<label for="bm_skin_mgroup">모바일</label>
        		<select name="bm_skin_mgroup" id="bm_skin_mgroup"><?=$mgroup_s->getOption()?></select>
        	</td>
        </tr>
        </tbody>
    	</table>
    	
    	
    	<table id="attr_board" class="menu_attr">
        <caption>게시판</caption>
        <colgroup>
            <col class="grid_2">
            <col class="grid_7">
        </colgroup>
        <tbody>
        <tr>
        	<th scope="row"><label for="bo_table">게시판선택</label></th>
        	<td><select name="bo_table"><?=$board_s->getOption()?></select>
        		<span class="frm_info">1.다른메뉴에서 사용중인 게시판은 선택할 수 없습니다</span>
        		<span class="frm_info">2.게시판 설정에 반드시 아래와 같이 입력하셔야 메뉴가 적용됩니다.</span>
        		<span class="frm_info">
        		상단파일경로 : _head.php<br />
        		하단파일경로 : _tail.php
        		</span>
        	</td>
        </tr>
        </tbody>
    	</table>
    	
    	<table id="attr_page" class="menu_attr">
        <caption>페이지</caption>
        <colgroup>
            <col class="grid_2">
            <col class="grid_7">
        </colgroup>
        <tbody>
        <tr>
        	<th scope="row"><label for="bp_id">페이지선택</label></th>
        	<td><select name="bp_id" id="bp_id"><?=$page_s->getOption()?></select>
        		<span class="frm_info" style="margin-top:5px">다른메뉴에서 사용중인 페이지는 선택할 수 없습니다</span>
        	</td>
        </tr>
        </tbody>
    	</table>
    	
    	<table id="attr_link" class="menu_attr">
        <caption>외부링크</caption>
        <colgroup>
            <col class="grid_2">
            <col class="grid_7">
        </colgroup>
        <tbody>
        <tr>
    	<tr>
        	<th scope="row"><label for="bm_url">URL</label></th>
        	<td><input type="text" name="bm_url" value="<?php echo $view['bm_url']?>" class="frm_input" size="50" maxlength="255" />
        		<span class="frm_info" style="margin-top:5px">연결할 외부페이지의 URL을 입력해주세요</span>
        		<span class="frm_info">예) http://www.google.co.kr/page.html</span>
        	</td>
        </tr>
        </table>
    </div>
</section>

<div class="btn_confirm01 btn_confirm">
    <input type="submit" value="확인" class="btn_submit" accesskey="s">
    <a href="menu_list.php?<?php echo $qstr ?>" onclick="window.close();return false">창닫기</a>
</div>
</form>

<?php
include_once(G5_PATH.'/tail.sub.php');
?>