<?php
/**
* @file Validator.php
*
* @class Validator
*
* @bref 입력값 체크 (아직 별 기능은 없지만 앞으로 추가할 계획이다)
* 
* @date 2009
*
* @author 권혁준(impactlife@naver.com)
*
* @copyright PLUGSYS.co.kr. & Kwon Hyuk-June. All rights reserved.
*
* @section MODIFYINFO
* 	- 없음/없음
*
* @section Example
*   - 없음
*/
class Validator{
	
	public static function alert($str, $name){
		if(Str::isValue($name)) $str .= ' ['.$name.']';
		alert($str);
		exit;
	}
	
	public static function checkBlank($value, $name=''){
		if(Str::isBlank($value)){
			$str = "값이 전달되지 않았습니다";
			alert($str, $name);
		}
	}
	
	public static function checkAlphaNum($value, $name=''){
		if(!ctype_alnum($value)){
			//$str = Lang::get()->val_alphanum;
			$str = "영문 알파벳과 숫자만 입력해야 합니다";
			self::alert($str, $name);
		}
	}
	
	public static function checkAlpha($value, $name=''){
		if(!ctype_alpha($value)){
			//$str = Lang::get()->val_alpha;
			$str = "알파벳만 입력해야 합니다";
			self::alert($str, $name);
		}
	}
	
	public static function checkDigit($value, $name=''){
		if(!ctype_digit($value)){
			//$str = Lang::get()->val_digit;
			$str = "숫자만 입력해야 합니다";
			self::alert($str, $name);
		}
	}
	
	public static function checkLower($value, $name=''){
		if(!ctype_lower($value)){
			//$str = Lang::get()->val_lower;
			$str = "소문자만 입력해야 합니다";
			self::alert($str, $name);
		}
	}
	
	public static function checkUpper($value, $name=''){
		if(!ctype_upper($value)){
			//$str = Lang::get()->val_upper;
			$str = "대문자만 입력해야 합니다";
			self::alert($str, $name);
		}
	}
}

/* Alias */
class Val extends Validator{}