<?php
$sub_menu = "400400";
include_once("./_common.php");
include_once(G5_EDITOR_LIB);

auth_check($auth[$sub_menu], 'w');

$g5['title'] = '팝업관리';
$administrator = 1;

include_once(G5_ADMIN_PATH.'/admin.head.php');

include_once(G5_PLUGIN_PATH.'/jquery-ui/datepicker.php');

$bp_idx = $bdb->esc($_GET['bp_idx']);
$sfl = $bdb->esc($_GET['sfl']);
$stx = $bdb->esc($_GET['stx']);
$sst = $bdb->esc($_GET['sst']);
$sod = $bdb->esc($_GET['sod']);
$page = $bdb->esc($_GET['page']);

$type_s = new SelectBox();
$type_s->add('image', '이미지형');
$type_s->add('html', 'HTML형');

$target_s = new SelectBox();
$target_s->add('_self', '현재창');
$target_s->add('_blank', '새창');

//시간
$hour_s = new SelectBox();
for($i=0;$i<=23;$i++){
	$hour = sprintf('%02d', $i);
	$hour_s->add($hour, $hour);
}

//분
$min_s = new SelectBox();
for($i=0;$i<=59;$i++){
	$min = sprintf('%02d', $i);
	$min_s->add($min, $min);
}

if($bp_idx != ''){
	$sql = "SELECT * FROM ".$bt['popup_table']." WHERE bp_idx='".$bp_idx."'";
	$row = $bdb->fetch($sql);
	
	$type_s->selectedFromValue = $row['bp_type'];
	
	list($sdate, $stime) = explode(' ', $row['bp_sdate']);
	list($edate, $etime) = explode(' ', $row['bp_edate']);
	
	list($shour, $smin) = explode(':', $stime);
	list($ehour, $emin) = explode(':', $etime);
	
	$hour_s->selectedFromValue = $shour;
	$shour_opts = $hour_s->getOption();
	
	$hour_s->selectedFromValue = $ehour;
	$ehour_opts = $hour_s->getOption();
	
	$min_s->selectedFromValue = $smin;
	$smin_opts = $min_s->getOption();
	
	$min_s->selectedFromValue = $emin;
	$emin_opts = $min_s->getOption();
		
	$target_s->selectedFromValue = $row['bp_target'];
	
	$w = 'u';
	$readonly = 'readonly';
}else{
	$required = 'required';
	
	$shour_opts = $hour_s->getOption();
	$ehour_opts = $hour_s->getOption();
	$smin_opts = $min_s->getOption();
	$emin_opts = $min_s->getOption();
}

$editor_js = '';
$editor_js .= get_editor_js('bp_content');
$editor_js .= chk_editor_js('bp_content');
?>

<script type="text/javascript">
<!--
function fpopupform_submit(f){

	if(f.bp_show_closeopt.checked){
		if(f.bp_close_hour.value.trim()==''){
			alert('닫기옵션의 시간을 입력해주세요');
			f.bp_close_hour.focus();
			return false;
		}
	}

	if($('.bp_type:checked').val().trim() == 'html'){
		if(f.bp_width.value.trim()==''){
			alert('가로크기를 입력해주세요');
			f.bp_width.focus();
			return false;
		}else if(f.bp_height.value.trim()==''){
			alert('세로크기를 입력해주세요');
			f.bp_height.focus();
			return false;
		}
		
		<?php echo $editor_js; // 에디터 사용시 자바스크립트에서 내용을 폼필드로 넣어주며 내용이 입력되었는지 검사함   ?>
	}else{
		if(f.bp_idx.value.trim() == '' && f.bp_file.value.trim()==''){
			alert('업로드 할 이미지파일을 선택해주세요');
			f.bp_file.focus();
			return false;
		}
	}
	
	return true;
}

function showOption(){
	var bp_type = $('.bp_type:checked').val();
	if(bp_type=='image'){
		$('.html_opt').hide();
		$('.image_opt').show();
	}else{
		$('.html_opt').show();
		$('.image_opt').hide();
	}
}

$(function(){
	showOption();
	$('.bp_type').click(showOption);

    $("#sdate, #edate").datepicker({ changeMonth: true, changeYear: true, dateFormat: "yy-mm-dd", showButtonPanel: true, yearRange: "c-99:c+99" }); 

});

//-->
</script>

<form name="fpopupform" id="fpopupform" action="./popup_update.php" onsubmit="return fpopupform_submit(this)" method="post" enctype="multipart/form-data">
<input type="hidden" name="w" value="<?php echo $w ?>">
<input type="hidden" name="sfl" value="<?php echo $sfl ?>">
<input type="hidden" name="stx" value="<?php echo $stx ?>">
<input type="hidden" name="sst" value="<?php echo $sst ?>">
<input type="hidden" name="sod" value="<?php echo $sod ?>">
<input type="hidden" name="page" value="<?php echo $page ?>">
<input type="hidden" name="bp_idx" value="<?php echo $bp_idx?>">

<section id="anc_bo_basic">
    <h2 class="h2_frm">팝업 편집</h2>
    <?php echo $pg_anchor ?>

    <div class="tbl_frm01 tbl_wrap">
        <table>
        <caption>팝업 편집</caption>
        <colgroup>
            <col class="grid_4">
            <col>
            <col class="grid_3">
        </colgroup>
        <tbody>
        <tr>
            <th scope="row"><label for="bp_subject">제목</label></th>
            <td colspan="2"><input type="text" name="bp_subject" value="<?php echo $row['bp_subject']?>" size="50" maxlength="100" <?php echo $required ?> class="frm_input <?php echo $required ?> <?php echo $required_valid ?>" maxlength="20"></td>
        </tr>
        <tr>
        	<th scope="row"><label>제목노출</label></th>
        	<td colspan="2"><input type="checkbox" name="bp_show_subject" id="bp_show_subject" value="1" <?php echo $row['bp_show_subject']=='1'?'checked="checked"':'';?>>
        		<label for="bp_show_subject">노출함</label>
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label>닫기옵션</label></th>
        	<td colspan="2"><input type="checkbox" name="bp_show_closeopt" id="bp_show_closeopt" value="1" <?php echo $row['bp_show_closeopt']=='1'?'checked="checked"':'';?>>
        		<label for="bp_show_closeopt">사용함</label>
        		<input type="text" name="bp_close_hour" id="bp_close_hour" value="<?php echo $row['bp_close_hour']?>" size="5" maxlength="4">
        		<label for="bp_close_hour">시간 동안 다시 띄우지 않음</label>
        		<input type="button" value="1시간" onclick="$('#bp_close_hour').val('1');" />
        		<input type="button" value="하루" onclick="$('#bp_close_hour').val('24');" />
        		<input type="button" value="이틀" onclick="$('#bp_close_hour').val('48');" />
        		<input type="button" value="3일" onclick="$('#bp_close_hour').val('72');" />
        		<input type="button" value="일주일" onclick="$('#bp_close_hour').val('168');" />
        		<input type="button" value="30일" onclick="$('#bp_close_hour').val('720');" />
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label>기간</label></th>
        	<td colspan="2">
        		<label for="sdate" class="sound_only">시작일</label>
        		<input type="text" name="sdate" id="sdate" value="<?php echo $sdate ?>" size="11" maxlength="10" <?php echo $required ?> class="frm_input <?php echo $required ?>">
        		<label for="shour" class="sound_only">시작(시)</label>
        		<select name="shour" id="shour"><?php echo $shour_opts?></select>
        		:
        		<label for="smin" class="sound_only">시작(분)</label>
        		<select name="smin" id="smin"><?php echo $smin_opts?></select>
			    ~
			    <input type="text" name="edate" id="edate" value="<?php echo $edate ?>" size="11" maxlength="10" <?php echo $required ?> class="frm_input <?php echo $required ?>">
			    <label for="edate" class="sound_only">종료일</label>
			    <label for="ehour" class="sound_only">종료(시)</label>
        		<select name="ehour" id="ehour"><?php echo $ehour_opts?></select>
        		:
        		<label for="emin" class="sound_only">종료(분)</label>
        		<select name="emin" id="emin"><?php echo $emin_opts?></select>
			    
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label>노출여부</label></th>
        	<td colspan="2">
        		<input type="checkbox" name="bp_hide" id="bp_hide" class="bp_hide" value="1" <?php echo $row['bp_hide']=='l' ? 'checked="checked"':'';?>>
        		<label for="bp_hide">숨김</label>
        	</td>
        </tr>
        <tr>
        	<th scope="row"><label>팝업타입</label></th>
        	<td colspan="2">
        		<input type="radio" name="bp_type" id="bp_type_1" class="bp_type" value="html" <?php echo $row['bp_type']=='html' || $row['bp_type']=='' ? 'checked="checked"':'';?>>
        		<label for="bp_type_1">HTML형</label>
        		<input type="radio" name="bp_type" id="bp_type_2" class="bp_type" value="image" <?php echo $row['bp_type']=='image' ? 'checked="checked"':'';?>>
        		<label for="bp_type_2">이미지형</label>
        	</td>
        </tr>
        <tr class="html_opt">
        	<th scope="row"><label>창크기</label></th>
        	<td colspan="2">
        		<label for="bp_width">가로</label>
        		<input type="text" name="bp_width" id="bp_width" value="<?php echo $row['bp_width']?>" size="5" maxlength="3" class="frm_input">
        		<label for="bp_height">세로</label>
        		<input type="text" name="bp_height" id="bp_height" value="<?php echo $row['bp_height']?>" size="5" maxlength="3" class="frm_input">
        	</td>
        </tr>
        <tr class="html_opt">
        	<th scope="row"><label for="bp_content">내용입력</label></th>
        	<td colspan="2">
        		<span class="frm_info">모바일페이지를 위해 내용편집시 가로 크기를 고정 픽셀로 설정하지 않는게 좋습니다</span>
        		<?php echo editor_html("bp_content", $row['bp_content']); ?>
        	</td>
        </tr>
        <tr class="image_opt">
        	<th scope="row"><label for="bp_file">이미지</label></th>
        	<td colspan="2"><input type="file" name="bp_file" id="bp_file" value="<?php echo $row['bp_file']?>" class="frm_file">
        		<?php if($row['bp_file']){?>
        			<p><img src="<?php echo G5_DATA_URL."/file/popup/".$row['bp_file']?>" width="100" height="100"></p>
        		<?php }?>
        	</td>
        </tr>
        <tr class="image_opt">
        	<th scope="row"><label>URL</label></th>
        	<td colspan="2">
        		<label for="bp_url" class="sound_only">URL</label>
        		<input type="text" name="bp_url" id="bm_url" size="50" class="frm_input" value="<?php echo $row['bp_url']?>">
        		<label for="bp_target" class="sound_only">링크타겟</label>
        		<select name="bp_target" id="bp_target"><?php echo $target_s->getOption()?></select>
        	</td>
        </tr>
    	</tbody>
    	</table>
    </div>
</section>

<div class="btn_confirm01 btn_confirm">
    <input type="submit" value="확인" class="btn_submit" accesskey="s">
    <a href="popup_list.php?<?php echo $qstr ?>">목록으로</a>
</div>

</form>

<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');