<?php
//===========================================================================
// 상수정의
//===========================================================================
define('DS', DIRECTORY_SEPARATOR);

define('BT_PREFIX', 'bt_');

define('BT_ADMIN_DIR', 'bart');
define('BT_ADMIN_PATH', G5_ADMIN_PATH.'/'.BT_ADMIN_DIR);
define('BT_ADMIN_URL', G5_ADMIN_URL.'/'.BT_ADMIN_DIR);

define('BT_SKIN_DIR', 'bt.skin');
define('BT_SKIN_PATH', G5_SKIN_PATH.'/'.BT_SKIN_DIR);
define('BT_SKIN_URL', G5_SKIN_URL.'/'.BT_SKIN_DIR);

define('BT_MSKIN_PATH', G5_MOBILE_PATH.'/'.G5_SKIN_DIR.'/'.BT_SKIN_DIR);
define('BT_MSKIN_URL', G5_MOBILE_URL.'/'.G5_SKIN_DIR.'/'.BT_SKIN_DIR);

//===========================================================================
// 디버그모드 or 릴리즈 모드
//===========================================================================
//디버그모드(true), 릴리즈모드(false)
define('BT_DEBUG', true);

if(BT_DEBUG) ini_set('display_errors', '1');
else ini_set('display_errors', '0');

//===========================================================================
// 오토로드 정의
//===========================================================================
include(G5_PATH.'/lib/bart/Loader.php');

//클래스 자동로드 프로시저 지정
Loader::autoloadSetup();

//BART라이브러리를 오토로드 대상으로 지정함
Loader::registAll(G5_PATH.'/lib/bart/classes');

//===========================================================================
// 에러핸들러 정의
//===========================================================================
//include(G5_LIB_PATH.'/bart/bart.lib.php');
//set_error_handler('error_handler', ini_get('error_reporting'));
//G5의 common.php에서 지정한 리포팅레벨을 그대로 사용함
set_error_handler(array(BTError::getInstance(), 'showError'));

//===========================================================================
// 테이블 정의
//===========================================================================
$bt = array();
$bt['config_table'] = BT_PREFIX.'config';
$bt['menu_table'] = BT_PREFIX.'menu';
$bt['page_table'] = BT_PREFIX.'page';
$bt['popup_table'] = BT_PREFIX.'popup';

//===========================================================================
// DB 클래스 생성 (그누보드 함수가 조금 불편해서 간단하게 만듬...)
//===========================================================================
/** @var DB **/
$bdb = DB::getInstance();
if(BT_DEBUG) $bdb->setDebug(true);


//===========================================================================
// 메뉴 로드
//===========================================================================
$btmenu= Menu::getInstance();
$list = $btmenu->getTreeList('pc', true, '0');

//===========================================================================
// 바트 config 로드
//===========================================================================
$sql = "SELECT * FROM ".$bt['config_table']." LIMIT 1";
$btcfg = $bdb->fetch($sql);

//===========================================================================
// 현재위치 파악
//===========================================================================
if($bm_idx){
	$bt['curmenu'] = $btmenu->getWithIdx($bm_idx);
	$bt['curpath'] = $btmenu->getPath($bm_idx);
}else{
	if($bm_type && $bm_mid){
		$bt['curmenu'] = $btmenu->getWithMid($bm_type, $bm_mid);
		$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
	}else{
		if($bo_table){
			$bt['curmenu'] = $btmenu->getWithMid('board', $bo_table);
			$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
		}else if($bp_id){
			$bt['curmenu'] = $btmenu->getWithMid('page', $bp_id);
			$bt['curpath'] = $btmenu->getPath($bt['curmenu']['bm_idx']);
		}
	}
}
//타이틀
$cur_title = $bt['curpath'][count($bt['curpath'])-1]['bm_name'];

//현재위치
$cur_path = Menu::getPathString($bt['curpath']);

//접근권한 체크
if($bt['curmenu']['bm_perm'] > $member['mb_level']){
	if(!$member['mb_id']){
		alert("접근 권한이 없습니다.\\n회원이시라면 로그인 후 이용해 보십시오.", G5_BBS_URL.'/login.php?'.$qstr.'&url='.urlencode($_SERVER['PHP_SELF'].'?bo_table='.$bo_table));
	}else{
		alert('회원님의 회원등급으로 접근할 수 없는 메뉴입니다');
	}
}
