<?php
/**
* @file Popup.php
*
* @class Popup
*
* @bref 팝업 출력
* 
* @date 2013.12
*
* @author 권혁준(impactlife@naver.com)
*
* @copyright PLUGSYS.co.kr. & Kwon Hyuk-June. All rights reserved.
*
* @section MODIFYINFO
* 	- 없음/없음
*
* @section Example
*   - 없음
*/

class Popup{
	
//스킨에서 float로 처리로 변경되어 필요없게 됨
//	private $left;
//	private $top;
//	private $maxheight;

	private $db;
	private $table;
	
	public function __construct(){
		
		$this->db = DB::getInstance();
		
//		$this->left = 5;
//		$this->top = 5;
//		$this->maxheight = 0;
		
		$this->table = BT_PREFIX.'popup';
	}
	
	/**
	* @bref 주어진 날짜에 해당하며 활성화 되어 있는 목록 리소스 리턴
	* @param string $today
	* @return resource
	**/
	private function getActiveResult($today=''){
		$today = Str::binValue($today, date("Y-m-d H:i:s"));
		$sql = "SELECT * FROM bt_popup WHERE bp_hide<>1
			AND bp_sdate <= '".$today."' AND bp_edate >= '".$today."'
			ORDER BY bp_idx DESC";
		return $this->db->query($sql);
	}

	/**
	* @bref 팝업출력
	* @param
	* @param
	* @return
	**/
	function showPopup($skin_dir){
		
		if(G5_IS_MOBILE) {
			$skin_path = BT_MSKIN_PATH.'/popup/'.$skin_dir;
			$skin_url  = BT_MSKIN_URL.'/popup/'.$skin_dir;
		} else {
			$skin_path = BT_SKIN_PATH.'/popup/'.$skin_dir;
			$skin_url  = BT_SKIN_URL.'/popup/'.$skin_dir;
		}
		
		$result = $this->getActiveResult();
		
		ob_start();
		
//		$left = $this->left;
//		$top = $this->top;
//		$maxheight = $this->maxheight;
		
		for($i=0;$i<$row = $this->db->fetch($result);$i++){
			
			//쿠키가 있으면 건너뛰기
			if(Str::isValue(get_cookie("popup_".$row["bp_idx"]))) continue;
			
			//이미지팝업일 경우
			if($row['bp_type']=='image'){
				//이미지태그만들기
				$content = '<img src="'.G5_DATA_URL.'/file/popup/'.$row['bp_file'].'" 
						width="'.$row['bp_width'].'" height="'.$row['bp_height'].'" 
						alt="'.$row['bp_subject'].'" title="'.$row['bp_subject'].'">';
				// a 태그로 감싸기
				if(Str::isValue($row['bp_url'])){
					$content = '<a href="'.$row['bp_url'].'" target="'.$row['bp_target'].'" title="'.$row['bp_subject'].'">'.$content.'</a>';
				}
			//html 팝업일 경우
			}else{
				$content = $row['bp_content'];
			}
			
			//스킨에서 사용할 값들
			$id = 'popup_'.$row['bp_idx'];					// 각 팝업 div 아이디
			$cookie_name = md5('popup_'.$row["bp_idx"]);	// 쿠키이름
			$cookie_value = base64_encode('true');			// 쿠키값
			$close_hour = self::getHourToDay($row['bp_close_hour']);
			
			//스킨 로드
			include($skin_path.'/popup.skin.php');

			/*
			if(($left + (int)$row["bp_width"]) > 1000){
				$left = $this->left;
				$top += (100 * $i);
			}else{
				$left += ($row["bp_width"] + 5);
			}
			*/
		}
				
	    $content = ob_get_contents();
	    ob_end_clean();
	    
	    //각 팝업창들을 컨테이너 하나로 감싸준다.
	    //absolute 처리하여 위치를 조정할 수 있게...
	    $content = '<div id="popup_container">'.$content.'</div>';

	    return $content;
	}

	/**
	* @bref 시간을 날짜수로
	* @param int $hour
	* @return int
	**/
	public static function getHourToDay($hour){
		$str = '';
		$day = (int)((int)$hour / 24);
		if($day > 0) $str = $day.'일';
		else $str = ((int)$hour % 24).'시간';
		return $str;
	}
}