<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

// 태그 클라우드 관련함수 - 지블로그(gblog)에서 차용
function amina_tag_cloud($flag, $tag_gap='1', $len=0) {
    global $g5, $amina;

    $tag_max = 5; // 태그 단계

    if ($flag=='popular') $flag = 1;
    if ($flag=='time'   ) $flag = 2;

    if ($flag==1)
        $orderby = 't.cnt desc';
    else
        $orderby = 'l.regdate desc';

    $tags = array();
    $index = 0;
    $sql = "select t.tag, t.cnt, l.regdate
            from {$g5['amina_taglog']} l, {$g5['amina_tag']} t
            where l.tag_id = t.id
            group by l.tag_id
            order by $orderby ";
    if ($len) $sql .= " limit {$len}";
    $result = sql_query($sql);

    while( $res = sql_fetch_array($result))  {
        $tags[$index] = $res;
        $tags[$index]['url'] = G5_BBS_URL.'/board.php?bo_table='.$amina['tag_board'].'&sca='.urlencode($res['tag']);
        $index++;
    }

    usort($tags,'amina_tag_sort_make_rank');

    for($i=0, $max=count($tags); $i<$max; $i++) {
        $p = $tags[$i-1]['rank'];
        $s = $tags[$i-1]['cnt'] - $tag_gap;
        $l = $tags[$i-1]['cnt'] + $tag_gap;
        $n = $tags[$i]['cnt'];

        if (!$i) {
            $r = 1;
        } elseif ($p == $tag_max) {
            $r = $tag_max;
        } elseif ($s <= $n && $n <= $l) {
            $r = $p;
        } elseif ($p < $n) {
            $r = $p + 1;
        }
        $tags[$i]['rank'] = $r;
    }

    switch($flag) {
        case '2':
            // 시간순
            usort($tags,'amina_tag_sort_time');
            break;
        default:
            // 인기순
            usort($tags,'amina_tag_sort_rank');
            break;
    }

    return $tags;
}

function amina_tag_sort_make_rank($tag_current, $tag_next) {
    return strtotime($tag_current['cnt'])-strtotime($tag_next['cnt']);
}

function amina_tag_sort_rank($tag_current, $tag_next) {
    return strtotime($tag_next['rank'])-strtotime($tag_current['rank']);
}

function amina_tag_sort_time($tag_current, $tag_next) {
    return strtotime($tag_next['regdate'])-strtotime($tag_current['regdate']);
}

// 태그 등록순으로 구하기
$cloud = amina_tag_cloud('popular');

?>

<style>
	.tag-notice input { display:inline !important; vertical-align:middle; }
	.tag-notice { padding:8px; border-bottom:1px solid #eee; background:#fafafa; }
	.tag-notice-cmt { font:normal 10px verdana; color:#EE5A00; letter-spacing:-1px; }

	#amina_tags { border-bottom:1px solid #ddd; padding:25px; line-height:25px; text-align:center;}
	#amina_tags .tag-cloud { display:inline-block; list-style:none; text-align:justify; line-height:1.6; letter-spacing:-1px; padding:0px; margin:6px; }
	#amina_tags .tag-cloud1 { font:normal 12px dotum; color:#333333; }
	#amina_tags .tag-cloud2 { font:bold 12px dotum; color:#333333; }
	#amina_tags .tag-cloud3 { font:bold 14px dotum; color:#00AADB; }
	#amina_tags .tag-cloud4 { font:bold 16px dotum; color:green; }
	#amina_tags .tag-cloud5 { font:bold 18px dotum; color:crimson; }
</style>

<div class="head-list-back"><div class="head-list-front"><div class="list-view"></div></div></div>

<?php for ($i=0; $i<count($list); $i++) { 

	//첫페이지만 공지사항 나오도록
	if($list[$i]['is_notice'] && $page > 1) continue;

	//링크 재설정
	$list[$i]['href'] = $list[$i]['href'].$frame_opt;

	if($list[$i]['is_notice']) {
?>
	<div class="tag-notice">
		<?php if ($is_checkbox) echo '<input type="checkbox" name="chk_wr_id[]" value="'.$list[$i]['wr_id'].'">'."\n"; ?>
		<a href="<?php echo $list[$i]['href']; ?>">
			<strong>[공지] <?php echo $list[$i]['subject']; ?>
			<?php if ($list[$i]['comment_cnt']) echo '<span class="tag-notice-cmt">'.$list[$i]['comment_cnt'].'</span>'; ?>
			</strong>
		</a>
	</div>
<? } } ?>

<div id="amina_tags">
<?php for($i=0; $i<count($cloud); $i++) { ?>
	<a href="<?php echo $cloud[$i]['url']; ?>"><span class="tag-cloud tag-cloud<?php echo $cloud[$i]['rank']; ?>"><?php echo $cloud[$i]['tag']; ?></span></a>
<?php } ?>
</div>

<script>
	if(document.getElementById('post_cnt')) {
		document.getElementById('post_cnt').innerHTML = "전체 태그 <span class=cnt><?php echo number_format($total_count); ?></span> 개";
	}
</script>

<?php $total_count = 0; //페이징 숨기기 위해서 ?>