<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//-------------------------------------------------------------------------------------
// Load AMINA SKIN Revolution - Copyright (c) 2012 AMINA - http://amina.co.kr
//-------------------------------------------------------------------------------------

//AMINA Skin Version
define('AMINA_VERSION', 'R-beta13');

// Load AMINA SKIN Setting
$xp = array();
$amina = array();
$aminaRe = array();
$aminaThema = array();

//GNU Version
if(defined('G5_PATH')) {
	define('AMINA', 'g5');
} else if(defined('G4_PATH')) {
	define('AMINA', 'g4s');
	include_once(G4_PATH.'/amina/define_g4s.php');
} else {
	define('AMINA', '');
	include_once($g4['path'].'/amina/define_g4.php');
}

//AMINA DB Table
$g5['amina'] = G5_TABLE_PREFIX.'amina';
$g5['amina_skin'] = G5_TABLE_PREFIX.'amina_skin';
$g5['amina_star'] = G5_TABLE_PREFIX.'amina_star';
$g5['amina_blind'] = G5_TABLE_PREFIX.'amina_blind';
$g5['amina_point'] = G5_TABLE_PREFIX.'amina_point';
$g5['amina_cache'] = G5_TABLE_PREFIX.'amina_cache';
$g5['amina_tag'] = G5_TABLE_PREFIX.'amina_tag';
$g5['amina_taglog'] = G5_TABLE_PREFIX.'amina_taglog';
$g5['amina_poll'] = G5_TABLE_PREFIX.'amina_poll';
$g5['amina_polllog'] = G5_TABLE_PREFIX.'amina_polllog';
$g5['amina_file'] = G5_TABLE_PREFIX.'amina_file';
$g5['amina_mileage'] = G5_TABLE_PREFIX.'amina_mileage';
$g5['amina_response'] = G5_TABLE_PREFIX.'amina_response';

//AMINA Path & URL
define('AMINA_PATH', G5_PATH.'/amina');

$xp['xp_mb_list'] = $config['cf_2'];
$xp['xp_no_admin'] = $config['cf_1_subj'];

//Load AMINA Common Function
include_once(AMINA_PATH.'/lib/common.lib.php');

//B4 Thumbnail
include_once(AMINA_PATH.'/lib/thumb.lib.php');

define('AMINA_URL', amina_https('amina', false));
define('AMINA_HTTPS_URL', amina_https('amina', true));

if(!defined('G5_HTTPS_BBS_URL')) {
	define('G5_HTTP_BBS_URL',  amina_https(G5_BBS_DIR, false));
	define('G5_HTTPS_BBS_URL', amina_https(G5_BBS_DIR, true));
}

$chk_host = G5_DOMAIN ? parse_url(G5_DOMAIN) : parse_url(G5_URL);
if($chk_host['host']) {
	define('AMINA_HOST', $chk_host['host']);
} else {
	define('AMINA_HOST', $_SERVER['HTTP_HOST']);
}

//AMINA SKIN & Thema Basic Setting Load
include_once(G5_PATH.'/amina.skin.php');

if(!AMINA) { //G4 Mobile
	define('G5_USE_MOBILE', $amina['g4_mobile']);
	$is_mobile = false;
	if(G5_USE_MOBILE) {
		if($group['gr_10'] == 'pc' || $board['bo_10'] == 'pc') {
			;
		} else if($group['gr_10'] == 'mobile' || $board['bo_10'] == 'mobile') {
			$is_mobile = true;
		} else {
			if ($_REQUEST['device']=='pc') {
			    $is_mobile = false;
			} else if ($_REQUEST['device']=='mobile') {
			    $is_mobile = true;
			} else if (isset($_SESSION['ss_is_mobile'])) {
			    $is_mobile = $_SESSION['ss_is_mobile'];
			} else if (amina_mobile()) {
			    $is_mobile = true;
			}
		}
		$_SESSION['ss_is_mobile'] = $is_mobile;
	}

	define('G5_IS_MOBILE', $is_mobile);

	if (G5_IS_MOBILE) {
		define('G5_MOBILE_DIR', '');
		define('G5_MOBILE_URL', G5_URL);
		define('G5_MOBILE_PATH', G5_PATH);

		if($board['bo_skin'] != 'amina' && $board['bo_10_subj'] == "amina") {
			$board['bo_skin'] = 'amina';
			$board_skin_path = G5_SKIN_PATH.'/board/'.$board['bo_skin'];
			$board_skin_url = G5_SKIN_URL.'/board/'.$board['bo_skin'];
		}
	} 
	
	//API Key
	$config['cf_googl_shorturl_apikey'] = $amina['googl_key'];
	$config['cf_facebook_appid'] = $amina['facebook_appid'];
	$config['cf_facebook_secret'] = $amina['facebook_secret'];
	$config['cf_twitter_key'] = $amina['twitter_key'];
	$config['cf_twitter_secret'] = $amina['twitter_secret'];
}

//Googl Shorturl apikey
$amina['googl_key'] = $config['cf_googl_shorturl_apikey'] ? $config['cf_googl_shorturl_apikey'] : $amina['googl_key'];

// Group Thema
if($group['gr_3_subj']) list($at_pc, $at_m) = explode("|", $group['gr_3_subj']);
if($group['gr_4_subj']) list($ac_pc, $ac_m) = explode("|", $group['gr_4_subj']);

if(G5_IS_MOBILE) {
	$m_thema = $at_m ? $at_m : $m_thema;
	$colorset = ($ac_m && !$colorset) ? $ac_m : $colorset;
} else {
	$thema = $at_pc ? $at_pc : $thema;
	$colorset = ($ac_pc && !$colorset) ? $ac_pc : $colorset;
}

// Preview Thema
if($pv_thema) {
	$thema = $m_thema = $pv_thema;
}

//$g4 & $g5 Reset
if(AMINA != 'g5') $g5 = array_merge($g4, $g5);

//Chage XP
if($xp['xp_use']) {
	$member['mb_9'] = (int)$member['mb_9'];
	$member['mb_10'] = (int)$member['mb_10'];
}

//Check AMINA SKIN
$is_amina = (AMINA && G5_IS_MOBILE) ? is_amina($board['bo_mobile_skin']) : is_amina($board['bo_skin']);
define('IS_AMINA', $is_amina);

//Thema Path & URL
$thema = G5_IS_MOBILE ? $m_thema : $thema;
define('THEMA_PATH', AMINA_PATH.'/thema/'.$thema);
define('THEMA_URL', AMINA_URL.'/thema/'.$thema);
define('AMINA_DIR_PERMISSION',  0707); // 디렉토리 생성시 퍼미션
define('AMINA_FILE_PERMISSION', 0606); // 파일 생성시 퍼미션

//Misc Define
define('AMINA_VIDEO', '(youtu\.be|www\.youtube\.com|vimeo\.com|tvpot\.daum\.net|www\.ted\.com|channel\.pandora\.tv|pann\.nate\.com|www\.tagstory\.com|www\.dailymotion\.com|\.naver\.com|\.naver\.tvcast\.short|www\.facebook\.com|www\.slideshare\.net)');

//FancyBox Size
define('FBOX_WIDTH', $fwidth);

//iFrame
define('IS_FRAME', $frame);

//Load AMINA SETTING
if(IS_AMINA) {
	$amina = load_amina_setting($amina, $bo_table, $board['bo_skin'], $board['bo_mobile_skin'], $sca);

	if(!$amina['btn_skin']) {
		$amina['btn_skin'] = 'basic'; 
		$amina['btn_css'] = 'basic'; 
	}
	if(!$amina['head_skin']) {
		$amina['head_skin'] = 'basic';
		$amina['head_css'] = 'basic';
	}

	//Use SNS
	$board['bo_use_sns'] = AMINA ? $board['bo_use_sns'] : $amina['auto_sns'];

	//Link Option
	$frame_opt = '';
	if($frame) {
		$frame_opt .= '&frame='.$frame;
		$qstr .= '&frame='.$frame;
	}

	if($bo_it) {
		$frame_opt .= '&bo_it='.$bo_it;
		$qstr .= '&bo_it='.$bo_it;
	}

	if($bo_linked) {
		$frame_opt .= '&bo_linked='.$bo_linked;
		$qstr .= '&bo_linked='.$bo_linked;
	}

	if($bo_row) {
		$frame_opt .= '&bo_row='.$bo_row;
		$qstr .= '&bo_row='.$bo_row;
	}

	if($bo_all) {
		$frame_opt .= '&bo_all='.$bo_all;
		$qstr .= '&bo_all='.$bo_all;
	}

	if($bm) { //게시판 모드
		$frame_opt .= '&bm='.$bm;
		$qstr .= '&bm='.$bm;
	}

	//AMINA Skin Path & URL
	$emo_skin_path = AMINA_PATH.'/skin/emo/'.$amina['emo_skin'];
	$emo_skin_url = AMINA_URL.'/skin/emo/'.$amina['emo_skin'];
	$cmt_skin_path = AMINA_PATH.'/skin/cmt/'.$amina['cmt_skin'];
	$cmt_skin_url = AMINA_URL.'/skin/cmt/'.$amina['cmt_skin'];
	$view_skin_path = AMINA_PATH.'/skin/view/'.$amina['view_skin'];
	$view_skin_url = AMINA_URL.'/skin/view/'.$amina['view_skin'];
	$write_skin_path = AMINA_PATH.'/skin/write/'.$amina['write_skin'];
	$write_skin_url = AMINA_URL.'/skin/write/'.$amina['write_skin'];
	$btn_skin_path = AMINA_PATH.'/skin/btn/'.$amina['btn_skin'];
	$btn_skin_url = AMINA_URL.'/skin/btn/'.$amina['btn_skin'];
	$head_skin_path = AMINA_PATH.'/skin/head/'.$amina['head_skin'];
	$head_skin_url = AMINA_URL.'/skin/head/'.$amina['head_skin'];

	//대표아이디
	$is_rid = $is_admin ? chk_multiple_admin($member['mb_id'], $config['cf_1']) : false;
}

//Title & Desc
$aminaThema['title'] = $aminaThema['title'] ? amina_fa($aminaThema['title']) : '';
$aminaThema['desc'] = $aminaThema['desc'] ? amina_fa($aminaThema['desc']) : '';

//SideView
$is_sideview = (AMINA && (!$bo_table || ($bo_table && $board['bo_use_sideview'])) && !G5_IS_MOBILE) ? true : false;

//AMINA Ajax
$g5['amina_ajax'] = false;

//크로스도메인 관련 jQuery 오류 해결..
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Max-Age: 1000');
if(array_key_exists('HTTP_ACCESS_CONTROL_REQUEST_HEADERS', $_SERVER)) {
    header('Access-Control-Allow-Headers: '
           . $_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']);
} else {
    header('Access-Control-Allow-Headers: *');
}
 
if("OPTIonS" == $_SERVER['REQUEST_METHOD']) {
    exit(0);
}

//CSS Buffer
if(!AMINA) {
	if($aminaThema['css_buffer']) {
		define('CSS_BUFFER', true);
		ob_start();
	}
} else {
	define('CSS_BUFFER', false);
}

?>