<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가
?>

<link rel="stylesheet" href="<?php echo $member_skin_url; ?>/memo.css">

<section id="at-memo">

	<div class="memo-tab">
		<ul>
			<li<?php echo ($kind == 'recv') ? ' class="on"' : ''; ?>><a href="./memo.php?kind=recv"><i class="fa fa-envelope"></i> 받은쪽지</a></li>
			<li<?php echo ($kind == 'send') ? ' class="on"' : ''; ?>><a href="./memo.php?kind=send"><i class="fa fa-envelope-o"></i> 보낸쪽지</a></li>
			<li<?php echo (!$kind) ? ' class="on"' : ''; ?>><a href="./memo_form.php"><i class="fa fa-pencil"></i> 쪽지쓰기</a></li>
		</ul>
		<div class="clear"></div>
	</div>
	<div class="clear"></div>

<?php if($action == "form") { ?>

	<div class="msg-box box-black" style="font-weight:normal;">
		<i class="fa fa-chevron-circle-right"></i> 여러 회원에게 보낼때는 회원아이디를 컴마(,)로 구분하세요.
	</div>

    <form name="fmemoform" action="./memo_form_update.php" onsubmit="return fmemoform_submit(this);" method="post" autocomplete="off" data-ajax="false">
	<table class="memo-form">
	<tr>
	<th scope="row">
		<i class="fa fa-user"></i> 받는 회원아이디<strong class="sound_only">필수</strong>
	</th>
	<td>
		<input type="text" name="me_recv_mb_id" value="<?php echo $me_recv_mb_id ?>" id="me_recv_mb_id" required style="width:98%">
	</td>
	</tr>
	<tr>
	<th scope="row">
		<i class="fa fa-comment"></i> 보낼 쪽지내용<strong class="sound_only">필수</strong>
	</th>
	<td>
		<textarea name="me_memo" id="me_memo" rows=10 required style="width:98%"><?php echo $content ?></textarea>
	</td>
	</tr>
	<tr>
    <th scope="row">
		<i class="fa fa-lock"></i> 자동등록방지
	</th>
    <td><?php echo $captcha_html ?></td>
	</tr>
    </table>

	<p align="center">
		<button type="submit" id="btn_submit"><i class="fa fa-check-circle fa-lg"></i> <b>보내기</b></button>
	</p>

    </form>

	<script>
		function fmemoform_submit(f) {
		    <?php echo $captcha_js; ?>
		    return true;
		}
	</script>

<?php } else if($action == "view") { ?>


	<div class="msg-box box-black" style="font-weight:normal;">
		<i class="fa fa-user"></i> <?php echo $kind_str ?>사람 : <b class="view-name"><?php echo $nick ?></b>
		&nbsp; &nbsp;
		<i class="fa fa-clock-o"></i> <?php echo $kind_date ?>시간 : <b><?php echo $memo['me_send_datetime'] ?></b>
	</div>

	<div class="box-view">
            <?php echo conv_content($memo['me_memo'], 0) ?>
	</div>

	<p align="center">
		<span class="btn-ok">
	        <?php if($prev_link) { ?>
		        <a href="<?php echo $prev_link ?>"><i class="fa fa-chevron-circle-left"></i> 이전</a>
			<?php } ?>
		    <?php if($next_link) { ?>
			    <a href="<?php echo $next_link ?>"><i class="fa fa-chevron-circle-right"></i> 다음</a>
			<?php } ?>
	        <?php if ($kind == 'recv') { ?>
				<a href="./memo_form.php?me_recv_mb_id=<?php echo $mb['mb_id'] ?>&me_id=<?php echo $memo['me_id'] ?>"><i class="fa fa-repeat"></i> 답장</a>
			<?php } ?>
			<a href="./memo.php?kind=<?php echo $kind ?>"><i class="fa fa-minus-circle"></i> 목록</a>
		</span>
	</p>

<?php } else if($action == "list") { ?>

	<div class="msg-box box-black">
		<i class="fa fa-envelope<?php echo ($kind == "recv") ? '' : '-o'; ?>"></i> 전체 <?php echo $kind_title ?>쪽지 <?php echo $total_count ?>통 - 쪽지 보관일수는 최장 <strong><?php echo $config['cf_memo_del'] ?></strong>일
	</div>
	<table class="memo-list">
    <thead>
	<tr>
        <th scope="col"><i class="fa fa-user"></i> <?php echo  ($kind == "recv") ? "보낸사람" : "받는사람"; ?></th>
	    <th scope="col"><i class="fa fa-clock-o"></i> 보낸시간</th>
        <th scope="col"><i class="fa fa-eye"></i> 읽은시간</th>
	    <th scope="col"><i class="fa fa-times-circle"></i> 관리</th>
    </tr>
	</thead>
    <tbody>
	<?php for ($i=0; $i<count($list); $i++) { ?>
	    <tr>
	    <td><?php echo $list[$i]['name'] ?></td>
	    <td><a href="<?php echo $list[$i]['view_href']; ?>"><?php echo $list[$i]['send_datetime'] ?></a></td>
	    <td><a href="<?php echo $list[$i]['view_href']; ?>"><?php echo $list[$i]['read_datetime'] ?></a></td>
		<td><a href="<?php echo $list[$i]['del_href']; ?>" onclick="del(this.href); return false;"><i class="fa fa-times-circle"></i> 삭제</a></td>
		</tr>
    <?php } ?>
	<?php if ($i==0) { echo '<tr><td colspan="4" class="no-data">자료가 없습니다.</td></tr>'."\n"; } ?>
    </tbody>
	</table>
	<p align="center">
		 <span class="btn-ok"><a href="javascript:window.close();"><i class="fa fa-times-circle fa-lg"></i> 창닫기</a></span>
	</p>

<?php } ?>

</section>