<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

function amina_seo_keyword($bo_table, $wr_id, $ca_name) {

	include_once(AMINA_PATH.'/lib/tag.lib.php');

	$keywords = amina_get_tag($bo_table, $wr_id);
	$keywords = $keywords ? $keywords : $ca_name;

	return $keywords;
}

//글내용일 때만 출력하기
if(IS_AMINA && $bo_table && $wr_id && (basename($_SERVER['PHP_SELF']) == 'board.php')) {
	$seo_desc = $write['wr_3'] ? $write['wr_3'] : $group['gr_subject'].' - '.$board['bo_subject'].' - '.$write['wr_subject'];
?>
	<meta name="subject" content="<?php echo htmlspecialchars($write['wr_subject']);?>" />
	<meta name="title" content="<?php echo htmlspecialchars($write['wr_subject']);?>" />
	<meta name="publisher" content="<?php echo htmlspecialchars($_SERVER['SERVER_NAME']);?>" />
	<meta name="keywords" content="<?php echo htmlspecialchars(amina_text(amina_seo_keyword($bo_table, $wr_id, $write['ca_name'])));?>" />
	<meta name="description" content="<?php echo htmlspecialchars(amina_text($seo_desc));?>" />
	<meta name="robots" content="index,follow" />
	<?php if(!AMINA) { ?>
		<link rel="canonical" href="<?php echo G5_BBS_URL;?>/board.php?bo_table=<?php echo $bo_table; ?>&wr_id=<?php echo $wr_id; ?>" />
	<?php } ?>
	<title><?php echo htmlspecialchars(conv_subject(strip_tags($write['wr_subject']), 64) . ' < '. $board['bo_subject'] . ' < ' . $group['gr_subject']);?></title>
<?php 
} else { 
	if(AMINA) {
		$no_seo_title = $g5_head_title;
	} else {
		$no_seo_title = $g4['title'] ? $g4['title'] :$g5['title'];
	}
?>
	<title><?php echo $no_seo_title; ?></title>
<?php } ?>