<?php
$sub_menu = '350892';
include_once('./_common.php');

auth_check($auth[$sub_menu], "r");

$g5['title'] = _t('라이센스 확인');
include_once (G5_ADMIN_PATH.'/admin.head.php');

$key = @file_get_contents($g5['locale_path'].'/include/.license_key.pem');
$message = @file_get_contents($g5['locale_path'].'/include/.license_message');

if(!$key || !$message) {
    $result = '<font color=red>No License Key.</font><br>';
    $license_message = '<b>'._t('라이센스 키와 메시지가 존재하지 않습니다.').'</b>'; 
    $license_message .= '<br>==> <b><font color=red>'._t('라이센스 키와 메시지를 구입하여 설치해 주십시요.').'</font></b>'; 
} else if(openssl_private_decrypt(base64_decode($message), $domain, $key)) {
    $result = '<font color=blue>Decription Success!</font><br>';
    $license_message = '<b>'._t('이 ML PRO 서비스 팩은 다음 도메인에 허가되었습니다.').'</b>'; 
    $license_message .= '<br>==> <b><font color=blue>'.strtoupper($domain).'</font></b>'; 
} else {
    $result = '<font color=red>Decription Fail!</font><br>';
    $result .= openssl_error_string().'<br>';
    $license_message = '<b>'._t('라이센스 메시지를 해석할 수 없습니다.').'</b>'; 
    $license_message .= '<br>==> <b><font color=red>'._t('굿빌더에 문의해 주십시요.').'</font></b>'; 
}
?>

<section id ="anc_scf_license">
    <h2 class="h2_frm"><?php echo _t('라이센스 정보'); ?></h2>

    <div class="tbl_frm01 tbl_wrap">
        <table>
        <caption><?php echo _t('라이센스 정보'); ?></caption>
        <colgroup>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
        <tr>
            <th scope="row"><label for="de_license_info"><?php echo _t('라이센스 정보') ;?></label></th>
            <td>
                <b><?php echo _t('라이센스 키'); ?></b>
                <br>
                <textarea style="width:100%;min-height:200px;margin-top:5px"><?php echo $key; ?></textarea>
                <br>
                <b><?php echo _t('라이센스 메시지'); ?></b>
                <br>
                <textarea style="width:100%;margin-top:5px"><?php echo $message; ?></textarea>
                <br>
                <br>
                <?php echo $license_message; ?>
            </td>
        </tr>
        </tbody>
        </table>
    </div>
</section>

<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');
?>
