<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

//-------------------------------------------------------------------------------------
// AMINA Skin Lib for AMINA BBS & THEMA - Copyright (c) 2012 AMINA - http://amina.co.kr
//
// only for AMINA Write Skin
//-------------------------------------------------------------------------------------

// Check Keys
function amina_chk_keys($keys, $field) {

	if(!$keys || !$filed) return;

	$row = array_keys($keys);

	$row_cnt = count($row);

	for($i=0; $i < $row_cnt; $i++){ 
		if($row[$i] == $field) return $field;
	}

	return;
}

//GPS 정보 사용
function amina_photo_GPS() {

	$return = function_exists('exif_read_data') ? true : false;

	return $return;
}

//태그 사용권한 설정
function amina_tag_auth() {
	global $member, $amina, $is_admin;

	$is_tag = false;
	if($is_admin || ($amina['tag'] && $member['mb_level'] >= $amina['tag'])) {
		$is_tag = true;
	} else {
		if($member['mb_id'] && $amina['tag_mb']) {
			$tag_mb = array();
			$tag_mb = explode(",", $amina['tag_mb']);
			if(in_array($member['mb_id'], $tag_mb)) $is_tag = true;
		}
	}

    return $is_tag;
}

//분류 자동 선택
function amina_category($ca_name, $ca_list) {

    $arr = explode("|", $ca_list); // 구분자가 , 로 되어 있음
    $str = '';
    for ($i=0; $i<count($arr); $i++) {
        if (trim($arr[$i])) {
			if(trim($arr[$i]) == $ca_name) { $selected = 'selected'; } else { $selected = ''; }
			$str .= "<option value='$arr[$i]' $selected >$arr[$i]</option>\n";
		}
	}
    return $str;
}

//익명글
function amina_nameless_tail($num) {

	if($num > 0) {
		$temp = str_split('abcdefghijklmnopqrstuvwxyz012345678901234567890123456789'); 
		shuffle($temp); 
		$id = implode('',array_slice($temp,0,$num));
	} else {
		$id = '';
	}

	return $id;
} 

//동영상 이미지 등록 - 모바일 때문에 글등록시 동영상 이미지 미리 불러오기
function amina_video_all($wr_6, $wr_content) {

	include_once(AMINA_PATH.'/lib/video.lib.php');

	$img = array();
	$info = array();
	$video = array();

	//직접링크 동영상
	if($wr_6) {
		$info = amina_array_video($wr_6);
		if($info['movie_url'] && $info['movie_sound'] != "soundcloud") {
			$video = amina_video_info($info['movie_info']);
			$video_img = amina_video_img($video['video_url'], $video['vid'], $video['type'], 'write', $video['img']);
			if($video_img) $img[] = $video_img;
		}
	}

	//본문첨부 동영상
	if(preg_match_all("/{동영상\:([^}]*)}/ie", $wr_content, $match)) {
		for ($i=0; $i<count($match[1]); $i++) {
			if(preg_match('/'.AMINA_VIDEO.'/i', $match[1][$i])) {
				list($url) = explode("|", trim(strip_tags($match[1][$i])));
				$video = amina_video_info($url);
				$video_img = amina_video_img($video['video_url'], $video['vid'], $video['type'], 'write', $video['img']);
				if($video_img) $img[] = $video_img;
			}
		}
	}

	return $img;
}

function amina_photo_rotate($bo_table, $wr_id, $bf_no, $source_img, $type='') {
    global $g5;

	//디카 또는 스마트폰 사진 확장자는 대다수 jpg 파일이므로 jpg 파일만 체크
	if(!$type) {
		$size = @getimagesize($source_img);
		$type = $size[2];
	}

	if($type != "2") return false;

	/*
    switch ($type) {
        //case 1: $source = @imagecreatefromgif($source_img); break;
        case 2: $source = @imagecreatefromjpeg($source_img); break;
        //case 3: $source = @imagecreatefrompng($source_img); break;
        default: return false;
    }
	*/

    $exif = @exif_read_data($source_img);

	//회전 정보가 있을 때만 실행	
	if($exif['Orientation'] == "8" || $exif['Orientation'] == "3" || $exif['Orientation'] == "6") {
		$source = @imagecreatefromjpeg($source_img);
	} else {
		return false;
	}

    switch ($exif['Orientation']) {
        case 8: $source = imagerotate($source, 90, 0); break;
        case 3: $source = imagerotate($source, 180, 0); break;
        case 6: $source = imagerotate($source, -90, 0); break;
    }

    @imagejpeg($source, $source_img, 100);
    @chmod($source_img, AMINA_FILE_PERMISSION);
    @imagedestroy($source);

	//DB의 파일정보 업데이트
	$size = @getimagesize($source_img);
	$filesize = @filesize($source_img);

	sql_query(" update {$g5['board_file_table']} set bf_filesize = '{$filesize}', bf_width = '{$size[0]}', bf_height = '{$size[1]}', bf_type = '{$size[2]}' where bo_table = '$bo_table' and wr_id = '$wr_id' and bf_no = '$bf_no' ");
}

?>