<?php
include_once('./_common.php');
include_once(AMINA_PATH.'/lib/view.lib.php');
include_once(AMINA_PATH.'/lib/tag.lib.php');

//RSS Setting
$rss_rows = 10; //뽑아올 글 수

$yoil = array("Sun","Mon","Tue","Wed","Thu","Fri","Sat");

// 비회원 읽기가 가능한 게시판만 RSS 지원
if ($board['bo_read_level'] >= 2) {
    echo "비회원 읽기가 가능한 게시판만 RSS 지원합니다.";
    exit;
}

// RSS 사용 체크
if (!$board['bo_use_rss_view']) {
    echo "RSS 보기가 금지되어 있습니다.";
    exit;
}

Header("Content-type: text/xml; charset=utf-8"); 
header("Cache-Control: no-cache, must-revalidate"); 
header("Pragma: no-cache");   

echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";

?>
<rss version="2.0">
<channel>
<title><?php echo specialchars_replace("{$config['cf_title']} > {$board['bo_subject']}"); ?></title>
<link><?php echo specialchars_replace(G5_BBS_URL.'/board.php?bo_table='.$bo_table); ?></link>
<description><?php echo specialchars_replace("{$config['cf_title']} 사이트의 {$board['bo_subject']} 게시판입니다."); ?></description>
<language>ko</language>
<pubDate><?php echo $yoil[date('w', G5_SERVER_TIME)];?>, <?php echo date('d M Y H:i:s', G5_SERVER_TIME); ?> +0900</pubDate>
<generator>AMINA SKIN for GNUBOARD</generator>
<?php
$sql = " select * from {$g5['write_prefix']}{$bo_table} where wr_is_comment = 0 and wr_option not like '%secret%' order by wr_num, wr_reply limit 0, $rss_rows ";
$result = sql_query($sql);
for ($i=0; $row=sql_fetch_array($result); $i++) {

	//링크설정
	$link = G5_BBS_URL.'/board.php?bo_table='.$bo_table.'&wr_id='.$row['wr_id']; //짧은 주소

	$row['file'] = get_file($bo_table, $row['wr_id']);
	$row['tag'] = amina_get_tag($bo_table, $row['wr_id']);

	list($wr_img) = amina_thumb_img($row1['file'], $row1['wr_6'], $row1['wr_content'], 1, $row1['wr_4'], $row1['wr_8'], '');
	if($wr_img) {
		$wr_img = str_replace("../data", G5_DATA_URL, $wr_img);
		$wr_img = '<p><img src="'.$wr_img.'" border=0></p>';
	}

	$wr_icon = amina_array_icon($row['wr_5']);
	$wr_content = ($wr_icon['po_view_point'] > 0 && $row['wr_3']) ? amina_text($row['wr_3']) : amina_cut($row['wr_content'], 250);
?>
	<item>
	<title><?php echo specialchars_replace($row['wr_subject']);?></title>
	<link><?php echo specialchars_replace($link);?></link>
	<description><?php echo specialchars_replace($wr_img.$wr_content);?></description>
	<?php if($row['tag']) { ?>
		<tag><![CDATA[<?php echo specialchars_replace($row['tag']);?>]]></tag>
	<?php } ?>
	<category><?php echo specialchars_replace($row['ca_name']); ?></category>
	<author><?php echo specialchars_replace($row['wr_name']);?></author>
	<guid><?php echo specialchars_replace($link);?></guid>
	<pubDate><?php echo $yoil[date('w', strtotime($row['wr_datetime']))];?>, <?php echo date('d M Y H:i:s', strtotime($row['wr_datetime']));?> +0900</pubDate>
	<comment><?php echo specialchars_replace($row['wr_comment']); ?></comment>
	<hit><?php echo specialchars_replace($row['wr_hit']); ?></hit>
	<good><?php echo specialchars_replace($row['wr_good']); ?></good>
	</item>
<? } ?>
</channel>
</rss>
