<?php
$sub_menu = '200300';
include_once('./_common.php');

auth_check($auth[$sub_menu], 'r');

$sql_common = " from {$g5['mail_table']} ";

// 테이블의 전체 레코드수만 얻음
$sql = " select COUNT(*) as cnt {$sql_common} ";
$row = sql_fetch($sql);
$total_count = $row['cnt'];

$page = 1;

$sql = " select * {$sql_common} order by ma_id desc ";
$result = sql_query($sql);

$g5['title'] = _t('회원메일발송');
include_once('./admin.head.php');

$colspan = 7;
?>

<div class="local_desc01 local_desc">
    <p>
        <b><?php echo _t('테스트는 등록된 최고관리자의 이메일로 테스트 메일을 발송합니다.'); ?><br>
        <?php echo _t('현재 등록된 메일은 총'); ?> <?php echo $total_count ?><?php echo _t('건입니다.'); ?><br>
        <strong><?php echo _t('주의').') '._t('수신자가 동의하지 않은 대량 메일 발송에는 적합하지 않습니다.').' '._t('수십건 단위로 발송해 주십시오.'); ?></strong>
    </p>
</div>


<form name="fmaillist" id="fmaillist" action="./mail_delete.php" method="post">
<div class="tbl_head01 tbl_wrap">
    <table>
    <caption><?php echo $g5['title']; ?> <?php echo _t('목록'); ?></caption>
    <thead>
    <tr>
        <th scope="col"><input type="checkbox" name="chkall" value="1" id="chkall" title="<?php echo _t('현재 페이지 목록 전체선택'); ?>" onclick="check_all(this.form)"></th>
        <th scope="col"><?php echo _t('번호'); ?></th>
        <th scope="col"><?php echo _t('제목'); ?></th>
        <th scope="col"><?php echo _t('작성일시'); ?></th>
        <th scope="col"><?php echo _t('테스트'); ?></th>
        <th scope="col"><?php echo _t('보내기'); ?></th>
        <th scope="col"><?php echo _t('미리보기'); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php
    for ($i=0; $row=sql_fetch_array($result); $i++) {
        $s_vie = '<a href="./mail_preview.php?ma_id='.$row['ma_id'].'" target="_blank" class="btn btn_03">'._t('미리보기').'</a>';

        $num = number_format($total_count - ($page - 1) * $config['cf_page_rows'] - $i);

        $bg = 'bg'.($i%2);
    ?>

    <tr class="<?php echo $bg; ?>">
        <td class="td_chk">
            <label for="chk_<?php echo $i; ?>" class="sound_only"><?php echo $row['ma_subject']; ?> <?php echo _t('메일'); ?></label>
            <input type="checkbox" id="chk_<?php echo $i ?>" name="chk[]" value="<?php echo $row['ma_id'] ?>">
        </td>
        <td class="td_num_c"><?php echo $num ?></td>
        <td class="td_left"><a href="./mail_form.php?w=u&amp;ma_id=<?php echo $row['ma_id'] ?>"><?php echo $row['ma_subject'] ?></a></td>
        <td class="td_datetime"><?php echo $row['ma_time'] ?></td>
        <td class="td_test"><a href="./mail_test.php?ma_id=<?php echo $row['ma_id'] ?>"><?php echo _t('테스트'); ?></a></td>
        <td class="td_send"><a href="./mail_select_form.php?ma_id=<?php echo $row['ma_id'] ?>"><?php echo _t('보내기'); ?></a></td>
        <td class="td_mng"><?php echo $s_vie ?></td>
    </tr>

    <?php
    }
    if (!$i)
        echo "<tr><td colspan=\"".$colspan."\" class=\"empty_table\">"._t("자료가 없습니다.")."</td></tr>";
    ?>
    </tbody>
    </table>
</div>
<div class="btn_fixed_top">
    <input type="submit" value="<?php echo _t('선택삭제'); ?>" class="btn btn_02">
    <a href="./mail_form.php" id="mail_add" class="btn btn_01"><?php echo _t('메일내용추가'); ?></a>
</div>
</form>

<script>
$(function() {
    $('#fmaillist').submit(function() {
        if(confirm("<?php echo _t('한번 삭제한 자료는 복구할 방법이 없습니다.').'\n\n'._t('정말 삭제하시겠습니까?'); ?>")) {
            if (!is_checked("chk[]")) {
                alert("<?php echo _t('선택삭제 하실 항목을 하나 이상 선택하세요.'); ?>");
                return false;
            }

            return true;
        } else {
            return false;
        }
    });
});
</script>

<?php
include_once ('./admin.tail.php');
?>
