<?php
$sub_menu = "350207";
include_once('./_common.php');

auth_check($auth[$sub_menu], 'r');

$token = get_token();

if ($is_admin != 'super')
    alert(_t('최고관리자만 접근 가능합니다.'));

$g5['title'] = _t('관리자 언어 설정');
include_once (G5_ADMIN_PATH.'/admin.head.php');

if (!isset($config2w_def['adm_lang'])) {
    sql_query(" ALTER TABLE `{$g5['config2w_def_table']}` 
    ADD `adm_lang` VARCHAR(30) NOT NULL DEFAULT '' AFTER `lang_list` ", false);
}

$frm_submit = '<div class="btn_confirm01 btn_confirm">
    <input type="submit" value="'._t('확인').'" class="btn_submit" accesskey="s">
    <a href="'.G5_URL.'/">'._t('메인으로').'</a>
</div>';

echo '<script src="'.G5_JS_URL.'/trans.js"></script>'.PHP_EOL;
?>

<form name="fconfigform" id="fconfigform" method="post" onsubmit="return fconfigform_submit(this);">
<input type="hidden" name="token" value="<?php echo $token ?>" id="token">

<section id="anc_cf_basic">
    <h2 class="h2_frm"><?php echo _t('관리자 언어 설정'); ?></h2>
    <?php echo $pg_anchor ?>

    <div class="tbl_frm01 tbl_wrap">
        <table>
        <caption><?php echo _t('관리자 언어 설정'); ?></caption>
        <colgroup>
            <col class="grid_4">
            <col>
            <col class="grid_4">
            <col>
        </colgroup>
        <tbody>
        <tr>
            <th scope="row"><label for="adm_lang"><?php echo _t('기본 언어'); ?><strong class="sound_only"><?php echo _t('필수'); ?></strong></label></th>
            <td colspan="3">
            <select name="adm_lang">
            <?php for($i = 0; $i < count($g5['lang_list_all']); $i++) { $lang = $g5['lang_list_all'][$i]; $lang_js = $g5['lang_js_list'][$lang]; ?>
            <?php if(!file_exists($g5['locale_path'].'/lang/'.$lang.'/LC_MESSAGES/messages-adm.inc.php')) continue; ?>
            <option value="<?php echo $lang; ?>"<?php if($lang == $g5['adm_lang']) echo ' selected'; else echo ''; ?>><?php echo $g5['lang_name_list'][$lang]; ?> <?php if($g5['adm_lang'] != 'en_US') echo ' ('.$g5['lang_name_list_en'][$lang].')' ?>
            <?php } ?>
            </select>
            <strong class="sound_only"><?php echo _t('필수'); ?></strong>
            </label>
            </td>
        </tr>
        </tbody>
        </table>
    </div>
</section>

<?php echo $frm_submit; ?>

</form>

<script>
function fconfigform_submit(f)
{
    f.action = "./admin_lang_config_form_update.php";
    return true;
}
</script>

<?php
include_once (G5_ADMIN_PATH.'/admin.tail.php');
?>
