<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2015년 03월 19일 목요일 오후 14시 57분, 날씨 맑음

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 그누보드 기능 추가  G5 > 설정 정보 수정 폼
===========================================================


*/


	#########################################################
	# 시작 => 최_우선__상수__변수
	#########################################################

	//=======================================================
	// 메뉴_번호__지정____그누보드_추가_기능
	$sub_menu = 770019;


	//=======================================================
	// 기본_설정_첨부__여부
	// 0 - 안해
	// 1 - 하자
	$is_get__piree_config = 0;


	//=======================================================
	// 그누보드_추가_기능__설정_정보__가져오기
	$is_get__board_func_info = 1;


	//=======================================================
	// 설정_화면__여부
	$is_piree_program_config = 1;


	//=======================================================
	// 그누보드_추가_기능__첨부
	define('IS_INC__BO_FUNC', '1');

	#########################################################
	# 끝 => 최_우선__상수__변수
	#########################################################



	#########################################################
	# 시작 => 선_처리__메뉴_지정__관리자_확인
	#########################################################

	//=======================================================
	// 기본처리_파일__첨부
	include_once ('./_common.php');


	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
			alert ("회원만 이용하실 수 있습니다", G5_DOMAIN.'/');
			EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================


	//=======================================================
	// 관리자_확인
	auth_check($auth[$sub_menu], 'r');

	#########################################################
	# 끝 => 선_처리__메뉴_지정__관리자_확인
	#########################################################



	#########################################################
	# 시작 => 각__프로그램__상수_변수__기본_값
	#########################################################

	//=======================================================
	// 시작 => 그누보드_추가_기능___사용_안하면
	// 시작 => 스킨__없으면
	IF (!$PCF_BOFUNC_is_use || !$PCF_BOFUNC_skin_pc_c || !$PCF_BOFUNC_skin_mobile_c)
	{

			//===================================================
			// 기본_값__파일__첨부
			include_once ('pi__config.form.inc.php');
		
	}
	// 끝 => 그누보드_추가_기능___사용_안하면
	// 끝 => 스킨__없으면
	//=======================================================

	#########################################################
	# 끝 => 각__프로그램__상수_변수__기본_값
	#########################################################



	#########################################################
	# 시작 => 상수__변수
	#########################################################

	IF (PIREE_BUILDER_OYO_OMO == 'OYO')
	{
			;
	}

	#########################################################
	# 끝 => 상수__변수
	#########################################################



	#########################################################
	# 시작 => 탭__링크
	#########################################################

	//=======================================================
	// 탭__링크
	$tab_anchor  = '<ul class="anchor">';
	$tab_anchor .= '	<li><a href="#tab__skin">스킨</a></li>';
	$tab_anchor .= '	<li><a href="#tab__report">신고하기</a></li>';
	$tab_anchor .= '	<li><a href="#tab__bo_cate">그누보드 카테고리</a></li>';
	$tab_anchor .= '	<li><a href="#tab__uphill">끌어올림</a></li>';
	$tab_anchor .= '	<li><a href="#tab__mini_geul">미니글</a></li>';
	$tab_anchor .= '	<li><a href="#tab__naegeul_chang">내글 창</a></li>';
	$tab_anchor .= '	<li><a href="#tab__ajax_comment">AJAX 댓글</a></li>';
	$tab_anchor .= '	<li><a href="#tab__article_vote">게시글 투표</a></li>';
	$tab_anchor .= '	<li><a href="#tab__etc_conf">기타 설정</a></li>';
	$tab_anchor .= '</ul>';

	#########################################################
	# 끝 => 탭__링크
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// 타이틀
	$g5['title'] = "그누보드 기능 추가  G5";


	//=======================================================
	// HEAD_첨부
	include_once ('../admin.head.php');


	//=======================================================
	// 상단_링크
	include_once ('top_menu.php');

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>

<section>
		<!-- <h2>그누보드 카테고리 정보 수정하기</h2> -->

		<form name="bo_func_config" id="bo_func_config" action="./pi__config.update.php" onsubmit="return submit__config_form(this);" method="post">


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__skin">
    		<h2 class="h2_frm">스킨 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>스킨 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<th scope="row" style="padding:6px;"><label for="skin_pc">PC 스킨<strong class="sound_only">선택입력</strong></label></th>
    						<td colspan="3">
    								<select id="skin_pc" name="skin_pc_c">
<?php

    								//=========================================
    								// PC__스킨_목록__가져오기
    								$skins = get_skin_dir(PIREE_SKIN_PC_DIR, $PCF_BOFUNC_prog_p);


    								//=========================================
    								// 시작 => 돌려라__반복문
    								FOR ($i=0; $i<count($skins); $i++)
    								{
    										// 선택_여부
    										$selected = $PCF_BOFUNC_skin_pc_c == $skins[$i] ? " selected" : "";
?>
    										<option value="<?php echo $skins[$i]; ?>"<?php echo $selected ?>><?php echo $skins[$i]; ?></option>
<?php
    								}
    								// 끝 => 돌려라__반복문
    								//=========================================

?>
    								</select>
    						</td>
    				</tr>

    				<tr>
    						<th scope="row" style="padding:6px;"><label for="skin_mobile">모바일 스킨<strong class="sound_only">선택입력</strong></label></th>
    						<td colspan="3">
    								<select id="skin_mobile" name="skin_mobile_c">
<?php

    								//=========================================
    								// 모바일__스킨_목록__가져오기
    								$skins = get_skin_dir(PIREE_SKIN_MOBILE_DIR, $PCF_BOFUNC_prog_p);


    								//=========================================
    								// 시작 => 돌려라__반복문
    								FOR ($i=0; $i<count($skins); $i++)
    								{
    										// 선택_여부
    										$selected = $PCF_BOFUNC_skin_mobile_c == $skins[$i] ? " selected" : "";
?>
    										<option value="<?php echo $skins[$i]; ?>"<?php echo $selected ?>><?php echo $skins[$i]; ?></option>
<?php
    								}
    								// 끝 => 돌려라__반복문
    								//=========================================

?>
    								</select>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<br />


		<section id="tab__report">
    		<h2 class="h2_frm">신고하기 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>신고하기 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__REPORT"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__REPORT" id="USE__REPORT" value="1"<?php  IF ($PCF_BOFUNC_USE__REPORT == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"신고하기" 를 사용합니다.</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="blind_do_t" class="font_oyoomo">☆ 블라인드 처리할 신고 건수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled >
    								<br />
    								입력한 회수만큼 신고 받으면 ( 게시글, 댓글 )을 블라인트 처리 합니다.
    								<br />
    								미입력시 신고받아도 블라인드 처리하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="report_do_level_n" class="font_oyoomo">☆ 신고 가능한 레벨<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<span class="font_green">모든 회원이 신고 기능을 이용할수 있습니다.</span>
    								<br />
    								<?php echo get_member_level_select__piree('', 1, 1, 1, '', ' disabled') ?>
    								<br />
    								입력하신 레벨 이상 회원은 "신고하기" 할수 있습니다.
    								<br />
    								미입력시 모든 회원이 "신고하기" 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="exemption_level_n" class="font_oyoomo">☆ 신고 면제 할 레벨<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<span class="font_green">모든 회원을 신고할수 있습니다.</span>
    								<br />
    								<?php echo get_member_level_select__piree('', 0, 1, 1, '' ,' disabled') ?>
    								<br />
    								입력하신 레벨 이상인 회원을 대상으로 "신고하기" 할수 없습니다. ( 신고 대상 면제하는 특권 )
    								<br />
    								예) "5"를 입력하면 회원레벨 5 이상 회원은 신고할수 없습니다.
    								<br />
    								미입력시 모든 회원이 "신고 대상" 이 됩니다. 최고관리자를 제외한 모든 회원을 신고하기 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="exemption_day_n" class="font_oyoomo">☆ 신고 면제 할 가입일수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<span class="font_green">모든 회원을 대상으로 신고할수 있습니다.</span>
    								<br />
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled > 일
    								<br />
    								"가입후 입력한 날짜수" 만큼 지난 회원을 대상으로 "신고하기" 할수 없습니다. ( 신고 대상 면제하는 특권 )
    								<br />
    								예) "100"을 입력하면 가입후 100일 지난 회원을 신고할수 없습니다.
    								<br />
    								미입력시 모든 회원이 "신고 대상" 이 됩니다. 최고관리자를 제외한 모든 회원을 신고하기 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="report_do_point_n" class="font_oyoomo">☆ 신고 한 회원의 포인트<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled > 점
    								<br />
    								신고할때 신고한 회원의 포인트 ( 지급, 차감을 선택할수 있음 ), 입력 않하시면 포인트 변동 없음
    								<br />
    								예) 1점 지급 하시려면 "1" 을 입력 , 1점 차감 하시려면 "-1"을 입력
    								<br />
    								미입력시 신고 한 회원의 포인트를 지급, 차감하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="report_get_point_n" class="font_oyoomo">☆ 신고 당한(받은) 회원의 포인트<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled > 점
    								<br />
    								신고 당한(받은) 회원의 포인트 ( 지급, 차감을 선택할수 있음 ), 입력 않하시면 포인트 변동 없음
    								<br />
    								예) 1점 지급 하시려면 "1" 을 입력 , 1점 차감 하시려면 "-1"을 입력
    								<br />
    								미입력시 신고 당한(받은) 회원의 포인트를 지급, 차감하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="report_rash_point_n" class="font_oyoomo">☆ 무분별한 신고시 신고 한 회원의 포인트<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled > 점
    								<br />
    								무분별한 신고시 신고한 회원의 포인트 ( 지급, 차감을 선택할수 있음 ), 입력 않하시면 포인트 변동 없음
    								<br />
    								예) 1점 지급 하시려면 "1" 을 입력 , 1점 차감 하시려면 "-1"을 입력
    								<br />
    								미입력시 무분별한 신고시 신고 한 회원의 포인트를 지급, 차감하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="report_rash_auth_n" class="font_oyoomo">☆ 무분별한 신고시 신고 권한 제한<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" value="" id="" class="frm_input" size="10" disabled >
    								<br />
    								입력한 회수만큼 무분별한 신고를 하면 신고할수 있는 권한을 회수함
    								<br />
    								예) "2"를 입력하면 허위신고 2회시 다음에 "신고하기" 할수 없습니다.
    								<br />
    								미입력시 무분별한 신고를 해도 신고 권한을 제한하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__bo_cate">
    		<h2 class="h2_frm">그누보드 카테고리 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>그누보드 카테고리 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__BO_CATE"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__BO_CATE" id="USE__BO_CATE" value="1"<?php  IF ($PCF_BOFUNC_USE__BO_CATE == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"그누보드 카테고리" 를 사용합니다.</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="bo_cate_s_len_n">카테고리 제목 길이 Byte<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="text" name="bo_cate_s_len_n" id="bo_cate_s_len_n" value="<?php echo $PCF_BOFUNC_bo_cate_s_len_n; ?>" class="frm_input"> Byte
    								<br />
    								카테고리 길이의 Byte 를 입력해 주세요.
    								<br />
    								스킨의 카테고리 입력 공간에 따라 길이를 입력해 주세요.
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<br />


		<section id="tab__uphill">
    		<h2 class="h2_frm">끌어올림 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>끌어올림 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__UPHILL"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__UPHILL" id="USE__UPHILL" value="1"<?php  IF ($PCF_BOFUNC_USE__UPHILL == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"끌어올림" 를 사용합니다.</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_use_level_n" class="font_oyoomo">☆ 끌어올림 회원 권한 (끌어올림)<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<span class="font_green">모든 회원이 끌어올림을 이용할수 있습니다.</span>
    								<br />
    								<?php echo get_member_level_select__piree('', 1, 1, 1,'' ,' disabled ') ?>
    								<br />
    								끌어올림 할수 있는 회원 끌어올림의 숫자를 입력해 주세요.
    								<br />
    								입력하신 숫자의 끌어올림 회원부터 끌어올림 할수 있습니다.
    								<br />
    								입력하지 않으면 모든 회원이 끌어올림 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_interval_H_n">끌어올림 시간 간격<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="text" name="uphill_interval_H_n" id="uphill_interval_H_n" value="<?php echo $PCF_BOFUNC_uphill_interval_H_n; ?>" class="frm_input"> 시간
    								<br />
    								글 작성하거나 끌어올림후 몇시간이 지나야 다시 끌어올림 할수 있는지 입력해 주세요.
    								<br />
    								12를 입력하면 12시간 지난후에 끌어올림 할수 있습니다.
    								<br />
    								0을 입력하면 10분 간격으로 새로고침 할수 있습니다.
    								<br />
    								참고) 1일 24시간, 2일 48시간, 3일 72시간, 4일 96시간, 5일 120시간, 6일 144시간, 7일 168시간, 10일 240시간
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_point_n" class="font_oyoomo">☆ 끌어올림 포인트<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" id="" value="" class="frm_input" disabled >
    								<br />
    								끌어올림 할때마다 차감 또는 지급할 포인트 점수를 입력해 주세요.
    								<br />
    								차감(마이너스) 하려면 -10 과 같이 "-" 빼기 표시를 점수 앞에 붙혀주세요.
    								<br />
    								입력하지 않으면 포인트를 차감, 지급 하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_day_limit_n" class="font_oyoomo">☆ 전체 하루 제한 회수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" id="" value="" class="frm_input" disabled >
    								<br />
    								전체 게시판에서 각 회원이 하루에 최대로 끌어올림 할수 있는 회수를 입력해 주세요.
    								<br />
    								5라고 입력하면 한 회원이 여러 게시판에서 하루에 5회까지만 끌어올림 할수 있습니다.
    								<br />
    								입력하지 않으면 하루에 제한없이 끌어올림 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_board_limit_n" class="font_oyoomo">☆ 각 게시판별 하루 제한 회수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
						show_plus();

?>
    								<input type="text" name="" id="" value="" class="frm_input" disabled >
    								<br />
    								개별 게시판에서 각 회원이 하루에 최대로 끌어올림 할수 있는 회수를 입력해 주세요.
    								<br />
    								5라고 입력하면 한 회원이 특정 게시판에 끌어올림을 하루에 5회까지만 할수 있습니다.
    								<br />
    								입력하지 않으면 하루에 게시판별 제한없이 끌어올림 할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="uphill_reload_latest_n">메인, 그룹 최신글 반영<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="uphill_reload_latest_n" id="uphill_reload_latest_n" value="1"<?php	IF ($PCF_BOFUNC_uphill_reload_latest_n == 1) { echo ' checked'; }	?>> 반영하기
    								<br />
    								끌어올림을 하면 메인이나 그룹 화면에 반영합니다.
    								<br />
    								끌어올림 하면 최신글 상단에 노출됩니다.
    								<br />
    								여기서 "최신글에 반영" 한다고 해도 개별 게시판 설정에서 "최신글에 반영"하지 않도록 설정하면 끌어올림 해도 "최신글에 반영" 되지 않습니다.
    								<br />
    								즉, 프로그램 설정과 개별 게시판 설정에서 모두 "최신글에 반영" 체크해야 "최신글에 반영" 됩니다.
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__mini_geul">
    		<h2 class="h2_frm">미니글 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>미니글 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col class="td_left_140">
								<col>
						</colgroup>
						<tbody>
    				<tr>
    						<td><label for="USE__MINIGEUL"><span class="font_oyoomo" style="font-weight:bold;">☆ ▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td colspan="2" style="line-height:2.2em;">
    								<input type="checkbox" name="USE__MINIGEUL" id="USE__MINIGEUL" value="1"<?php  IF ($PCF_BOFUNC_USE__MINIGEUL == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"미니글" 를 사용합니다.</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_title_s_len">미니글 제목 길이<strong class="sound_only">선택입력</strong></label></td>
    						<td></td>
    						<td><input type="text" id="mng__arti_title_s_len" name="mng__arti_title_s_len" value="<?php echo $PCF_BOFUNC_mng_arti_title_s_len ?>" class="frm_input required" size="10"> Byte</td>
    				</tr>

    				<tr>
    						<td><label for="sett_default_1"><span style="color:#ff2222;">기본값</span><strong class="sound_only">선택입력</strong></label></td>
    						<td></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
    						;
				}
				ELSE
				{
?>
    								<input type="checkbox" id="" name="" value="" disabled >
    								<span style="color:#ff2222; font-weight:bold;">선택사항들을 " 기본값 " 으로 지정합니다.</span>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan="5"><strong>▶ 설정 기본</strong></td>
    						<td><label for="mng__default_row_n" class="font_oyoomo">☆ ⊙ 왼쪽 줄수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    							show_plus();
?>
    							<span class="font_green">왼쪽은 5개, 오른쪽 5개, 합하여 10개가 보여집니다.</span>
    							<br />
    							<select name="" id="" disabled >
    								<option value="5">5</option>
    							</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__default_left_menu_c" class="font_oyoomo">☆ ⊙ 왼쪽 메뉴<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    							show_plus();
?>
    							<span class="font_green">조회수 순으로 보여집니다.</span>
    							<br />
    							<select name="" id="" disabled >
    								<option value="hit">많이 본글</option>
    							</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__default_left_time_c" class="font_oyoomo">☆ ⊙ 왼쪽 시간<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    							show_plus();
?>
    							<span class="font_green">최근 7일 기준으로 보여집니다.</span>
    							<br />
    							<select name="" id="" disabled >
    								<option value="7d">7일</option>
    							</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__default_right_menu_c" class="font_oyoomo">☆ ⊙ 오른쪽 메뉴<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    							show_plus();
?>
    							<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    							<br />
    							<select name="" id="" disabled >
    								<option value="comment">댓글 많은 글</option>
    							</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__default_right_time_c" class="font_oyoomo">☆ ⊙ 오른쪽 시간<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    							show_plus();
?>
    							<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    							<br />
    							<select name="" id="" disabled >
    								<option value="1m">1개월</option>
    							</select>
<?php
				}

?>
    						</td>
    				</tr>




    				<tr>
    						<td rowspan="3"><label for="mng__arti_new_use" class="font_oyoomo">☆ ▶ 최신글<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_new_time_n" class="font_oyoomo">☆ ⊙ 최신글 시간<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="3" maxlength="2" disabled > 시간
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_new_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_1d_use" class="font_oyoomo">☆ ▶ 1일<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_1d_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_3d_use" class="font_oyoomo">☆ ▶ 3일<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_3d_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_7d_use" class="font_oyoomo">☆ ▶ 7일<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_7d_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_1m_use" class="font_oyoomo">☆ ▶ 1개월<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_1m_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_3m_use" class="font_oyoomo">☆ ▶ 3개월<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_3m_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_6m_use" class="font_oyoomo">☆ ▶ 6개월<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_6m_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_1y_use" class="font_oyoomo">☆ ▶ 1년<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_1y_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td rowspan='2'><label for="mng__arti_all_use" class="font_oyoomo">☆ ▶ 전체<strong class="sound_only">선택입력</strong></label></td>
    						<td><span class="font_oyoomo">☆ ⊙ 사용여부</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 사용합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="mng__arti_all_reload" class="font_oyoomo">☆ ⊙ 새로고침 시간</label></td>
    						<td style="line-height:2.6em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전에서는 사용하지 않습니다.</span>
    								<br />
    								<input type="text" id="" name="" value="" class="frm_input" size="10" disabled > 분에 1회 새로고침 합니다.
    								<br />
    								<span class="font_999">( 최소</span> <span class="str_4466ff_bold"></span>	<span class="font_999">분 이상으로 입력하기를 권장합니다. )</span>
    								<br />
    								<span class="font_999">빠른선택</span>
    								<select name="" onChange="" disabled >
    										<option value="">-- 선택 --</option>
    								</select>
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label><label for="mng__arti_1m_use"><span style="color:#ff2222;">기본값</span><strong class="sound_only">선택입력</strong></label></td>
    						<td></td>
    						<td><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
    						;
				}
				ELSE
				{
?>
    								<input type="checkbox" id="" name="" value="" disabled >
    								<span style="color:#ff2222; font-weight:bold;">선택사항들을 " 기본값 " 으로 지정합니다.</span>
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__naegeul_chang">
    		<h2 class="h2_frm">내글 창 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>내글 창 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__NAEGEUL_CHANG"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__NAEGEUL_CHANG" id="USE__NAEGEUL_CHANG" value="1"<?php  IF ($PCF_BOFUNC_USE__NAEGEUL_CHANG == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"내글 창" 를 사용합니다. ( "내글 창"을 보여줍니다. )</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__board_link_blank" class="font_oyoomo">☆ 게시판 링크 새창<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">현재창에서 선택한 게시판으로 연결됩니다.</span>
    								<br />
    								<input type="checkbox" name="" id="" value="" disabled > 게시판 이름을 클릭하면 새창으로 보여줍니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__article_link_blank" class="font_oyoomo">☆ 게시글 링크 새창<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">현재창에서 선택한 게시글로 연결됩니다.</span>
    								<br />
    								<input type="checkbox" name="" id="" value="" disabled > 게시판 이름을 클릭하면 새창으로 보여줍니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__view_row_n" class="font_oyoomo">☆ 화면에 보여줄 글수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">화면에 게시글 10개를 보여줍니다.</span>
    								<br />
    								<input type="text" name="" id="" value="" class="frm_input" size="10" disabled > 개
    								<br />
    								화면에 보여줄 게시글 수를 적어 주세요.
    								<br />
    								5이상 255이하로 입력해 주세요. 미입력시 기본값 "10"을 저장합니다.
    								<br />
    								예) 10 , 15 , 20
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__view_comment_n" class="font_oyoomo">☆ 댓글 수 표시<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">표시되지 않습니다.</span>
    								<br />
    								<input type="checkbox" id="" name="" value="" disabled > 게시글 제목 옆에 댓글 수를 표시 합니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__new_time_n" class="font_oyoomo">☆ 새글 아이콘 시간<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">표시되지 않습니다.</span>
    								<br />
    								<input type="text" name="" id="" value="" class="frm_input" size="10" disabled > 시간
    								<br />
    								글 입력후 new 이미지를 출력하는 시간. 0을 입력하시면 아이콘을 출력하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="ngc__hot_hit_n" class="font_oyoomo">☆ 인기글 아이콘 조회수<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">표시되지 않습니다.</span>
    								<br />
    								<input type="text" name="" id="" value="" class="frm_input" size="10" disabled > 건
    								<br />
    								조회수가 설정값 이상이면 hot 이미지 출력합니다.
    								<br />
    								예) 10 , 15 , 20
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<br />


		<section id="tab__ajax_comment">
    		<h2 class="h2_frm">AJAX 댓글 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>AJAX 댓글 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><span class="font_oyoomo">☆ 사용하는 댓글 시스템</span></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">그누보드5의 기본 댓글을 사용합니다.</span>
    								<br />
    								<div style="line-height:2.2em;">
<?php

    								//=========================================
    								// 시작 => 돌려라__반복문
    								WHILE (list($key, $val) = each($use_comment_sys_arr))
    								{
?>
    										<p><input type="radio" name="" id="" value="" disabled >
    												<label for=""><?php echo $val; ?></label></p>
<?php
    								}
    								// 끝 => 돌려라__반복문
    								//=========================================

?>
    								</div>
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__article_vote">
    		<h2 class="h2_frm">게시글 투표 - 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>게시글 투표 - 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__ARTICLE_VOTE"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__ARTICLE_VOTE" id="USE__ARTICLE_VOTE" value="1"<?php  IF ($PCF_BOFUNC_USE__ARTICLE_VOTE == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"게시글 투표" 를 사용합니다.</span>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="vote_item_t" class="font_oyoomo">☆ 최대 투표 항목 수<strong class="sound_only">필수입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">최대 5개 항목으로 투표할수 있습니다.</span>
    								<br />
    								<input type="text" name="" id="" value="" class="frm_input" size="10" disabled > <strong>개</strong>
    								<br />
    								투표 항목을 몇개까지 만들수 있는지 입력해 주세요.
    								<br />
    								0을 입력하면 "게시글에 투표"를 사용하지 않습니다.
    								<br />
    								20이하로 입력해 주세요. 20을 초과 입력하면 기본값 "10"을 저장합니다.
    								<br />
    								예) 10 , 15 , 20
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="vote_regi_level_n" class="font_oyoomo">☆ 투표 등록 회원 레벨<strong class="sound_only">필수입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">모든 회원이 투표에 참여할수 있습니다.</span>
    								<br />
    								<?php echo get_member_level_select__piree('', 1, 1, 1, '' ,' disabled') ?> 
    								<strong>이상 회원은 투표를 등록할수 있습니다.</strong>
    								<br />
    								게시글에 투표를 등록 할수 있는 회원 레벨을 숫자를 입력해 주세요.
    								<br />
    								입력하신 숫자 레벨 이상인 회원이 투표를 등록할수 있습니다.
    								<br />
    								입력하지 않으면 모든 회원이 투표를 등록할수 있습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="vote_image_ok_n" class="font_oyoomo">☆ 이미지 투표<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전은 이미지 투표 할수 없습니다.</span>
    								<br />
    								<input type="checkbox" name="" id="" value="" disabled > <strong>투표 항목에 이미지를 등록하여 "이미지 투표" 할수 있습니다.</strong>
    								<br />
    								이미지를 보고 투표할수 있게 하시려면 체크 하세요.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="vote_regi_point_n" class="font_oyoomo">☆ 투표 등록시 차감 포인트<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전은 투표를 등록해도 포인트를 차감하지 않습니다.</span>
    								<br />
    								<input type="text" name="" id="" value="" class="frm_input" size="10" disabled > <strong>점</strong>
    								<br />
    								투표를 등록할 경우 차감할 포인트 점수를 양수로 입력해 주세요.
    								<br />
    								입력하지 않으면 포인트를 차감 하지 않습니다.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="vote_day_default_t" class="font_oyoomo">☆ 투표 기간 기본값<strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<span class="font_green">FREE 버전은 기간을 기본 10일로 고정되어 있으며 기간을 변경하지 못합니다.</span>
    								<br />
    								<input type="text" name="" id="" value="10" class="frm_input" size="10" disabled > <strong>점</strong>
    								<br />
    								투표를 몇일간 할지 기본값을 숫자로만 입력해 주세요.
    								<br />
    								투표 등록하는 사람이 기간을 길게 또는 짧게 변경할수 있습니다.
    								<br />
    								입력하지 않으면 "10" 일이 저장됩니다.
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>


		<section id="tab__etc_conf">
    		<h2 class="h2_frm">기타 설정</h2>
    		<?php echo $tab_anchor ?>

		    <div class="tbl_frm01 tbl_wrap">
						<table>
						<caption>기타 설정</caption>
						<colgroup>
								<col class="td_left_240">
								<col>
						</colgroup>
						<tbody>

    				<tr>
    						<td><label for="USE__EXIT_CONFIRM"><span style="color:#0000ff; font-weight:bold;">▶ 사용여부</span><strong class="sound_only">선택입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<input type="checkbox" name="USE__EXIT_CONFIRM" id="USE__EXIT_CONFIRM" value="1"<?php  IF ($PCF_BOFUNC_USE__EXIT_CONFIRM == 1) { echo ' checked'; } ?>> 
    								<span style="color:#0000ff; font-weight:bold;">"글쓰기 나갈때 확인하기" 를 사용합니다.</span>
    								<br />
    								"글쓰기 EXIT 확인" 이란 글쓰기 화면에서 다른 링크를 클릭하면 바로 이동하여 글작성했던 내용이 사라지는것을 방지하는 기능입니다.
    						</td>
    				</tr>

    				<tr>
    						<td><label for="exit_confirm_msg_s">나갈때 확인하기 메세지<strong class="sound_only">필수입력</strong></label></td>
    						<td style="line-height:2.2em;">
    								<textarea name="exit_confirm_msg_s" id="exit_confirm_msg_s" style="width:600px; height:50px;"><?php echo $PCF_BOFUNC_exit_confirm_msg_s; ?></textarea>
    								<br />
    								글쓰기 나갈때 확인하기 경고창에 띄울 "메세지"를 입력합니다.
    								<br />
    								입력하지 않으면 자동으로 기본값으로 저장됩니다.
    						</td>
    				</tr>

    				<tr>
    						<td><label for="conf_read_level_n" class="font_oyoomo">☆ 게시글 읽기 사용 레벨<strong class="sound_only">필수입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<?php echo get_member_level_select__piree('', 0, 1, 1, '', ' disabled ') ?>
    								<br />
    								"게시글 읽기 레벨"이란 개별 게시글별로 읽기 레벨을 달리하는 기능입니다.
    								<br />
    								예를 들어 1번글은 레벨 2부터 읽을수 있고, 2번글은 레벨 3부터 읽을수 있습니다.
    								<br />
    								여기서 레벨2를 선택하면 "레벨 2"인 회원이 "개별 게시글 읽기 레벨"을 사용할수 있습니다.
    								<br />
    								사용하지 않으려면 0을 선택해 주세요.
    								<br />
    								관리자만 게시글별로 읽기 레벨을 달리하려면 레벨을 관리자 레벨로 선택해 주세요.
<?php
				}

?>
    						</td>
    				</tr>

    				<tr>
    						<td><label for="conf_read_level_style_s" class="font_oyoomo">☆ 게시글 읽기 레벨 스타일<strong class="sound_only">필수입력</strong></label></td>
    						<td style="line-height:2.2em;"><?php

				IF (PIREE_BUILDER_OYO_OMO == 'OYO')
				{
						;
				}
				ELSE
				{
    								show_plus();
?>
    								<input type="text" name="" id="" value="" class="frm_input" size="40" disabled >
    								<br />
    								"게시판의 게시글 목록 화면"에서 "게시글 읽기 레벨" 숫자를 표시하는 스타일을 입력해 주세요.
    								<br />
    								미 입력시 "color:#0000ff;" 로 입력 됩니다.
<?php
				}

?>
    						</td>
    				</tr>

    				</tbody>
    				</table>
    		</div>

		</section>


		<br />


		<div class="btn_confirm">
			<input type="submit" class="btn_submit" value=" 설 정 정 보 를	저 장 합 니 다 ">
			<input type="button" class="btn_cancel" value=" 취소하기 " onClick="PageUrl('./index.php')">
		</div>

		</form>

</section>


<script>

function submit__config_form(gform)
{

		return true;

}


<?php

	IF (PIREE_BUILDER_OYO_OMO == 'OYO')
	{
			;
	}

?>

</script>


<?php

	//=======================================================
	// ADMIN_TAIL__첨부
	include_once ('../admin.tail.php');

?>