<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE ( 원병철 , piree1977@gmail.com )

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 10월 26일 일요일 오후 12시 47분, 날씨 맑음

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 이미지 > 이미지 등록하기
===========================================================


	//*******************************************************
	//** DEV_SOSS
	//*******************************************************


cd /home/piree/www/piree/sam/data/IUO/1/0/0/0/0/0/0/


BIGINT
9223372036854775807
18446600000000000000


$piree_table['image_list']


*/


	#########################################################
	# 시작 => 선__처리
	#########################################################

	//=======================================================
	// 개별_페이지__접근_불가
	IF (!defined('_GNUBOARD_'))											EXIT;

	#########################################################
	# 끝 => 선__처리
	#########################################################



	#########################################################
	# 시작 => 이미지_확장자__알아내기
	#########################################################
	function get__image_extension($image_file_s)
	{

			//===================================================
			// 전역__변수
			global $image_upload_temp_path;


			//===================================================
			// 확장자
			$img_extension_s = 0;


			//===================================================
			// 시작 => 에러__없으면
			IF ($in_error_t == 0)
			{

					//===============================================
					// 확장자
					$exs = explode(".", $image_file_s);
					$img_extension_s = trim($exs[count($exs)-1]);
					$img_extension_s = strtolower($img_extension_s);

			}
			// 끝 => 에러__없으면
			//===================================================


			//===================================================
			// 넘겨주기__확장자
			return $img_extension_s;

	}
	// 끝 => 기본_설정_첨부__하기
	//=======================================================

	#########################################################
	# 끝 => 이미지_확장자__알아내기
	#########################################################



	#########################################################
	# 시작 => 이미지_업로드__선처리
	#########################################################
	function piree__image_upload_front($file_save_type, $mem_id, $image_file_s, $image_title_s, $image_size_arr)
	{

			//===================================================
			// 전역__변수
			global $image_upload_temp_path;


			//===================================================
			// 이미지_정보_배열
			$image_arr = array();


			//===================================================
			// 에러_건수
			$in_error_t = 0;


			//===================================================
			// 시작 => 매개변수__확인
			IF (!$file_save_type)											$in_error_t++;
			IF (!$mem_id)															$in_error_t++;
			IF (!$image_file_s)												$in_error_t++;
			IF (!$image_size_arr[0])									$in_error_t++;
			IF (!$image_size_arr[1])									$in_error_t++;


			//===================================================
			// 시작 => 에러__없으면
			IF ($in_error_t == 0)
			{

					//===============================================
					// 시작 => 기본값
					IF (!$image_title_s)									$image_title_s = '제목없음';


					//===============================================
					// 임시__피리_이미지_디렉토리
					$temp_piree_image_dir = 'image_temp';


					//===============================================
					// 날짜
					$today_Ymd_date = date('Ymd');


					//===============================================
					// 이미지_업로드__구분_위치
					$image_arr['file_save_type'] = $file_save_type;


					//===============================================
					// 이미지_제목
					$image_arr['file_title_s'] = trim(stripslashes(clean_xss_tags($image_title_s)));


					//===============================================
					// 이미지_확장자_얻기
					$image_arr['extension_s'] = get__image_extension($image_file_s);


					//===============================================
					// 이미지_이름
					$image_arr['file_s'] = $mem_id .'__' . rand() .'.'. $image_arr['extension_s'];


					//===============================================
					// 임시_경로
					$image_arr['path_1_s'] = G5_DATA_PATH .'/' . $temp_piree_image_dir .'/';
					$image_arr['path_2_s'] = $image_arr['path_1_s'] . $today_Ymd_date .'/';


					//===============================================
					// 1차_디렉토리__없으면__만들기
					mkdir_chmod($image_arr['path_1_s']);


					//===============================================
					// 2차_디렉토리__없으면__만들기
					mkdir_chmod($image_arr['path_2_s']);


					//===============================================
					// 전체_경로__경로_파일이름
					$image_arr['file_path'] = $image_arr['path_2_s'] . $image_arr['file_s'];


					//===============================================
					// 이미지_해상도
					$image_arr['width_n']   = $image_size_arr[0];
					$image_arr['heighth_n'] = $image_size_arr[1];

			}
			// 끝 => 에러__없으면
			//===================================================


			//===================================================
			// 이미지_정보_배열
			return $image_arr;

	}
	// 끝 => 기본_설정_첨부__하기
	//=======================================================

	#########################################################
	# 끝 => 이미지_업로드__선처리
	#########################################################



	#########################################################
	# 시작 => 업로드_된__이미지__알아내기
	#########################################################
	function get__article_upload_image_arr($bo_table, $wr_id)
	{

			//===================================================
			//  전역변수
			global $config, $g5;


			//===================================================
			// 첨부파일__타입
			$bf_type = 4;


			//===================================================
			// 업로드된__이미지_배열
			$image_upload_arr = array();


			//===================================================
			// 첨부된__이미지__가져오기
			// $sql  = "SELECT `bo_table`,`wr_id`,`bf_no`,`bf_source`,`bf_file`,`bf_download`,`bf_content`,`bf_filesize`,`bf_width`,`bf_height`,`bf_type`,`bf_datetime` ";
			$sql  = "SELECT `bo_table`,`wr_id`,`bf_no`,`bf_file`,`bf_download`,`bf_content`,`bf_datetime` ";
			$sql .= "FROM `".$g5['board_file_table']."` ";
			$sql .= "WHERE `bf_type` < '".$bf_type."' AND `bo_table` = '".$bo_table."' AND `wr_id` = '".$wr_id."' ORDER BY `bf_no` ASC";
			$result = sql_query ($sql);


			//===================================================
			// 시작 => 돌려라__반복문
			WHILE ($row = sql_fetch_array($result))
			{

					//===============================================
					// 파일_순서
					$bf_no = $row['bf_no'];


					//===============================================
					// 경로__만들기
					$upload_path_1 = PIREE_FILE_UPLOAD_DIR.'/'.$bo_table.'/'.$row['bf_file'];
					$upload_path_2 = G5_DATA_PATH.'/'.$upload_path_1;


					//===============================================
					// 시작 => 이미지__이면
					IF (is_file($upload_path_2) && preg_match("/\.({$config['cf_image_extension']})$/i", $row['bf_file']))
					{

							//===========================================
							// 날짜__일시
							$save_time_n = strtotime($row['bf_datetime']);


							//===========================================
							// 업로드된__이미지_배열
							$image_upload_arr[] = array(
																					'file_save_type'		=> 'gnu5_file_upload',
																					'file_path'					=> $upload_path_2,
																					'file_bo_table'			=> $bo_table,
																					'file_wr_id'				=> $wr_id,
																					'file_no'						=> $row['bf_no'],
																					'file_name'					=> $row['bf_file'],
																					'file_download_n'		=> $row['bf_download'],
																					'file_title_s'			=> $row['bf_content'],
																					'file_save_time_n'	=> $save_time_n
																					);

					}
					// 끝 => 이미지__이면
					//===============================================

			}
			// 끝 => 돌려라__반복문
			//===================================================


			//===================================================
			// 업로드된__이미지_배열__넘겨주기
			return $image_upload_arr;

	}
	#########################################################
	# 끝 => 업로드_된__이미지__알아내기
	#########################################################



	#########################################################
	# 시작 => 이미지__목록__추출하기
	#########################################################
	function get__image_list_arr($content)
	{

			#####################################################
			# 시작 => 상수__변수
			#####################################################

			//===================================================
			// 이미지_배열
			$image_path_arr = array();


			//===================================================
			// 내용__쿼터_제거
			$content = stripslashes($content);
			$content = stripslashes($content);

			#####################################################
			# 끝 => 상수__변수
			#####################################################



			#####################################################
			# 시작 => 이미지__파일_경로__구하고__저장하기
			#####################################################

			//===================================================
			// 이미지_배열_가져오기
			$matches = get_editor_image($content, true);


			//===================================================
			// 시작 => 돌려라__반복문
	  	FOR ($i=0; $i<count($matches[1]); $i++)
			{

					//===============================================
					// 이미지_TAG
					$img = $matches[1][$i];
					preg_match("/src=[\'\"]?([^>\'\"]+[^>\'\"]+)/i", $img, $m);
					$src = $m[1];


					//===============================================
					// 이미지_PATH
	      	$p = parse_url($src);


					//===============================================
					// 시작 => 이미지_PATH_완성
	     	 	IF (strpos($p['path'], '/'.G5_DATA_DIR.'/') != 0)
	      	{
	     	     $data_path = preg_replace('/^\/.*\/'.G5_DATA_DIR.'/', '/'.G5_DATA_DIR, $p['path']);
	     	 	}
	     	 	ELSE
	     	 	{
	     	     $data_path = $p['path'];
	      	}
					// 끝 => 이미지_PATH_완성
					//===============================================


					//===============================================
					// 이미지_파일_경로
	      	$old_image_path = G5_PATH.$data_path;


					//===============================================
					// 시작 => 처음_첨부된__이미지__이면
					IF (eregi(G5_DATA_PATH.'/editor/', $old_image_path))
					{

							//===========================================
							// 등록한_이미지_수__증가
							$image_path_arr['image_t']++;


							//===========================================
							// 이미지_배열
							$image_path_arr[] = array(
																				'file_save_type' => 'smarteditor2',
																				'file_path'			 => $old_image_path
																				);

					}
					// 끝 => 처음_첨부된__이미지__이면
					//===============================================

			}
			// 끝 => 돌려라__반복문
			//===================================================


			//===================================================
			// 이미지_배열__넘겨주기
			return $image_path_arr;

			#####################################################
			# 끝 => 이미지__파일_경로__구하고__저장하기
			#####################################################

	}
	#########################################################
	# 끝 => 이미지__목록__추출하기
	#########################################################



	#########################################################
	#	시작 => 이미지__정보__저장
	#########################################################
	function save__image_index($image_path_arr, $img_arti_code, $img_arti_table, $img_arti_n, $img_arti_idx_n, $img_mem_n, $img_mem_id, $img_mem_name, $img_title_s, $img_ip, $img_log_time_n, $img_regi_time_n)
	{

			//===================================================
			// 전역_변수
			global $g5, $piree_table;


			//===================================================
			// INDEX_업로드_수
			$image_arr['image_t'] = 0;


			//===================================================
			// 내부_에러
			$in_errors = 0;


			//===================================================
			// 값_유무__확인하기
			IF (count($image_path_arr) < 1)							$in_errors++;
			IF (!$img_arti_code)												$in_errors++;
			IF (!$img_arti_idx_n)												$in_errors++;
			IF (!$img_mem_n)														$in_errors++;
			IF (!$img_mem_id)														$in_errors++;
			IF (!$img_mem_name)													$in_errors++;
			IF (!$img_ip)																$in_errors++;
			IF (!$img_log_time_n)												$in_errors++;
			IF (!$img_regi_time_n)											$in_errors++;


			//===================================================
			// 시작 => 내부_에러__없으면
			IF ($in_errors == 0)
			{

					//===============================================
					// 전역변수
					global $PG_IMGHLP_old_image_is_delete, $PCF_BOFUNC_old_image_is_delete;


					//===============================================
					// 기본값
					IF (!$img_arti_n)												$img_arti_n				= 0;
					IF (!$img_arti_table)										$img_arti_table		= "";
					IF (!$img_title_s)											$img_title_s			= "제목없음";
					IF (!$img_ip)														$img_ip						= $_SERVER['REMOTE_ADDR'];
					IF (!$img_log_time_n)										$img_log_time_n		= G5_SERVER_TIME;
					IF (!$img_regi_time_n)									$img_regi_time_n	= G5_SERVER_TIME;


					//===============================================
					// 원본__이미지
					$image_arr['old_image'] = array();


					//===============================================
					// 새__이미지
					$image_arr['new_image'] = array();


					//===============================================
					// 이미지_순서
					$image_arr['image_key'] = array();


					//===============================================
					// 새__이미지__정보
					$image_arr['image_new_n'] = array();
					$image_arr['image_new_s'] = array();


					//===============================================
					// 시작 => 돌려라__반복문
					WHILE (list($key, $val) = each($image_path_arr))
					{

							//===========================================
							// 이미지__파일_경로
							$old_image_path = trim(clean_xss_tags($val['file_path']));


							//===========================================
							// 이미지_구분
							$old_image_div_c = trim($val['file_save_type']);


							//===========================================
							// 시작 => 이미지__파일__있으면
							IF (file_exists($old_image_path))
							{

									#########################################
									# 시작 => 변수
									#########################################

									//=======================================
									// 이미지_번호
									$image_n = 0;


									//=======================================
									// INDEX_번호
									$index_n = 0;


									//=======================================
									// 대표_이미지__여부
									// 0 - 아님
									$is_face_image_n = 0;


									//=======================================
									// 제목
									$save_title_s = $img_title_s;


									//=======================================
									// 시작 => 이미지_업로드__구분_코드__구분
									SWITCH ($val['file_save_type'])
									{

											#####################################
											# 시작 => 파일_업로드
											CASE 'gnu5_file_upload' :

													//===============================
													// 시작 => 파일_업로드__제목__있으면
													IF ($val['file_title_s'])
													{
															//===========================
															// 제목
															$save_title_s = $val['file_title_s'];
													}
													// 끝 => 파일_업로드__제목__있으면
													//===============================

											BREAK;
											# 끝 => 파일_업로드
											#####################################



											#####################################
											# 시작 => 게시글에_투표
											CASE 'article_vote' :

													//===============================
													// 시작 => 게시글에_투표__제목__있으면
													IF ($val['file_title_s'])
													{
															//===========================
															// 제목
															$save_title_s = $val['file_title_s'] .' > '. $img_title_s;
													}
													// 끝 => 게시글에_투표__제목__있으면
													//===============================

											BREAK;
											# 끝 => 게시글에_투표
											#####################################

									}
									// 끝 => 이미지_업로드__구분_코드__구분
									//=======================================


									//=======================================
									// 제목_쿼터_다듬기
									$save_title_s = stripslashes($save_title_s);
									$save_title_s = stripslashes($save_title_s);
									$save_title_s = stripslashes($save_title_s);
									$save_title_s = addslashes($save_title_s);


									//=======================================
									// 이미지_파일_경로__임시_배열
									$temp_arr = explode('/', $old_image_path);


									//=======================================
									// 이미지_파일__이름
									$image_file_s = $temp_arr[(count($temp_arr)-1)];


									//=======================================
									// 이미지_파일__쿼터_다듬기
									$image_file_s = stripslashes($image_file_s);
									$image_file_s = addslashes($image_file_s);


									//=======================================
									// 이미지_파일_이름__임시_배열
									$temp_arr = explode(".", $image_file_s);


									//=======================================
									// 이미지_파일__확장자
									$extension_s = $temp_arr[(count($temp_arr)-1)];
									$extension_s = strtolower($extension_s);


									//=======================================
									// 시작 => 이미지_파일__확장자__JPEG_는_JPG_로__변경
									IF ($extension_s == "jpeg")
									{
											$extension_s = "jpg";
									}
									// 끝 => 이미지_파일__확장자__JPEG_는_JPG_로__변경
									//=======================================


									//=======================================
									// 원본_이미지_파일_해상도
									$size_arr = getimagesize($old_image_path);


									//=======================================
									// 목록_순서__가져오기
									$image_list_key_n = get_list_key($img_regi_time_n);


									//=======================================
									// 등록_일시
									$save_regi_time_n = $val['file_save_type'] == 'gnu5_file_upload' && $val['file_save_time_n'] > 0 ? $val['file_save_time_n'] : $img_regi_time_n;

									#########################################
									# 끝 => 변수
									#########################################



									#########################################
									# 시작 => 이미지_목록__저장
									#########################################

									//=======================================
									// 이미지_목록__저장하는__쿼리문
									$sql	= "INSERT INTO `".$piree_table['image_list']."` SET ";
									$sql .= "`iml_list_key_n`		= '".$image_list_key_n."', ";
									$sql .= "`iml_arti_code`		= '".$img_arti_code."', ";
									$sql .= "`iml_arti_table`		= '".$img_arti_table."', ";
									$sql .= "`iml_arti_n`				= '".$img_arti_n."', ";
									$sql .= "`iml_arti_idx_n`		= '".$img_arti_idx_n."', ";
									$sql .= "`iml_mem_n`				= '".$img_mem_n."', ";
									$sql .= "`iml_mem_id`				= '".$img_mem_id."', ";
									$sql .= "`iml_mem_nick`			= '".$img_mem_name."', ";
									$sql .= "`iml_title_s`			= '".$save_title_s."', ";
									$sql .= "`iml_file_old_s`		= '".$image_file_s."', ";
									$sql .= "`iml_extension_s`	= '".$extension_s."', ";
									$sql .= "`iml_regist_way_c`	= '".$old_image_div_c."', ";
									$sql .= "`iml_ip`						= '".$img_ip."', ";
									$sql .= "`iml_regi_time_n`	= '".$save_regi_time_n."', ";
									$sql .= "`iml_last_time_n`	= '".$img_log_time_n."'";


									//=======================================
									// 시작 => 저장하지_못했으면
									IF ( !sql_query ($sql) )
									{
											// 에러
											$msg_s = "이미지 INDEX를 저장하지 못했습니다.";
											alert ($msg_s, "");
									}
									// 끝 => 저장하지_못했으면
									//=======================================


									//=======================================
									// 이미지_번호__알아내기
									$image_n = mysql_insert_id();

									#########################################
									# 끝 => 이미지_목록__저장
									#########################################



									#########################################
									# 시작 => 이미지__파일__복사
									#########################################

									//=======================================
									// 파일_이름
									$new_file_s = $image_n ."_". $img_mem_n .".". $extension_s;


									//=======================================
									// 새_파일__배열에__저장
									$image_arr['old_image'][$image_n] = str_replace(G5_DATA_PATH, G5_DATA_URL, $old_image_path);


									//=======================================
									// 이미지__경로__가져오기
									$image_path_s = get__image_path($image_n);


									//=======================================
									// 새__이미지_경로
									$new_image_path = $image_path_s.$new_file_s;


									//=======================================
									// 저장용__이미지_경로
									$image_path_s = str_replace(G5_DATA_PATH.'/', '', $image_path_s);


									//=======================================
									// 이미지__복사
									copy ($old_image_path, $new_image_path);


									//=======================================
									// 새__이미지__파일_사이즈_구함
									$new_image_size = (int)filesize($new_image_path);


									//=======================================
									// 파일_퍼미션
									chmod($new_image_path, G5_FILE_PERMISSION);


									//=======================================
									// 시작 => 기존_이미지_삭제하기__이면
									IF ($PG_IMGHLP_old_image_is_delete == 1 || $PCF_BOFUNC_old_image_is_delete == 1)
									{
											//===================================
											// 기존__이미지__삭제
											@unlink ($old_image_path);
									}
									// 끝 => 기존_이미지_삭제하기__이면
									//=======================================


									//=======================================
									// 기존_이미지__URL__배열_저장
									$image_arr['old_image'][$image_n] = str_replace(G5_DATA_PATH, G5_DATA_URL, $old_image_path);


									//=======================================
									// 새_이미지__URL__배열_저장
									$image_arr['new_image'][$image_n] = str_replace(G5_DATA_PATH, G5_DATA_URL, $new_image_path);


									//=======================================
									// 이미지_순서
									$image_arr['image_key'][$image_n] = $key;


									//=======================================
									// 새__이미지__정보
									$image_arr['image_new_n'][$image_n] = $image_n;
									$image_arr['image_new_s'][$image_n] = $new_file_s;


									//=======================================
									// INDEX_업로드_수__증가
									$image_arr['image_t']++;

									#########################################
									# 끝 => 이미지__파일__복사
									#########################################



									#########################################
									# 시작 => 통합__INDEX__저장하기
									#########################################

									//=======================================
									// INDEX__변수
									$overlap_ck			= 0;
									$idx_code				= "image";
									$idx_table			= $piree_table['image_list'];
									$idx_v_n				= $image_n;
									$idx_v_s				= "";
									$reload_idx_n		= 0;
									$reload_table		= '';
									$reload_wh_s		= '';
									$an_arti_code		= $img_arti_code;
									$an_arti_table	= $img_arti_table;
									$an_arti_idx_n	= $img_arti_idx_n;
									$an_work_s			= '이미지 업로드';
									$an_mem_n				= $img_mem_n;
									$an_mem_id			= $img_mem_id;
									$an_log_time_n	= $img_log_time_n;
									$an_regi_time_n	= $img_regi_time_n;


									//=======================================
									// INDEX_번호__알아내기
									$index_n = save__index($overlap_ck, $idx_code, $idx_table, $idx_v_n, $idx_v_s, $reload_idx_n, $reload_table, $reload_wh_s, $an_arti_code, $an_arti_table, $an_arti_idx_n, $an_work_s, $an_mem_n, $an_mem_id, $an_log_time_n, $an_regi_time_n);

									#########################################
									# 끝 => 통합__INDEX__저장하기
									#########################################



									#########################################
									# 시작 => 이미지__정보__수정하기
									#########################################

									//=======================================
									// 이미지__정보__수정하는__쿼리문
									$sql	= "UPDATE `".$piree_table['image_list']."` SET ";
									$sql .= "`idx_n`					= '".$index_n."', ";
									$sql .= "`iml_file_new_s`	= '".$new_file_s."', ";
									$sql .= "`iml_width_n`		= '".$size_arr[0]."', ";
									$sql .= "`iml_height_n`		= '".$size_arr[1]."', ";
									$sql .= "`iml_filesize_n`	= '".$new_image_size."', ";							
									$sql .= "`iml_download_n`	= '".$val['file_download_n']."', ";
									$sql .= "`iml_path_s`			= '".$image_path_s."' ";
									$sql .= "WHERE `image_n`	= '".$image_n."'";


									//=======================================
									// 시작 => 저장하지_못했으면
									IF ( !sql_query ($sql) )
									{
											// 에러
											$msg_s = "[ ".$image_n." ] 번 이미지 목록을 저장하지 못했습니다.";
											alert ($msg_s, "");
									}
									// 끝 => 저장하지_못했으면
									//=======================================

									#########################################
									# 끝 => 이미지__정보__수정하기
									#########################################



									#########################################
									# 시작 => 게시판__파일_업로드__이면__ROW__삭제
									#########################################

									//=======================================
									// 시작 => 게시판__파일_업로드__이면
									IF ($old_image_div_c == 'gnu5_file_upload')
									{

											//===================================
											// 게시판_테이블_코드
											$in_bo_table = $val['file_bo_table'];


											//===================================
											// 게시글_번호
											$in_wr_id = $val['file_wr_id'];


											//===================================
											// 기존_파일_번호
											$in_bf_no = $val['file_no'];


											//===================================
											// 첨부파일_정보__삭제하기
											$sql  = "DELETE FROM `".$g5['board_file_table']."` ";
											$sql .= "WHERE bo_table = '".$in_bo_table."' AND wr_id = '".$in_wr_id."' AND bf_no = '".$in_bf_no."'";


											//===================================
											// 시작 => 쿼리_실행_하지__못했으면
											IF ( !sql_query ($sql) )
											{
													alert ("업로드된 이미지를 새로고침 하지 못했습니다.");
											}
											// 끝 => 쿼리_실행_하지__못했으면
											//===================================

									}
									// 끝 => 게시판__파일_업로드__이면
									//=======================================

									#########################################
									# 끝 => 게시판__파일_업로드__이면__ROW__삭제
									#########################################

							}
							// 끝 => 이미지__파일__있으면
							//===========================================

					}
					// 끝 => 돌려라__반복문
					//===============================================

			}
			// 끝 => 내부_에러__없으면
			//===================================================


			//===================================================
			// 이미지_배열__넘겨주기
			return $image_arr;

	}
	#########################################################
	# 끝 => 이미지__정보__저장
	#########################################################



	#########################################################
	#	시작 => 내용의__이미지_URL__변경
	#########################################################
	function change__content_image_url($content, $old_image_arr, $new_image_arr)
	{

			//===================================================
			// 내부_에러
			$in_errors = 0;


			//===================================================
			// 값_유무__확인하기
			IF (strlen($content) < 5)										$in_errors++;
			IF (count($old_image_arr) < 1)							$in_errors++;
			IF (count($new_image_arr) < 1)							$in_errors++;


			//===================================================
			// 시작 => 내부_에러__없으면
			IF ($in_errors == 0)
			{

					//===============================================
					// 시작 => 돌려라__반복문
					WHILE (list($key, $val) = each($old_image_arr))
					{

							//===========================================
							// 이미지__번호
							$key_n = $key;


							//===========================================
							// 기존_이미지__URL
							$old_image_u = trim($val);


							//===========================================
							// 새_이미지__URL
							$new_image_u = $new_image_arr[$key_n];


							//===========================================
							// 기존__타이틀__추출
							$exs = explode('/', $old_image_u);
							$old_title_s = $exs[(count($exs)-1)];


							//===========================================
							// 새__타이틀__추출
							$exs = explode('/', $new_image_u);
							$max_s = $exs[(count($exs)-1)];
							$new_title_s = substr($max_s, 0, strpos($max_s, '_'));


							//===========================================
							// 글내용__이미지_URL__변경
							$content = str_replace($old_image_u, $new_image_u, $content);


							//===========================================
							// 글내용__이미지_TITLE__변경
							$content = str_replace("title=".$old_title_s, "title=\"".$new_title_s."\"", $content);

					}
					// 끝 => 돌려라__반복문
					//===============================================


					//===============================================
					// 글내용__쿼터__다듬기
					$content = stripslashes($content);
					$content = stripslashes($content);
					$content = stripslashes($content);
					$content = addslashes($content);

			}
			// 끝 => 내부_에러__없으면
			//===================================================


			//===================================================
			// 글_내용__넘겨주기
			return $content;

	}
	#########################################################
	# 끝 => 내용의__이미지_URL__변경
	#########################################################



	#########################################################
	#	시작 => 이미지__본문에_사용_여부__새로고침_하기
	#########################################################
	function reload__content_image_use($arti_idx_n, $content_s)
	{

			//===================================================
			// 시작 => 게시글_자료__INDEX_번호__있으면
			IF ($arti_idx_n > 0)
			{

					//===============================================
					// 시작 => 게시글_내용__있으면
					IF ($content_s)
					{

							#############################################
							# 시작 => 이미지__모두__본문에_없음__처리
							#############################################

							//===========================================
							// 전역_변수
							global $piree_table, $PCF_BOFUNC_none_tag_delete;


							IF (PIREE_BUILDER_OYO_OMO == 'OYO')
							{
									;
							}


							//===========================================
							// 이미지__모두__본문에_없음__처리하는__쿼리문
							$sql	= "UPDATE `".$piree_table['image_list']."` SET ";
							$sql .= "`iml_in_cont` = '0' ";
							$sql .= "WHERE iml_arti_idx_n = '".$arti_idx_n."'";


							//===========================================
							// 시작 => 쿼리_실행_하지__못했으면
							IF ( !sql_query ($sql) )
							{
									echo "#ERROR:이미지 목록의 사용여부를 초기화하지 못했습니다.";
									EXIT;
							}
							// 끝 => 쿼리_실행_하지__못했으면
							//===========================================

							#############################################
							# 끝 => 이미지__모두__본문에_없음__처리
							#############################################



							#############################################
							# 시작 => 이미지_추출__배열로_받기
							#############################################

							//===========================================
							// 이미지_태그
							// 전체
							// $pattern_s = "/<img.+src=[\"']?([^>\"']+)[\"']?[^>]*>/i";


							//===========================================
							// 이미지_태그
							// <IMG 부터 URL까지만 뽑아온다.
							// $pattern_s = "/<IMG\s[^>]*src=[\"']?([^>\"']+)[\"']?[^>]*.[a-z0-9]+/i"; // <IMG 된다


							//===========================================
							// 이미지_태그
							// 잘_쓰던거
							// $pattern_s = "/<img.+src=[\"']?([^>\"']+)[\"']?[^>]*>/i";


							//===========================================
							// 이미지_태그
							$pattern_s = "/<IMG\s[^>]*src=[\"']?([^>\"']+)[\"']?[^>]*>/i"; // <IMG 된다


							//===========================================
							// 정규_표현식_이용
							preg_match_all($pattern_s, $content_s, $image_arr);
							list($image_arr) = $image_arr;

							#############################################
							# 끝 => 이미지_추출__배열로_받기
							#############################################



							#############################################
							# 시작 => 이미지_사용_처리__없는거_삭제하기
							#############################################

							//===========================================
							// 시작 => 이미지_배열__있으면
							IF (count($image_arr) > 0)
							{

									//=======================================
									// 전역변수
									global $image_helper_conf;


									//=======================================
									// 이미지_업로드_경로
									$image_save_upload_path = G5_DATA_URL.'/'.PIREE_IMAGE_UPLOAD_DIR;


									//=======================================
									// 시작 => 돌려라__반복문
									WHILE (list($key, $val) = each($image_arr))
									{

											//===================================
											// 시작 => 본_사이트_업로드__이미지__이면
											IF (eregi($image_save_upload_path, $val))
											{

													//===============================
													// 업로드_된__이미지__태그
													$upload_image_tag_s = $val;


													//===============================
													// 업로드_된__이미지__경로
													$upload_image_path_s = '';


													//===============================
													// 업로드_된__이미지__URL
													$upload_image_url_s = '';


													//===============================
													// 문자열_치환
													$val = str_replace("G5_DATA_URL", "{EX}G5_DATA_URL", $val);
													$val = str_replace("\\", "{EX}", $val);
													$val = str_replace("\"", "{EX}", $val);
													$val = str_replace("'", "{EX}", $val);
													$val = str_replace(" ", "{EX}", $val);


													//===============================
													// 배열_나누기
													$exs = explode("{EX}", $val);


													//===============================
													// 시작 => 돌려라__반복문
													WHILE (list($in_key, $in_val) = each($exs))
													{

															//===========================
															// 시작 => G5_DATA_URL_로__시작하면
															IF (eregi(G5_DATA_URL, $in_val))
															{

																	//=======================
																	// 업로드_된__이미지__URL
																	$upload_image_url_s = $in_val;


																	//=======================
																	// 업로드_된__이미지__경로
																	$upload_image_path_s = str_replace(G5_DATA_URL, G5_DATA_PATH, $upload_image_url_s);


																	//=======================
																	// 시작 => 이미지__유무
																	IF (file_exists($upload_image_path_s))
																	{

																			#####################
																			# 시작 => 이미지__있으면
																			#####################

																			//===================
																			// 업로드_된__이미지__경로__배열_로__나누기
																			$exs_in = explode('/', $upload_image_path_s);


																			//===================
																			// 파일이름__골라내기
																			$upload_image_file_s = trim($exs_in[count($exs_in)-1]);


																			//===================
																			// 이미지_ROW__유무__알아내기
																			$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n = '".$arti_idx_n."' AND iml_file_new_s = '".$upload_image_file_s."'";
																			$exists = sql_efv($sql);


																			//===================
																			// 시작 => 이미지_ROW__있으면
																			IF ($exists > 0)
																			{

																					//===============
																					// 이미지__본문에_사용__처리하는__쿼리문
																					$sql	= "UPDATE `".$piree_table['image_list']."` SET ";
																					$sql .= "`iml_in_cont` = '1' ";
																					$sql .= "WHERE iml_arti_idx_n = '".$arti_idx_n."' AND iml_file_new_s = '".$upload_image_file_s."'";


																					//===============
																					// 시작 => 쿼리_실행_하지__못했으면
																					IF ( !sql_query ($sql) )
																					{
																							echo "#ERROR:[".$upload_image_file_s."] 이미지의 사용상태를 새로고침하지 못했습니다.";
																							EXIT;
																					}
																					// 끝 => 쿼리_실행_하지__못했으면
																					//===============

																			}
																			// 끝 => 이미지_ROW__있으면
																			//===================

																	}
																	ELSE
																	{

																			#####################
																			# 시작 => 이미지__없으면
																			#####################

																			//===================
																			// 이미지_태그__쿼터_제거
																			// $content_s = str_replace($val, "", $content_s);


																			IF (PIREE_BUILDER_OYO_OMO == 'OYO')
																			{
																					;
																			}

																	}
																	// 끝 => 이미지__유무
																	//=======================

															}
															// 끝 => G5_DATA_URL_로__시작하면
															//===========================

													}
													// 끝 => 돌려라__반복문
													//===============================

											}
											// 끝 => 본_사이트_업로드__이미지__이면
											//===================================

									}
									// 끝 => 돌려라__반복문
									//=======================================

							}
							// 끝 => 이미지_배열__있으면
							//===========================================

							#############################################
							# 끝 => 이미지_사용_처리__없는거_삭제하기
							#############################################

					}
					// 끝 => 게시글_내용__있으면
					//===============================================

			}
			// 끝 => 게시글_자료__INDEX_번호__있으면
			//===================================================


			//===================================================
			// 글_내용__넘겨주기
			return $content_s;

	}
	#########################################################
	# 끝 => 이미지__본문에_사용_여부__새로고침_하기
	#########################################################



	#########################################################
	# 시작 => 대표_이미지__해제하기
	#########################################################
	function clear__face_image($arti_idx_n)
	{

			//===================================================
			// 시작 => 이미지_번호__있으면
			IF ($arti_idx_n > 0)
			{

					//===============================================
					// 전역_변수
					global $piree_table;


					//===============================================
					// 대표_이미지__수__알아보기
					$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n='".$arti_idx_n."' AND iml_is_face_n='1'";
					$face_img_t = sql_efv($sql);


					//===============================================
					// 시작 => 대표_이미지__수__있으면
					IF ($face_img_t > 0)
					{

							//===========================================
							// 이미지_목록__테이블__대표_이미지__해제하는__쿼리문
							$sql	= "UPDATE `".$piree_table['image_list']."` SET ";
							$sql .= "`iml_is_face_n`='0' ";
							$sql .= "WHERE iml_arti_idx_n='".$arti_idx_n."' AND iml_is_face_n='1'";


							//===========================================
							// 쿼리실행
							sql_query ($sql);

					}
					// 끝 => 대표_이미지__수__있으면
					//===============================================

			}
			// 끝 => 이미지_번호__있으면
			//===================================================

	}
	#########################################################
	# 끝 => 대표_이미지__해제하기
	#########################################################



	#########################################################
	# 시작 => 프로그램별__대표_이미지__지정하기
	#########################################################
	function update__face_image($arti_code, $arti_table, $arti_idx_n, $img_idx_n, $is_enforce)
	{

			#####################################################
			# 시작 => 검증하기
			#####################################################

			//===================================================
			// 전역_변수
			global $piree_table;


			//===================================================
			// 시작 => 게시글__종류__없으면
			IF (!$arti_code || $arti_code == "")
			{
					echo "#ERROR:필요한 게시글 구분 정보가 전달되지 않았습니다. 5";
					EXIT;
			}
			// 끝 => 게시글__종류__없으면
			//===================================================

			#####################################################
			# 끝 => 검증하기
			#####################################################



			#####################################################
			# 시작 => 기존__대표_이미지__유무__알아내기
			#####################################################

			//===================================================
			// 대표_이미지__변경__여부
			$work_fr_image_change = 1;


			//===================================================
			// 시작 => 강행__아니면
			IF ($is_enforce != 1)
			{

					//===============================================
					// 대표_이미지__수__알아보기
					$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n='".$arti_idx_n."' AND iml_is_face_n='1'";
					$exists = sql_efv($sql);


					//===============================================
					// 시작 => 대표_이미지__수__있으면
					IF ($exists > 0)
					{
							//===========================================
							// 대표_이미지__변경__여부
							$work_fr_image_change = 0;
					}
					// 끝 => 대표_이미지__수__있으면
					//===============================================

			}
			// 끝 => 강행__아니면
			//===================================================

			#####################################################
			# 끝 => 기존__대표_이미지__유무__알아내기
			#####################################################



			#####################################################
			# 시작 => 대표_이미지__변경하기
			#####################################################

			//===================================================
			// 시작 => 대표_이미지__변경_하기__이면
			IF ($work_fr_image_change == 1)
			{

					#################################################
					# 시작 => 선택된__이미지_정보
					#################################################

					//===============================================
					// 시작 => 이미지_INDEX_번호__있으면
					IF ($img_idx_n > 0)
					{

							//===========================================
							// 이미지__정보__알아내기
							$sql = "SELECT idx_n,image_n,iml_file_new_s FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n='".$arti_idx_n."' AND idx_n='".$img_idx_n."'";
							$imgrow = sql_fetch($sql);

					}
					// 끝 => 이미지_INDEX_번호__있으면
					//===============================================


					//===============================================
					// 시작 => 대표_이미지__INDEX_번호__없으면
					IF (!$imgrow['idx_n'] || $imgrow['idx_n'] == 0)
					{

							//===========================================
							// 대표_이미지__정보__알아내기
							$sql    = "SELECT idx_n,image_n,iml_file_new_s FROM `".$piree_table['image_list']."` ";
							$sql   .= "WHERE iml_arti_idx_n='".$arti_idx_n."' ORDER BY image_n ASC LIMIT 1";
							$imgrow = sql_fetch($sql);

					}
					// 끝 => 대표_이미지__INDEX_번호__없으면
					//===============================================


					//===============================================
					// 시작 => 이미지_INDEX_번호__없으면
					IF (!$imgrow['idx_n'] || $imgrow['idx_n'] == 0)
					{
							echo "#ERROR:이미지 INDEX 번호가 없어서 대표이미지를 변경할수 없습니다.";
							EXIT;
					}
					// 끝 => 이미지_INDEX_번호__없으면
					//===============================================

					#################################################
					# 끝 => 선택된__이미지_정보
					#################################################



					#################################################
					# 시작 => 이미지_목록__테이블__대표_이미지__수정하기
					#################################################

					//===============================================
					// 이미지_INDEX_번호
					$img_idx_n = $imgrow['idx_n'];


					//===============================================
					// 이미지_목록__테이블__대표_이미지__지정하는__쿼리문
					$sql	= "UPDATE `".$piree_table['image_list']."` SET ";
					$sql .= "`iml_is_face_n` = '1' ";
					$sql .= "WHERE iml_arti_idx_n='".$arti_idx_n."' AND idx_n='".$img_idx_n."'";


					//===============================================
					// 시작 => 쿼리_실행_하지__못했으면
					IF ( !sql_query ($sql) )
					{
							echo "#ERROR:이미지 목록에서 대표이미지로 지정하지 못했습니다.";
							EXIT;
					}
					// 끝 => 쿼리_실행_하지__못했으면
					//===============================================

					#################################################
					# 끝 => 이미지_목록__테이블__대표_이미지__수정하기
					#################################################



					#################################################
					# 시작 => 게시글__종류__구분
					#################################################

					//===============================================
					// 시작 => 게시글__종류__구분
					SWITCH ($arti_code)
					{

							#############################################
							# 시작 => 게시글
							#############################################
							CASE "article" :

									//=======================================
									// 테이블_이름__확인
									$arti_table = get__write_table_name($arti_table);


									//=======================================
									// 쿼리
									$sql	= "UPDATE `".$arti_table."` SET ";
									$sql .= "`wr_pi_image_face_n` = '".$imgrow['image_n']."', ";
									$sql .= "`wr_pi_image_face_s` = '".$imgrow['iml_file_new_s']."' ";
									$sql .= "WHERE `idx_n`=".$arti_idx_n;


									//=======================================
									// 시작 => 쿼리_실행_하지__못했으면
									IF ( !sql_query ($sql) )
									{
											echo "#ERROR:게시글의 대표 이미지를 지정하지 못했습니다.";
											EXIT;
									}
									// 끝 => 쿼리_실행_하지__못했으면
									//=======================================

							BREAK;
							#############################################
							# 끝 => 게시글
							#############################################

					}
					// 끝 => 게시글__종류__구분
					//===============================================

					#################################################
					# 끝 => 게시글__종류__구분
					#################################################

			}
			// 끝 => 대표_이미지__변경_하기__이면
			//===================================================

			#####################################################
			# 끝 => 대표_이미지__변경하기
			#####################################################

	}
	#########################################################
	# 끝 => 프로그램별__대표_이미지__지정하기
	#########################################################



	#########################################################
	# 시작 => 이미지_건수__새로고침__하기
	#########################################################
	function reload__article_image_info($arti_code, $arti_table, $arti_idx_n, $image_t, $image_face_n, $image_face_s)
	{

			//===================================================
			// 전역_변수
			global $g5;


			//===================================================
			// 시작 => 게시글__종류__없으면
			IF (!$arti_code || $arti_code == "")
			{
					echo "#ERROR:필요한 게시글 구분 정보가 전달되지 않았습니다. 6";
					EXIT;
			}
			// 끝 => 게시글__종류__없으면
			//===================================================


			//===================================================
			// 시작 => 이미지_건수__없으면
			IF (!$image_t || $image_t == 0)
			{

					//===============================================
					// 전역_변수
					global $piree_table;


					//===============================================
					// 이미지_건수__파악하기
					$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE `iml_arti_idx_n` = '".$arti_idx_n."'";
					$image_t = sql_efv($sql);

			}
			// 끝 => 이미지_건수__없으면
			//===================================================


			//===================================================
			// 시작 => 게시글__종류__구분
			SWITCH ($arti_code)
			{

					#################################################
					# 시작 => 게시글
					#################################################
					CASE "article" :

							//===========================================
							// 테이블_이름__확인
							$arti_table = get__write_table_name($arti_table);


							//===========================================
							// 쿼리
							$sql	= "UPDATE `".$arti_table."` SET ";
							$sql .= "`wr_pi_image_t` = '".$image_t."' ";


							//===========================================
							// 시작 => 대표_이미지_번호__있으면
							IF ($image_face_n > 0)
							{
									//=======================================
									// 쿼리
									$sql .= ", `wr_pi_image_face_n` = '".$image_face_n."'";
							}
							// 끝 => 대표_이미지_번호__있으면
							//===========================================


							//===========================================
							// 시작 => 대표_이미지_이름__있으면
							IF ($image_face_s)
							{
									//=======================================
									// 쿼리
									$sql .= ", `wr_pi_image_face_s` = '".$image_face_s."'";
							}
							// 끝 => 대표_이미지_이름__있으면
							//===========================================


							//===========================================
							// 쿼리__조건절
							$sql .= " WHERE `idx_n`=".$arti_idx_n;


							//===========================================
							// 시작 => 쿼리_실행_하지__못했으면
							IF ( !sql_query ($sql) )
							{
									echo "#ERROR:게시글의 이미지 정보를 새로고침 하지 못했습니다.";
									EXIT;
							}
							// 끝 => 쿼리_실행_하지__못했으면
							//===========================================

					BREAK;
					#################################################
					# 끝 => 게시글
					#################################################

			}
			// 끝 => 게시글__종류__구분
			//===================================================

	}
	#########################################################
	# 끝 => 이미지_건수__새로고침__하기
	#########################################################



	#########################################################
	# 시작 => 이미지__삭제하기
	#########################################################
	function delete__row_image($arti_idx_n)
	{

			//===================================================
			// 전역변수
			global $piree_table;


			#####################################################
			# 시작 => 게시글_INDEX__가져오기
			#####################################################

			//===================================================
			// 게시글_INDEX_정보__가져오기
			$idx_row = get__index_info($arti_idx_n);


			//===================================================
			// 시작 => 게시글_INDEX_정보__없으면
			IF ($arti_idx_n != $idx_row['index_n'])
			{
					alert ("게시글 INDEX 정보가 없습니다.");
			}
			// 끝 => 게시글_INDEX_정보__없으면
			//===================================================

			#####################################################
			# 끝 => 게시글_INDEX__가져오기
			#####################################################



			#####################################################
			# 시작 => 게시글_자료__가져오기
			#####################################################

			//===================================================
			// 게시글_INDEX_정보__가져오기
			$arti_row = get__article_div_info($idx_row['idx_code'], $idx_row['idx_table'], $arti_idx_n);


			//===================================================
			// 시작 => 게시글_자료_정보__없으면
			IF ($arti_idx_n != $arti_row['row_idx_n'])
			{
					alert ("자료정보가 없습니다.");
			}
			// 끝 => 게시글_자료_정보__없으면
			//===================================================

			#####################################################
			# 끝 => 게시글_자료__가져오기
			#####################################################



			#####################################################
			# 시작 => 이미지_INDEX__삭제하기
			#####################################################

			//===================================================
			// 이미지_INDEX__삭제하기
			$sql = "DELETE FROM `".$piree_table['image_list']."` WHERE `iml_arti_idx_n` = '".$arti_idx_n."'";


			//===================================================
			// 시작 => 저장하지_못했으면
			IF ( !sql_query ($sql) )
			{
					// 에러
					$msg_s = "이미지 INDEX를 삭제하지 못했습니다.";
					alert ($msg_s, "");
			}
			// 끝 => 저장하지_못했으면
			//===================================================

			#####################################################
			# 끝 => 이미지_INDEX__삭제하기
			#####################################################



			#####################################################
			# 시작 => 이미지_목록__삭제하기
			#####################################################

			//===================================================
			// 이미지_목록__가져오기
			$image_list = get__image_list($arti_idx_n, 0, 0);


			//===================================================
			// 시작 => 이미지_목록__있으면
			IF ($image_list['count'] > 0)
			{

					#################################################
					# 시작 => 이미지_파일__삭제하기
					#################################################

					//===============================================
					// 시작 => 돌려라__반복문
					WHILE (list($key, $val) = each($image_list))
					{

							//===========================================
							// 시작 => 이미지_번호__있으면
							IF ($val['image_n'] > 0)
							{

									#########################################
									# 시작 => 원본__이미지_파일__삭제하기
									#########################################

									//=======================================
									// 이미지_파일_이름
									$image_path_s = $val['dir_path'].$val['file_s'];


									//=======================================
									// 원본__이미지_파일__삭제하기
									unlink ($image_path_s);

									#########################################
									# 끝 => 원본__이미지_파일__삭제하기
									#########################################


									#########################################
									# 시작 => THUMBNAIL__이미지_파일__삭제하기
									#########################################

									//=======================================
									// THUMBNAIL__이미지_파일
									$image_thumbnail_s = 'thumb-'.substr($val['file_s'], 0, strpos($val['file_s'], '.')).'*';


									//=======================================
									// 파일_목록
									$files = glob($val['dir_path'].$image_thumbnail_s);


									//=======================================
									// 시작 => 배열__이면
									IF (is_array($files))
									{

											//===================================
											// 시작 => 돌려라__반복문
									    FOREACH($files AS $thumbnail)
									    {
													//===============================
													// THUMBNAIL__이미지_파일__삭제하기
									        @unlink($thumbnail);
									    }
											// 끝 => 돌려라__반복문
											//===================================

									}
									// 끝 => 배열__이면
									//=======================================

									#########################################
									# 끝 => THUMBNAIL__이미지_파일__삭제하기
									#########################################

							}
							// 끝 => 이미지_번호__있으면
							//===========================================

					}
					// 끝 => 돌려라__반복문
					//===============================================

					#################################################
					# 시작 => 이미지_파일__삭제하기
					#################################################



					#################################################
					# 시작 => 이미지_목록_ROW__삭제하기
					#################################################

					//===============================================
					// 이미지_INDEX__삭제하기
					$sql = "DELETE FROM `".$image_list['image_list_table']."` WHERE `iml_arti_idx_n` = '".$arti_idx_n."'";


					//===============================================
					// 시작 => 저장하지_못했으면
					IF ( !sql_query ($sql) )
					{
							// 에러
							$msg_s = "이미지 목록을 삭제하지 못했습니다.";
							alert ($msg_s, "");
					}
					// 끝 => 저장하지_못했으면
					//===============================================

					#################################################
					# 시작 => 이미지_목록_ROW__삭제하기
					#################################################

			}
			// 끝 => 이미지_목록__있으면
			//===================================================

			#####################################################
			# 끝 => 이미지_목록__삭제하기
			#####################################################

	}
	#########################################################
	# 끝 => 이미지__삭제하기
	#########################################################



	#########################################################
	# 시작 => 그누보드_게시글__이미지__삭제하기
	#########################################################
	function delete__article_image($arti_idx_n)
	{

			//===================================================
			// 전역변수
			global $piree_table;


			//===================================================
			// 시작 => 게시글_번호__있으면
			IF ($arti_idx_n > 0)
			{

					//===============================================
					// 이미지_건수__파악하기
					$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n = '".$arti_idx_n."'";
					$image_t = sql_efv($sql);


					//===============================================
					// 시작 => 이미지__있으면
					IF ($image_t > 0)
					{

							#############################################
							# 시작 => 이미지__파일__삭제
							#############################################

							//===========================================
							// 이미지_목록__가져오기
							// $sql = "SELECT * FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n = '".$arti_idx_n."'";
							$sql = "SELECT image_n,iml_file_new_s FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n = '".$arti_idx_n."'";
							$result = sql_query ($sql);

							//===========================================
							// 시작 => 돌려라__반복문
							WHILE ($row = sql_fetch_array($result))
							{

									#########################################
									# 시작 => 이미지__파일__삭제
									#########################################

									//=======================================
									// 이미지__경로__불러오기
									$image_path_s = get__image_path($row['image_n']);


									//=======================================
									// 시작 => 이미지__경로__있으면
									IF ($image_path_s)
									{

											//===================================
											// 원본_파일__이름
											$original_file_s = $image_path_s .'/'.$row['iml_file_new_s'];


											//===================================
											// 시작 => 원본_파일__있으면
											IF (file_exists($original_file_s))
											{

													//===============================
													// 원본_파일__삭제하기
													unlink ($original_file_s);

											}
											// 끝 => 원본_파일__있으면
											//===================================


											//===================================
											// THUMNAIL_파일__이름
											$thumnail_file_s = 'thumb-12_1';


											//===================================
											// THUMNAIL_파일__삭제
											appoint_file_delete($image_path_s, $thumnail_file_s);

									}
									// 끝 => 이미지__경로__있으면
									//=======================================

									#########################################
									# 끝 => 이미지__파일__삭제
									#########################################

							}
							// 끝 => 돌려라__반복문
							//===========================================

							#############################################
							# 끝 => 이미지__파일__삭제
							#############################################



							#############################################
							# 시작 => DB__삭제
							#############################################

							//===========================================
							// 삭제하는__쿼리문
							$sql = "DELETE FROM `".$piree_table['image_list']."` WHERE iml_arti_idx_n = '".$arti_idx_n."'";


							//===========================================
							// 시작 => 쿼리_실행_하지__못했으면
							IF ( !sql_query ($sql) )
							{
									alert ("등록된 이미지 DB를 삭제하지 못했습니다.");
									EXIT;
							}
							// 끝 => 쿼리_실행_하지__못했으면
							//===========================================

							#############################################
							# 끝 => DB__삭제
							#############################################

					}
					// 끝 => 이미지__있으면
					//===============================================


					//===============================================
					// 이미지_현황__새로고침_하기
					reload__image_status();

			}
			// 끝 => 게시글_번호__있으면
			//===================================================

	}
	#########################################################
	# 끝 => 그누보드_게시글__이미지__삭제하기
	#########################################################



	#########################################################
	# 시작 => 이미지_썸네일__삭제
	#########################################################
	function delete__thumbnail($dir, $file)
	{

		if(!$dir || !$file)
				return;

		$filename = preg_replace("/\.[^\.]+$/i", "", $file); // 확장자제거

		$files = glob($dir.'/thumb-'.$filename.'*');

		if(is_array($files)) {
				foreach($files as $thumb_file) {
						@unlink($thumb_file);
				}
		}

	}
	#########################################################
	# 끝 => 이미지_썸네일__삭제
	#########################################################



	#########################################################
	# 시작 => 게시글_수__알아내기
	#########################################################
	function get__article_image_status($arti_index_n)
	{

			//===================================================
			// 전역_변수
			global $piree_table;


			//===================================================
			// 이미지__정보__배열
			$image_row;


			//===================================================
			// 대표_이미지__알아내는__쿼리문
			$sql_face_s = "SELECT image_n,iml_file_new_s FROM `".$piree_table['image_list']."` WHERE `iml_arti_idx_n` = '".$arti_index_n."'";


			//===================================================
			// 이미지_수__알아내기
			$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."` WHERE `iml_arti_idx_n` = '".$arti_index_n."'";
			$image_total = sql_efv($sql);
			$image_row['image_t'] = (int)$image_total;


			//===================================================
			// 대표_이미지__알아내기
			$sql = $sql_face_s." AND `iml_is_face_n` = '1'";
			$fr_row = sql_fetch($sql);


			//===================================================
			// 시작 => 대표_이미지__없으면
			IF (!$fr_row['image_n'] || $fr_row['image_n'] < 1)
			{

					//===============================================
					// 대표_이미지__알아내기
					$sql = $sql_face_s." ORDER BY image_n ASC LIMIT 1";
					$fr_row = sql_fetch($sql);

			}
			// 끝 => 대표_이미지__없으면
			//===================================================


			//===================================================
			// 시작 => 대표_이미지__있으면
			IF ($fr_row['image_n'] > 0)
			{

					// 대표_이미지__번호
					$image_row['face_image_n'] = (int)$fr_row['image_n'];

					// 대표_이미지__파일_이름
					$image_row['face_image_s'] = $fr_row['iml_file_new_s'];

			}
			// 끝 => 대표_이미지__있으면
			//===================================================


			//===================================================
			// 이미지__정보__배열
			return $image_row;

	}
	#########################################################
	# 끝 => 게시글_수__알아내기
	#########################################################



	#########################################################
	# 시작 => 이미지_현황__새로고침_하기
	#########################################################
	function reload__image_status()
	{

			#####################################################
			# 시작 => 전역_변수__이미지_현황__알아내기
			#####################################################

			//===================================================
			// 전역_변수
			global $piree_table, $imli_cash_path_1;


			//===================================================
			// 이미지_수__파악하기
			$sql = "SELECT COUNT(*) FROM `".$piree_table['image_list']."`";
			$image_total = sql_efv($sql);


			//===================================================
			// 이미지__최대_번호__파악하기
			$sql = "SELECT MAX(`image_n`) FROM `".$piree_table['image_list']."`";
			$image_max_n = sql_efv($sql);


			//===================================================
			// 형변환
			$image_total = (int)$image_total;
			$image_max_n = (int)$image_max_n;

			#####################################################
			# 끝 => 전역_변수__이미지_현황__알아내기
			#####################################################



			#####################################################
			# 시작 => 프로그램_정보__수정하기
			#####################################################

					#################################################
					# 시작 => 저장할__쿼리문
					#################################################

					//===============================================
					// 이미지__건수
					$sql_save .= "pcf_9_n = '".$image_total."', ";


					//===============================================
					// 이미지__최대_번호
					$sql_save .= "pcf_10_n = '".$image_max_n."', ";


					//===============================================
					// 최근_변경_일시
					$sql_save .= "pcf_13_n = '".G5_SERVER_TIME."', ";

					#################################################
					# 끝 => 저장할__쿼리문
					#################################################



					#################################################
					# 시작 => 설정__저장하기
					#################################################

					//===============================================
					// 수정하는__쿼리
					$sql  = "UPDATE `".$piree_table['program_new']."` SET ";
					$sql .= $sql_save;
					$sql .= "modi_time_n='".G5_SERVER_TIME."' ";
					$sql .= "WHERE `prog_n`=".PIREE_PLUS_IMAGE_HELPER_PROG_N;


					//===============================================
					// 시작 => 쿼리_실행
					IF ( !sql_query ($sql) )
					{

							// 에러_메세지
							$save_err_msg = "INDEX 관리 설정 정보를 수정하지 못했습니다. 11 - 11";

							// 에러
							alert ($save_err_msg, $go_url_s);
							EXIT;

					}
					// 끝 => 쿼리_실행
					//===============================================

					#################################################
					# 끝 => 설정__저장하기
					#################################################

			#####################################################
			# 끝 => 프로그램_정보__수정하기
			#####################################################



			#####################################################
			# 시작 => 디렉토리__날리기
			#####################################################

			//===================================================
			// 디렉토리__날리기
			exec("rm -rf ".$imli_cash_path_1);

			#####################################################
			# 끝 => 디렉토리__날리기
			#####################################################

	}
	#########################################################
	# 끝 => 이미지_현황__새로고침_하기
	#########################################################


?>