<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 01월 13일 월요일 오전 03시 15분 - 날씨 춥다 추워

	업데이트 작업날짜 : 2015년 01월 10일 토요일 오후 20시 37분 - 날씨 저녁, 밤 되니 추워

	Ver 1.0 작업날짜 : 2015년 04월 16일 목요일 오전 02시 28분 - 날씨 맑음

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 피리 레벨 도우미 PLUS G5 > 스킨
===========================================================


*/


	//=======================================================
	// 개별_페이지__접근_불가
	IF (!defined("_GNUBOARD_"))										EXIT;


	//=======================================================
	// ADD_STYLESHEET('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
	add_stylesheet('<link rel="stylesheet" href="'.$PCF_MEMFUNC_skin_pc_u.'/p770021__style.css">', 16);

?>

<!-- 시작 => 내가__몸통이다 -->

<section>
		<h2>레벨 변경 신청하기 >> 현재 레벨 <?php echo $mb_level_n; ?> ( <?php echo $mb_level_s; ?> )</h2>

		<form name="level_update_form" id="level_update_form" action="<?php echo $action_url; ?>" onsubmit="return level_list_submit(this);" method="post">
		<input type="hidden" name="level_choice_n" value="0">

		<div class="tbl_head01 tbl_wrap">
				<table>
				<caption style="height:20px;">레벨 변경 신청하기</caption>
				<thead>
				<tr>
						<th scope="col">레벨</th>
						<th scope="col">레벨 이름</th>
						<th scope="col">기준 포인트</th>
						<th scope="col">차감 포인트</th>
						<th scope="col">즉시여부</th>
						<th scope="col">가입후</th>
						<th scope="col">신청하기</th>
						<th scope="col">비고</th>
				</tr>
				</thead>
				<tbody>

<?php

	//=======================================================
	// 시작 => 레벨__설정_정보__유무
	IF ($level_config_t > 0)
	{

		#######################################################
		# 시작 => 레벨__설정_정보__있으면
		#######################################################

		//=====================================================
		// 시작 => 돌려라__반복문
		WHILE (list($key, $val) = each($level_info_arr))
		{

			//===================================================
			// 시작 => 관리자__아니면
			IF ($val["is_admin_n"] == 0)
			{

				//=================================================
				// 레벨_번호
				$level_n = $val["level_n"];


				//=================================================
				// 기준_포인트_점수
				$point_fm = number_format($val["point_n"]);


				//=================================================
				// 차감할_포인트_점수
				$point_pay_fm = $val["point_pay_n"] > 0 ? number_format($val["point_pay_n"]) : "";


				//=================================================
				// 즉시_레벨_업__여부
				$use_auto_s = $val["use_auto_n"] == 1 ? "즉시" : "<span style=\"color:#0000ff\">수동</span>";


				//=================================================
				// 가입후_몇일_지나야_하니?
				$day_join_fm = number_format($val["day_join_n"]);


				//=================================================
				// 레벨_업신청__가능_여부__확인하기
				$level_check_result = check__level_up_request($level_n, $val["point_pay_n"], $val["day_join_n"]);

?>
				<tr>
						<td align="center"><strong><?php echo $level_n ?></strong></td>
						<td><strong><?php echo $val["level_s"] ?></strong></td>
						<td align="right"><?php echo $point_fm ?> 점</td>
						<td align="right"><?php echo $point_pay_fm ?> 점</td>
						<td align="center"><?php echo $use_auto_s ?></td>
						<td align="center"><?php echo $day_join_fm ?> 일</td>
<?php

				//=================================================
				// 시작 => 내부_에러__여부
				IF ($level_check_result['errors'] == 0)
				{

						###############################################
						# 시작 => 레벨_신청할수__있으면
						###############################################
?>
						<td align="center"><input type="button" value="신청하기" onClick="level_request_form(this.form, <?php echo $level_n ?>, '<?php echo $point_pay_fm ?>');" class="btn_submit"></td>
<?php
				}
				ELSE
				{

						###############################################
						# 시작 => 레벨_신청할수__못하면
						###############################################

?>
						<td class="no_use">신청불가</td>
<?php
				}
				// 끝 => 내부_에러__여부
				//=================================================

?>
						<td><span class="font_ff4444"><?php echo $level_check_result['short_msg_s'] ?></span></td>
				</tr>

<?php
			}
			// 끝 => 관리자__아니면
			//===================================================

		}
		// 끝 => 돌려라__반복문
		//=====================================================

		#######################################################
		# 끝 => 레벨__설정_정보__있으면
		#######################################################

	}
	ELSE
	{

		#######################################################
		# 시작 => 레벨__설정_정보__없으면
		#######################################################

?>
				<tr>
					<td colspan="9">
						<strong>현재 레벨 정보가 없습니다.</strong>
					</td>
				</tr>

<?php

		#######################################################
		# 끝 => 레벨__설정_정보__없으면
		#######################################################

	}
	// 끝 => 레벨__설정_정보__유무
	//=======================================================

?>

				</tbody>
				</table>
		</div>

		</form>

<?php

	//=======================================================
	// 시작 => 관리자__이면
	IF ($is_admin)
	{
?>
			<a href="<?php echo G5_ADMIN_URL; ?>/p770021__member_func/level_helper__index.php" class="btn_admin">관리자</a>

			<br style="clear:both;" /><br style="clear:both;" />

<?php
	}
?>


		<div style="margin:0 0 10px 0;padding:10px 0 10px 10px; border:1px solid #c3c6ca; background:#fff;">
			<div class="btn_confirm" style="text-align:left; line-height:2.2em;">
				⊙ 원하시는 레벨로 <span style="color:#0000ff">신청하기</span> 버튼을 눌러 주세요.
				<br />
				. <span style="color:#0000ff">신청할수 없는 경우</span> 비고와 메세지를 참고해 주세요.
				<br />
				. <span style="color:#0000ff">기준 포인트</span> 는 그 포인트 점수만큼 보유해야 레벨업 할수 있습니다.
				<br />
				. <span style="color:#0000ff">차감 포인트</span> 는 그 레벨로 변경 성공할 경우 차감(마이너스) 되는 포인트 점수입니다.
			</div>
		</div>

</section>

<!-- 끝 => 내가__몸통이다 -->


	<script>
	function level_request_form(gform, level_n, point_pay_fm)
	{

		//=====================================================
		// FORM__레벨_값_필드__초기화
		gform.level_choice_n.value = 0;


		//=====================================================
		// 시작 => 레벨__있으면
		if (level_n > 0)
		{

			//===================================================
			// 확인_메세지
			var confirm_msg = "정말로 레벨 변경 신청하시겠습니까??";


			//===================================================
			// 시작 => 확인_메세지__차감_포인트__있으면
			if (point_pay_fm != "")
			{
				confirm_msg += "\n\n";
				confirm_msg += " ( 레벨 "+level_n+" (으)로 변경 성공하면 포인트	[ "+point_pay_fm+" 점 ] 이 차감됩니다. )";
			}
			// 시작 => 확인_메세지__차감_포인트__있으면
			//===================================================


			//===================================================
			// 시작 => 확인
			if (confirm(confirm_msg) == true)
			{

				//=================================================
				// FORM__레벨_값_필드__값__지정
				gform.level_choice_n.value = level_n;


				//=================================================
				// FORM_처리
				gform.submit();

			}
			// 시작 => 확인
			//===================================================

		}
		// 시작 => 레벨__있으면
		//=====================================================

	}
	</script>