<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 01월 28일 화요일 오후 13시 37분, 날씨 맑고 겨울치곤 포근한 편이다.

	Ver 1.0 작업날짜 : 2015년 04월 26일 일요일 오전 02시 43분 - 날씨 맑음

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 피리 출석체크 PLUS G5 > 나의 출석부 보기
===========================================================


*/


	#########################################################
	# 시작 => 라이브러리__파일__첨부____선처리
	#########################################################

	//=======================================================
	// 라이브러리__첨부
	include_once ('./_common.php');


	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
			alert ("회원만 이용하실 수 있습니다", G5_DOMAIN.'/');
			EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================

	#########################################################
	# 끝 => 라이브러리__파일__첨부____선처리
	#########################################################



	#########################################################
	# 시작 => QUERY_STRING
	#########################################################

	//=======================================================
	// QUERY_STRING
	$year_n		= $_GET["year_n"];
	$month_n	= $_GET["month_n"];


	//=======================================================
	// 형변환
	settype($year_n,	"integer");
	settype($month_n, "integer");

	#########################################################
	# 끝 => QUERY_STRING
	#########################################################



	#########################################################
	# 시작 => 라이브러리__첨부
	#########################################################

	//=======================================================
	// 날짜_관련__라이브러리_파일__첨부
	include_once ("../_config/_piree/lib.date.php");

	#########################################################
	# 끝 => 라이브러리__첨부
	#########################################################



	#########################################################
	# 시작 => 상수__변수
	#########################################################

	//=======================================================
	// 시작 => 년도__없으면
	IF (!$year_n || $year_n < 1)
	{
		$year_n = (int)date("Y");
	}
	// 끝 => 년도__없으면
	//=======================================================


	//=======================================================
	// 시작 => 월__없으면
	IF (!$month_n || $month_n < 1)
	{
		$month_n = (int)date("m");
	}
	// 끝 => 월__없으면
	//=======================================================


	//=======================================================
	// 시작 => 일__없으면
	IF (!$day_n || $day_n < 1)
	{
		$day_n = (int)date("d");
	}
	// 끝 => 일__없으면
	//=======================================================


	//=======================================================
	// 월_다듬기
	$month_s = (int)$month_n > 9 ? $month_n : "0".$month_n;


	//=======================================================
	// 일_다듬기
	$day_s = (int)$day_n > 9 ? $day_n : "0".$day_n;


	//=======================================================
	// 이달__년_월
	$date_Ym_s = $year_n."-".$month_s;
	$date_Ym_n = str_replace("-", "", $date_Ym_s);


	//=======================================================
	// 이달_시작_일
	$month_start_n = $year_n.$month_s."00";
	settype($month_start_n, "integer");


	//=======================================================
	// 이달_마지막_일
	$month_last_n = $month_start_n+33;


	//=======================================================
	// 이전_다음__년도_월__알아내기
	$date_arr = get__year_month__before_next($year_n, $month_n);


	//=======================================================
	// 마지막날
	$last_day_n = date("t", strtotime($year_n."-".$month_s."-01 01:01:01"));


	//=======================================================
	// 1일_요일
	$yoil_n = date("w", $month_start_n);


	//=======================================================
	// 오늘날짜
	$today_n = date("Ymd");

	#########################################################
	# 끝 => 상수__변수
	#########################################################



	#########################################################
	# 시작 => 이달__나의_출석체크_건수__파악하기
	#########################################################

	//=======================================================
	// 쿼리문_조건절
	$sql_wh_s = "mb_id='".$_SESSION['ss_mb_id']."' AND date_n BETWEEN ".$month_start_n." AND ".$month_last_n;


	//=======================================================
	// 이달__나의_출석체크_건수__파악하기
	$sql	= "SELECT COUNT(*) AS total FROM `".$piree_table['attend_list']."` ";
	$sql .= "WHERE ".$sql_wh_s;
	$row	= sql_fetch($sql);


	//=======================================================
	// 이달__나의_출석체크_건수
	$my_attend_t = $row["total"];

	#########################################################
	# 끝 => 이달__나의_출석체크_건수__파악하기
	#########################################################



	#########################################################
	# 시작 => 출석체크_목록__불러오기
	#########################################################

	//=======================================================
	// 시작 => 출석체크_목록__있으면
	IF ($my_attend_t > 0)
	{

		#######################################################
		# 시작 => 출석체크_목록__불러오기
		#######################################################

		//=====================================================
		// 출석체크_목록__불러오기
		$sql		= "SELECT date_n,seq_n,conti_n,cont_s,regi_time_n FROM `".$piree_table['attend_list']."` ";
		$sql	 .= "WHERE ".$sql_wh_s." ORDER BY date_n ASC";
		$result = sql_query ($sql);


		//=====================================================
		// 시작 => 돌려라__반복문
		WHILE ($row = sql_fetch_array($result))
		{

			//===================================================
			// 날짜
			$day_n = $row["date_n"]-$month_start_n;
			$day_n = (int)$day_n;


			//===================================================
			// 등수
			$attend_list_arr[$day_n]["seq_n"] = $row["seq_n"];


			//===================================================
			// 연속_출석_일수
			$attend_list_arr[$day_n]["conti_n"] = $row["conti_n"];


			//===================================================
			// 한마디
			$attend_list_arr[$day_n]["cont_s"] = stripslashes($row["cont_s"]);


			//===================================================
			// 시간
			$attend_list_arr[$day_n]["regi_time_n"] = $row["regi_time_n"];

		}
		// 끝 => 돌려라__반복문
		//=====================================================

		#######################################################
		# 끝 => 출석체크_목록__불러오기
		#######################################################

	}
	// 끝 => 출석체크_목록__있으면
	//=======================================================

	#########################################################
	# 끝 => 출석체크_목록__불러오기
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// 타이틀
	$g5['title'] = "피리 출석체크 PLUS G5";


	//=======================================================
	// HEAD_첨부
	include_once ("./_head.php");


	//=======================================================
	// 시작 => DEVIDE__구분
	IF (G5_IS_MOBILE == 1)
	{

			#####################################################
			# 시작 => DEVIDE__모바일__이름

			//===================================================
			// 스킨__PATH
			$skin_device_p = $PCF_MEMFUNC_skin_mobile_p;

	}
	ELSE
	{

			#####################################################
			# 시작 => DEVIDE__PC__이면

			//===================================================
			// 스킨__PATH
			$skin_device_p = $PCF_MEMFUNC_skin_pc_p;

	}
	// 끝 => DEVIDE__구분
	//=======================================================


	//=======================================================
	// 스킨__PATH_첨부
	include_once ($skin_device_p .'/attend__my_list.skin.php');


	//=======================================================
	// BOTTOM_첨부
	include_once ("./_tail.php");

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>