<?php

/*
===========================================================

	프로젝트 이름 : Piree Web Program

	만든사람 : 피리 PIREE

	홈페이지 : http://www.piree.co.kr

	작성날짜 : 2014년 12월 22일 월요일 오후 14시 36분 - 날씨 기온이 조금 올랐다

	Ver 1.0 편입 시작 작성날짜 : 2015년 04월 28일 화요일 오전 01시 00분 - 날씨 맑음

	저 작 권 : Copyright ⓒ 2014-2015 투스포츠 (원병철) All right reserved
							그누보드 외에 추가된 소스는~
							만든사람의 허락없이 무단으로 사용할수 없습니다.
							사용하고자 할 경우 만든사람의 허락을 받아야 합니다.
							http://www.piree.co.kr 에 문의해 주세요.

===========================================================
 피리 > 피리 마이페이지 PLUS G5 > 스크랩 보기
===========================================================


*/


	#########################################################
	# 시작 => 라이브러리__파일__첨부____선처리
	#########################################################

	//=======================================================
	// 라이브러리__첨부
	include_once ('./_common.php');


	//=======================================================
	// 시작 => 회원_여부__확인
	IF ($is_guest || !$is_member)
	{
			alert ("회원만 이용하실 수 있습니다", G5_DOMAIN."/");
			EXIT;
	}
	// 끝 => 회원_여부__확인
	//=======================================================

	#########################################################
	# 끝 => 라이브러리__파일__첨부____선처리
	#########################################################



	#########################################################
	# 시작 => 회원정보__불러오기
	#########################################################

	//=======================================================
	// 회원_아이디
	$myp_mb_id = $member['mb_id'];


	//=======================================================
	// 회원정보
	$myp_member = $member;

	#########################################################
	# 끝 => 회원정보__불러오기
	#########################################################



	#########################################################
	# 시작 => 내__회원__정보
	#########################################################

	//=======================================================
	// 회원_번호
	$top_info_member_mn = $member['mb_no'];


	//=======================================================
	// 회원_닉네임
	$top_info_member_nick = get_text($member['mb_nick']);


	//=======================================================
	// 회원_레벨
	$top_info_member_level = $member['mb_level'];


	//=======================================================
	// 시작 => 회원_가입일__유무
	IF ($member['mb_datetime'])
	{
			$top_info_member_join_date = date("Y년 m월 d일", strtotime($member['mb_datetime']));
	}
	ELSE
	{
			$top_info_member_join_date = "";
	}
	// 끝 => 회원_가입일__유무
	//=======================================================


	//=======================================================
	// 회원_아이콘__PATH
	$member_icon_path = G5_DATA_PATH.'/member/'.substr($myp_mb_id, 0, 2).'/'.$myp_mb_id.'.gif';


	//=======================================================
	// 회원_아이콘__URL
	$member_icon_url	= G5_DATA_URL.'/member/'.substr($myp_mb_id, 0, 2).'/'.$myp_mb_id.'.gif';

	#########################################################
	# 끝 => 내__회원__정보
	#########################################################



	#########################################################
	# 시작 => 상수__변수
	#########################################################

	//=======================================================
	// 페이지_타이틀
	$g5['title'] = '"'.$top_info_member_nick.'" 님 마이페이지';


	//=======================================================
	// 피리_회원_기능_모음__메뉴
	$piree_my_page_menu_c = 'my_scrap';


	//=======================================================
	// 피리_회원_기능_모음__메뉴__권한__배열
	$myp_info_arr = get__array_value($piree_my_page_gnu_menu_arr, 'code_all', $piree_my_page_menu_c);


	//=======================================================
	// 피리_회원_기능_모음__메뉴__권한__배열
	$myp_auth = $myp_info_arr['view_auth'];

	#########################################################
	# 끝 => 상수__변수
	#########################################################



	#########################################################
	# 시작 => 스크랩_목록__가져오기
	#########################################################

			#####################################################
			# 시작 => QUERY_STRING
			#####################################################

			//===================================================
			// QUERY_STRING
			$page	= trim($_GET["page"]);

			#####################################################
			# 끝 => QUERY_STRING
			#####################################################



			#####################################################
			# 시작 => 쿼리문
			#####################################################

			//===================================================
			// 쿼리문__테이블_조건절
			$sql_common = "FROM `".$g5['scrap_table']."` WHERE mb_id = '".$member['mb_id']."'";


			//===================================================
			// 쿼리문__정렬
			$sql_order = "ORDER BY ms_id DESC";

			#####################################################
			# 끝 => 쿼리문
			#####################################################



			#####################################################
			# 시작 => 쿼리문____스크랩_수__파악하기
			#####################################################

			//===================================================
			// 스크랩_수__파악하기
			$sql = "SELECT COUNT(*) ".$sql_common;
			$total = sql_efv($sql);

			#####################################################
			# 끝 => 쿼리문____스크랩_거래_수__파악하기
			#####################################################



			#####################################################
			# 시작 => 스크랩_목록__가져오기
			#####################################################

			//===================================================
			// 시작 => 스크랩__있으면
			IF ($total > 0)
			{

					#################################################
					# 시작 => 페이지__분할
					#################################################

					//===============================================
					// 한_화면_ROW_수
					$rows = $config['cf_page_rows'];


					//===============================================
					// 전체_페이지_계산
					$total_page	= ceil($total / $rows);


					//===============================================
					// 페이지_없으면__첫_페이지____1_페이지
					IF (!$page)																	$page = 1;


					//===============================================
					// 시작__지점__알아내기
					$from_record = ($page - 1) * $rows;


					//===============================================
					// 스크랩__링크
					$this_page_link = get__member_mypage_url('', 'my_scrap')."&amp;page_mem=".$page_mem."&amp;page=";


					//===============================================
					// 페이지_분할__링크
					$write_pages = get_paging(G5_IS_MOBILE ? $config['cf_mobile_pages'] : $config['cf_write_pages'], $page, $total_page, $this_page_link);

					#################################################
					# 끝 => 페이지__분할
					#################################################



					#################################################
					# 시작 => 스크랩_목록__가져오기
					#################################################

					//===============================================
					// 스크랩_목록__저장__배열
					$list = array();


					//===============================================
					// 스크랩_목록__가져오기
					$sql  = "SELECT * ".$sql_common." ".$sql_order." LIMIT ".$from_record.", ".$rows;
					$result = sql_query ($sql);


					//===============================================
					// 시작 => 돌려라__반복문
					FOR ($i=0; $row=sql_fetch_array($result); $i++)
					{

							//===========================================
							// 배열__복사
							$list[$i] = $row;


							//===========================================
							// 순차적인_번호__순번
							$num = $total - ($page - 1) * $rows - $i;


							//===========================================
							// 게시판_이름__가져오기
							$sql2 = "SELECT bo_subject,bo_mobile_subject FROM `".$g5['board_table']."` WHERE bo_table = '".$row['bo_table']."'";
							$row2 = sql_fetch($sql2);


							//===========================================
							// 시작 => 게시판_이름__없으면
							IF (!$row2['bo_subject'])
							{
									//=======================================
									// 게시판_이름
									$row2['bo_subject'] = '[게시판 없음]';
							}
							// 끝 => 게시판_이름__없으면
							//===========================================


							//===========================================
							// 게시판_테이블
							$tmp_write_table = $g5['write_prefix'] . $row['bo_table'];


							//===========================================
							// 게시글_제목__가져오기
							$sql3 = "SELECT wr_subject FROM `".$tmp_write_table."` WHERE wr_id = '".$row['wr_id']."'";
							$row3 = sql_fetch($sql3, FALSE);


							//===========================================
							// 시작 => 게시글_제목__유무
							IF ($row3['wr_subject'])
							{

									#########################################
									# 시작 => 게시글_제목__있다

									//=======================================
									// 게시판_이름
									$subject = get_text(cut_str($row3['wr_subject'], 100));

							}
							ELSE
							{

									#########################################
									# 시작 => 게시글_제목__없다

									//=======================================
									// 게시판_이름
									$subject = '제목 없음 (정보없음)';

							}
							// 끝 => 게시글_제목__유무
							//===========================================


							//===========================================
							// 스크랩_번호
							$list[$i]['num'] = $num;


							//===========================================
							// 게시판__링크
							$list[$i]['opener_href'] = G5_BBS_URL.'/board.php?bo_table='.$row['bo_table'];


							//===========================================
							// 게시글__링크
							$list[$i]['opener_href_wr_id'] = $list[$i]['opener_href'].'&amp;wr_id='.$row['wr_id'];


							//===========================================
							// 게시판__이름
							$list[$i]['bo_subject'] = G5_IS_MOBILE ? $row2['bo_mobile_subject'] : $row2['bo_subject'];


							//===========================================
							// 게시글__제목
							$list[$i]['subject'] = $subject;


							//===========================================
							// 삭제__링크
							$list[$i]['del_href'] = 'mpage__my_scrap_delete.php?ms_id='.$row['ms_id'].'&amp;page='.$page;

					}
					// 끝 => 돌려라__반복문
					//===============================================

					#################################################
					# 끝 => 스크랩_목록__가져오기
					#################################################

			}
			// 끝 => 스크랩__있으면
			//===================================================

			#####################################################
			# 끝 => 스크랩_목록__가져오기
			#####################################################

	#########################################################
	# 끝 => 스크랩__가져오기
	#########################################################



	#########################################################
	# 시작 => 마무리__페이지_ECHO_관련
	#########################################################

	//=======================================================
	// HEAD_첨부
	include_once ("./_head.php");


	//=======================================================
	// 시작 => DEVIDE__구분
	IF (G5_IS_MOBILE == 1)
	{

		#######################################################
		# 시작 => DEVIDE__모바일__이름

		//=====================================================
		// 스킨__PATH
		$menu_path_s = $PCF_MEMFUNC_skin_mobile_p."/mpage__top_menu.skin.php";


		//=====================================================
		// 스킨__PATH
		$skin_path_s = $PCF_MEMFUNC_skin_mobile_p."/mpage__my_scrap.skin.php";

	}
	ELSE
	{

		#######################################################
		# 시작 => DEVIDE__PC__이면

		//=====================================================
		// 스킨__PATH
		$menu_path_s = $PCF_MEMFUNC_skin_pc_p."/mpage__top_menu.skin.php";


		//=====================================================
		// 스킨__PATH
		$skin_path_s = $PCF_MEMFUNC_skin_pc_p."/mpage__my_scrap.skin.php";

	}
	// 끝 => DEVIDE__구분
	//=======================================================


	//=======================================================
	// 탑_메뉴_스킨_파일__첨부
	include_once ($menu_path_s);


	//=======================================================
	// 주_스킨_파일__첨부
	include_once ($skin_path_s);


	//=======================================================
	// BOTTOM_첨부
	include_once ("./_tail.php");

	#########################################################
	# 끝 => 마무리__페이지_ECHO_관련
	#########################################################


?>