
CREATE TABLE IF NOT EXISTS `senselog` (
  `no` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` varchar(40) NOT NULL,
  `ontime` int(10) unsigned DEFAULT NULL,
  `format` varchar(15) DEFAULT NULL,
  `channel` varchar(40) DEFAULT NULL,
  `cbg` varchar(6) DEFAULT NULL,
  `ctext` varchar(6) DEFAULT NULL,
  `clink` varchar(6) DEFAULT NULL,
  `curl` varchar(6) DEFAULT NULL,
  `cborder` varchar(6) DEFAULT NULL,
  `adtype` varchar(15) DEFAULT NULL,
  `uip` varchar(16) DEFAULT NULL,
  `adurl` varchar(50) DEFAULT NULL,
  `refurl` varchar(200) DEFAULT NULL,
  `pageurl` varchar(250) DEFAULT NULL,
  `agent` varchar(200) DEFAULT NULL,
  `posx` smallint(4) unsigned NOT NULL DEFAULT '0',
  `posy` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`no`),
  KEY `senselog_index_page` (`pageurl`),
  KEY `senselog_index_ip` (`uip`),
  KEY `sense_index` (`ontime`,`id`,`uip`)
) ENGINE=MyISAM  DEFAULT CHARSET=euckr AUTO_INCREMENT=1 ;

--
-- 테이블 구조 `sensedate`
--

CREATE TABLE IF NOT EXISTS `sensedate` (
  `no` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ondate` int(10) unsigned NOT NULL,
  `ip` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`no`),
  KEY `sensedate_index_ip` (`ip`),
  KEY `sensedate_index_date` (`ondate`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;


--
-- 테이블 구조 `sense_channel`
--

CREATE TABLE IF NOT EXISTS `sense_channel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `channel` varchar(45) COLLATE latin1_general_ci DEFAULT NULL COMMENT 'YYMMDDHH 형식',
  `count` int(10) unsigned DEFAULT '0',
  `ontime` int(11) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `index_sense_channel` (`id`,`count`,`ontime`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;


--
-- 테이블 구조 `sense_ip`
--

CREATE TABLE IF NOT EXISTS `sense_ip` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `ip` varchar(20) COLLATE latin1_general_ci DEFAULT NULL COMMENT 'YYMMDDHH 형식',
  `count` int(10) unsigned DEFAULT '0',
  `ontime` int(11) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `index_sense_ip` (`id`,`ontime`,`ip`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;


--
-- 테이블 구조 `sense_time`
--

CREATE TABLE IF NOT EXISTS `sense_time` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(45) COLLATE latin1_general_ci NOT NULL,
  `ontime` int(10) unsigned DEFAULT NULL COMMENT 'YYMMDDHH 형식',
  `count` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`no`),
  KEY `sense_time_time` (`id`,`ontime`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;
